/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.Vector;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.SubjectAclEntry;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.security.prAccessor;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.SessionConfig;

public final class DelAclEntryEvent
extends SecurityEvent {
    private SubjectAclEntry m_delEntry;

    DelAclEntryEvent(SecurityBean source, long starttime, int vtime, String subject, SubjectAclEntry oldEntry, SubjectAclEntry delEntry) {
        super(source, starttime, vtime);
        this.m_subject = subject;
        this.m_aclEntry = oldEntry;
        this.m_delEntry = delEntry;
    }

    DelAclEntryEvent() {
    }

    public SubjectAclEntry getDelEntry() {
        return this.m_delEntry;
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processDelAclEntryEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        try {
            if (this.m_delEntry == null || this.m_aclEntry.isEmpty()) {
                ss.removeSubjectObject(this.m_subject, (ISubjectMatchObject)this.m_aclEntry);
            } else {
                ss.put(this.m_subject, (ISubjectMatchObject)this.m_aclEntry);
            }
        }
        catch (EInvalidSubjectSyntax e) {
            String mf54 = prAccessor.getString("STR142");
            Object[] ob54 = new Object[]{this.m_subject};
            SessionConfig.logMessage(MessageFormat.format(mf54, ob54), SessionConfig.getLevelWarning());
        }
        ss.resetCache();
    }

    @Override
    short getType() {
        return 5;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_subject);
        out.writeUTF(this.m_aclEntry.getPrincipal().getName());
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        this.m_subject = in.readUTF();
        String pname = in.readUTF();
        ProgressPrincipal p = cache.getPrincipal(pname);
        if (p == null) {
            p = new ProgressGroup(pname);
        }
        this.m_aclEntry = new SubjectAclEntry(p);
        Vector<SubjectAclEntry> acls = cache.getAclEntries(this.m_subject);
        if (acls.contains(this.m_aclEntry)) {
            this.m_aclEntry = acls.elementAt(acls.indexOf(this.m_aclEntry));
        }
    }
}

