/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;

public final class NewRoutingUserAclEntryEvent
extends SecurityEvent {
    private RoutingUserAclEntry m_acl = null;

    NewRoutingUserAclEntryEvent(SecurityBean source, long starttime, int vtime, String nodeName, RoutingUserAclEntry ruae) {
        super(source, starttime, vtime);
        this.m_subject = nodeName;
        this.m_acl = ruae;
    }

    NewRoutingUserAclEntryEvent() {
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processNewRoutingUserAclEntryEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
    }

    @Override
    short getType() {
        return 13;
    }

    public RoutingUserAclEntry getAcl() {
        return this.m_acl;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_subject);
        out.writeUTF(this.m_acl.getPrincipal().getName());
        out.writeBoolean(this.m_acl.getPermission());
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        this.m_subject = in.readUTF();
        String pname = in.readUTF();
        ProgressPrincipal p = cache.getPrincipal(pname);
        if (p == null) {
            p = new ProgressGroup(pname);
        }
        this.m_acl = new RoutingUserAclEntry(p, this.m_subject);
        this.m_acl.setPermission(in.readBoolean());
    }
}

