/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentSubjectSpace;
import progress.message.security.AddGroupMemberEvent;
import progress.message.security.NewAclEntryEvent;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ProgressPasswordUser;

public final class NewUserEvent
extends SecurityEvent {
    private SecurityEvent[] m_subevts;

    NewUserEvent(SecurityBean source, long starttime, int vtime, ProgressPasswordUser user, SecurityEvent[] subevts) {
        super(source, starttime, vtime);
        this.m_user = user;
        this.m_subevts = subevts;
    }

    NewUserEvent() {
    }

    public SecurityEvent[] getSubevents() {
        return this.m_subevts;
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processNewUserEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        for (int i = 0; i < this.m_subevts.length; ++i) {
            this.m_subevts[i].updateSubjectSpace(ss);
        }
    }

    @Override
    short getType() {
        return 6;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_user.getName());
        byte[] pass = this.m_user.getTestPattern();
        out.writeInt(pass.length);
        out.write(pass);
        if (this.m_user.getRoutingNodeName() == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.m_user.getRoutingNodeName());
        }
        out.writeInt(this.m_subevts.length);
        for (int i = 0; i < this.m_subevts.length; ++i) {
            this.m_subevts[i].serialize(out);
        }
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        String username = in.readUTF();
        byte[] pass = new byte[in.readInt()];
        in.readFully(pass);
        String routingNodeName = in.readByte() == 0 ? null : in.readUTF();
        this.m_user = new ProgressPasswordUser(username, pass);
        this.m_user.setRoutingNodeName(routingNodeName);
        this.m_subevts = new SecurityEvent[in.readInt()];
        for (int i = 0; i < this.m_subevts.length; ++i) {
            this.m_subevts[i] = SecurityEvent.readEvent(in, cache);
            if (this.m_subevts[i] instanceof NewAclEntryEvent) {
                this.m_subevts[i].m_aclEntry = this.m_subevts[i].m_aclEntry.copyForPrincipal(this.m_user);
                continue;
            }
            if (!(this.m_subevts[i] instanceof AddGroupMemberEvent)) continue;
            this.m_subevts[i].m_user = this.m_user;
        }
    }
}

