/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.QOP;

public final class SecDBReinitEvent
extends SecurityEvent {
    private Hashtable m_acls;
    private Hashtable m_qops;

    SecDBReinitEvent(SecurityBean source, long starttime, int vtime, Hashtable acls, Hashtable qops) {
        super(source, starttime, vtime);
        this.m_acls = acls;
        this.m_qops = qops;
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        String subject;
        Enumeration enu = this.m_acls.keys();
        while (enu.hasMoreElements()) {
            subject = (String)enu.nextElement();
            Vector acls = (Vector)this.m_acls.get(subject);
            for (int i = acls.size() - 1; i >= 0; --i) {
                ss.removeSubjectObject(subject, (ISubjectMatchObject)((SubjectAclEntry)acls.elementAt(i)));
            }
        }
        enu = this.m_qops.keys();
        while (enu.hasMoreElements()) {
            subject = (String)enu.nextElement();
            ss.removeSubjectObject(subject, (ISubjectMatchObject)((QOP)this.m_qops.get(subject)));
        }
        ss.resetCache();
        ss.loadPolicies();
    }

    @Override
    short getType() {
        return -1;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        throw new EAssertFailure("Attempted to serialize SecDBReinitEvent");
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        throw new EAssertFailure("Attempted to unserialize SecDBReinitEvent");
    }
}

