/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import progress.message.broker.AgentSubjectSpace;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.security.prAccessor;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.QOP;
import progress.message.zclient.SessionConfig;

public final class SetQOPEvent
extends SecurityEvent {
    SetQOPEvent(SecurityBean source, long starttime, int vtime, String subject, QOP qop) {
        super(source, starttime, vtime);
        this.m_subject = subject;
        this.m_qop = qop;
    }

    SetQOPEvent() {
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processSetQOPEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        try {
            ss.put(this.m_subject, (ISubjectMatchObject)this.m_qop);
        }
        catch (EInvalidSubjectSyntax e) {
            String mf40 = prAccessor.getString("STR134");
            Object[] ob40 = new Object[]{this.m_subject};
            SessionConfig.logMessage(MessageFormat.format(mf40, ob40), SessionConfig.getLevelWarning());
        }
        ss.resetCache();
    }

    @Override
    short getType() {
        return 1;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_subject);
        out.writeObject(this.m_qop);
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        try {
            super.unserialize(in, cache);
            this.m_subject = in.readUTF();
            this.m_qop = (QOP)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.toString());
        }
    }
}

