/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentSubjectSpace;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;

public final class UpdateUserEvent
extends SecurityEvent {
    private ProgressPasswordUser m_newUser;

    UpdateUserEvent(SecurityBean source, long starttime, int vtime, ProgressPasswordUser user, ProgressPasswordUser newUser) {
        super(source, starttime, vtime);
        this.m_user = user;
        this.m_newUser = newUser;
    }

    UpdateUserEvent() {
    }

    ProgressPasswordUser getNewUser() {
        return this.m_newUser;
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processUpdateUserEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
    }

    @Override
    short getType() {
        return 7;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_user.getName());
        byte[] pass = this.m_newUser.getTestPattern();
        out.writeInt(pass.length);
        out.write(pass);
        if (this.m_newUser.getRoutingNodeName() == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(this.m_newUser.getRoutingNodeName());
        }
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        String username = in.readUTF();
        ProgressPrincipal p = cache.getPrincipal(username);
        this.m_user = p instanceof ProgressPasswordUser ? (ProgressPasswordUser)p : new ProgressPasswordUser(username, "");
        byte[] pass = new byte[in.readInt()];
        in.readFully(pass);
        String routingNodeName = in.readByte() == 0 ? null : in.readUTF();
        this.m_newUser = new ProgressPasswordUser(username, pass);
        this.m_newUser.setRoutingNodeName(routingNodeName);
    }
}

