/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;

public class ByteBufferOutputStream
extends ByteArrayOutputStream
implements DataOutput {
    public ByteBufferOutputStream() {
    }

    public ByteBufferOutputStream(int size) {
        super(size);
    }

    public ByteBufferOutputStream(byte[] initBuffer) {
        this.buf = initBuffer;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void setOffset(int offset) {
        this.count = offset;
    }

    @Override
    public void write(byte[] b) throws NullPointerException {
        try {
            super.write(b, 0, b.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException {
        super.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        super.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        super.write(v);
    }

    @Override
    public void writeShort(int v) {
        super.write((byte)(0xFF & v >> 8));
        super.write((byte)(0xFF & v));
    }

    @Override
    public void writeChar(int v) {
        super.write((byte)(0xFF & v >> 8));
        super.write((byte)(0xFF & v));
    }

    @Override
    public void writeInt(int v) {
        super.write((byte)(0xFF & v >> 24));
        super.write((byte)(0xFF & v >> 16));
        super.write((byte)(0xFF & v >> 8));
        super.write((byte)(0xFF & v));
    }

    @Override
    public void writeLong(long v) {
        super.write((byte)(0xFFL & v >> 56));
        super.write((byte)(0xFFL & v >> 48));
        super.write((byte)(0xFFL & v >> 40));
        super.write((byte)(0xFFL & v >> 32));
        super.write((byte)(0xFFL & v >> 24));
        super.write((byte)(0xFFL & v >> 16));
        super.write((byte)(0xFFL & v >> 8));
        super.write((byte)(0xFFL & v));
    }

    @Override
    public void writeFloat(float v) {
        int raw = Float.floatToIntBits(v);
        this.writeInt(raw);
    }

    @Override
    public void writeDouble(double v) {
        long raw = Double.doubleToLongBits(v);
        this.writeLong(raw);
    }

    @Override
    public void writeBytes(String s) throws NullPointerException {
        char[] cc;
        if (s == null) {
            throw new NullPointerException();
        }
        for (char c : cc = s.toCharArray()) {
            super.write(c);
        }
    }

    @Override
    public void writeChars(String s) throws NullPointerException {
        char[] cc;
        if (s == null) {
            throw new NullPointerException();
        }
        this.writeShort((short)s.length());
        for (char c : cc = s.toCharArray()) {
            this.writeChar(c);
        }
    }

    @Override
    public void writeUTF(String s) throws NullPointerException {
        char[] cc;
        if (s == null) {
            throw new NullPointerException();
        }
        int saveCountPos = this.count;
        this.writeShort(0);
        for (char c : cc = s.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                super.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                super.write((byte)(0xE0 | c >> 12 & 0xF));
                super.write((byte)(0x80 | c >> 6 & 0x3F));
                super.write((byte)(0x80 | c & 0x3F));
                continue;
            }
            super.write((byte)(0xC0 | c >> 6 & 0x1F));
            super.write((byte)(0x80 | c & 0x3F));
        }
        int utflen = this.count - saveCountPos - 2;
        this.buf[saveCountPos] = (byte)(0xFF & utflen >> 8);
        this.buf[saveCountPos + 1] = (byte)(0xFF & utflen);
    }
}

