/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import progress.message.util.server.LongVectorEnum;

public class LongVector
implements Cloneable,
Serializable {
    private static final int INITIAL_CAPACITY = 100;
    private static final int CAPACITY_INCREMENT = 50;
    protected int initialCapacity;
    protected int capacityIncrement;
    protected int elementCount;
    protected long[] elementData;

    public LongVector(int initialCapacity, int capacityIncrement) {
        this.initialCapacity = initialCapacity;
        this.capacityIncrement = capacityIncrement;
        this.elementData = new long[initialCapacity];
        this.elementCount = 0;
    }

    public LongVector(int initialCapacity) {
        this(initialCapacity, 50);
    }

    public LongVector() {
        this(100, 50);
    }

    public final synchronized void addElement(long lng) {
        if (1 >= this.elementData.length - this.elementCount) {
            long[] temp = new long[this.elementData.length + 50];
            System.arraycopy(this.elementData, 0, temp, 0, this.elementData.length);
            this.elementData = temp;
        }
        this.elementData[this.elementCount] = lng;
        ++this.elementCount;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public synchronized Object clone() {
        LongVector lv = new LongVector(this.elementData.length, this.capacityIncrement);
        System.arraycopy(this.elementData, 0, lv.elementData, 0, this.elementData.length);
        lv.elementCount = this.elementCount;
        return lv;
    }

    public final boolean contains(long lng) {
        boolean fnd = false;
        for (int i = 0; i < this.elementCount; ++i) {
            if (lng != this.elementData[i]) continue;
            fnd = true;
            break;
        }
        return fnd;
    }

    public final synchronized void copyInto(long[] lngArray) {
        if (lngArray == null) {
            return;
        }
        if (this.elementCount > lngArray.length) {
            return;
        }
        System.arraycopy(this.elementData, 0, lngArray, 0, this.elementCount);
    }

    public final synchronized long elementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (0 > index || this.elementCount <= index || this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elementData[index];
    }

    public final synchronized Enumeration elements() {
        return new LongVectorEnum((LongVector)this.clone());
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int diff = this.elementData.length - this.elementCount;
        if (diff >= minCapacity) {
            return;
        }
        int sz = 0;
        sz = this.capacityIncrement > diff ? this.capacityIncrement : (int)((double)diff * 1.5);
        long[] temp = new long[sz += this.elementData.length];
        System.arraycopy(this.elementData, 0, temp, 0, this.elementCount);
        this.elementData = temp;
    }

    public final synchronized long firstElement() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final int indexOf(long lng) {
        int i;
        if (this.isEmpty()) {
            return -1;
        }
        boolean fnd = false;
        for (i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != lng) continue;
            fnd = true;
            break;
        }
        if (fnd) {
            return i;
        }
        return -1;
    }

    public final synchronized int indexOf(long lng, int index) {
        int i;
        if (this.isEmpty()) {
            return -1;
        }
        if (0 > index || this.elementCount >= index) {
            return -1;
        }
        boolean fnd = false;
        for (i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != lng) continue;
            fnd = true;
            break;
        }
        if (fnd) {
            return i;
        }
        return -1;
    }

    public final synchronized void insertElementAt(long lng, int index) {
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized long lastElement() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final int lastIndexOf(long lng) {
        int i;
        if (this.isEmpty()) {
            return -1;
        }
        boolean fnd = false;
        for (i = this.elementCount - 1; i >= 0; --i) {
            if (this.elementData[i] != lng) continue;
            fnd = true;
            break;
        }
        if (fnd) {
            return i;
        }
        return -1;
    }

    public final synchronized void removeAllElements() {
        long[] temp = new long[this.initialCapacity];
        this.elementData = temp;
        this.elementCount = 0;
    }

    public final synchronized boolean removeElement(long lng) {
        int i;
        if (this.isEmpty()) {
            return false;
        }
        boolean fnd = false;
        for (i = 0; i < this.elementCount; ++i) {
            if (this.elementData[i] != lng) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            return false;
        }
        long[] temp = new long[this.elementData.length];
        int count = this.elementCount - 1;
        if (i == 0) {
            System.arraycopy(this.elementData, 1, temp, 0, count);
        } else if (i == this.elementCount - 1) {
            System.arraycopy(this.elementData, 0, temp, 0, count);
        } else {
            int remainder = this.elementCount - (i + 1);
            System.arraycopy(this.elementData, 0, temp, 0, i);
            System.arraycopy(this.elementData, i + 1, temp, i, remainder);
        }
        this.elementData = temp;
        --this.elementCount;
        return true;
    }

    public final synchronized void removeElementAt(int index) {
        if (this.isEmpty()) {
            return;
        }
        if (0 > index || this.elementCount <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long[] temp = new long[this.elementData.length];
        int count = this.elementCount - 1;
        if (index == 0) {
            System.arraycopy(this.elementData, 1, temp, 0, count);
        } else if (index == this.elementCount - 1) {
            System.arraycopy(this.elementData, 0, temp, 0, count);
        } else {
            int remainder = this.elementCount - (index + 1);
            System.arraycopy(this.elementData, 0, temp, 0, index);
            System.arraycopy(this.elementData, index + 1, temp, index, remainder);
        }
        this.elementData = temp;
        --this.elementCount;
    }

    public final synchronized void setElementAt(long lng, int index) {
        if (this.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (0 > index || this.elementCount <= index) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[index] = lng;
    }

    public final synchronized void setSize(int newSize) {
        if (0 > newSize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.elementCount == newSize) {
            return;
        }
        if (this.elementCount > newSize) {
            long[] temp = new long[this.elementData.length];
            System.arraycopy(this.elementData, 0, temp, 0, newSize);
            this.elementData = temp;
            this.elementCount = newSize;
        } else if (this.elementData.length > newSize) {
            this.configNewElementsToNull(newSize);
        } else {
            long[] temp = new long[newSize];
            System.arraycopy(this.elementData, 0, temp, 0, this.elementCount);
            this.elementData = temp;
            this.configNewElementsToNull(newSize);
        }
    }

    private void configNewElementsToNull(int newSize) {
        for (int i = this.elementCount; i < newSize; ++i) {
            this.elementData[i] = 0L;
        }
        this.elementCount = newSize;
    }

    public final int size() {
        return this.elementCount;
    }

    public final synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LongVector information:\n");
        sb.append("\tinitial capacity: ");
        sb.append(Long.toString(this.initialCapacity));
        sb.append("\n\tcapacity increment: ");
        sb.append(Long.toString(this.capacityIncrement));
        sb.append("\n\tcurrent capacity: ");
        sb.append(Long.toString(this.elementData.length));
        sb.append("\n\tcurrent size (element count): ");
        sb.append(Long.toString(this.elementCount));
        for (int i = 0; i < this.elementCount; ++i) {
            sb.append("\n\telement[" + Integer.toString(i) + "]: " + Long.toString(this.elementData[i]));
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public final synchronized void trimToSize() {
        if (this.elementData.length == this.elementCount) {
            return;
        }
        long[] temp = new long[this.elementCount];
        System.arraycopy(this.elementData, 0, temp, 0, this.elementCount);
        this.elementData = temp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((LongVector)obj).elementCount != this.elementCount) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < this.elementCount; ++i) {
            if (((LongVector)obj).elementData[i] == this.elementData[i]) continue;
            match = false;
            break;
        }
        return match;
    }

    public int hashCode() {
        long result = this.elementCount;
        for (int i = 0; i < this.elementCount; ++i) {
            result ^= this.elementData[i];
        }
        Long Lng = new Long(result);
        return Lng.intValue();
    }
}

