/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Iterator;
import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.util.IContains;
import progress.message.util.PriorityQueue;
import progress.message.zclient.IExpirePrecheck;
import progress.message.zclient.PrioQueueLimiter;

public class ExpirationPriorityQueue
extends PriorityQueue {
    protected IExpirePrecheck m_precheck = null;

    public ExpirationPriorityQueue(int numPriorities) {
        super(numPriorities);
    }

    public void setExpirePrecheck(IExpirePrecheck precheck) {
        this.m_precheck = precheck;
    }

    public synchronized void deleteDiscardables(IMgram newMgram, PrioQueueLimiter limiter) {
        IMgram currentMgram = null;
        boolean discardable = false;
        Object payload = null;
        int totalSize = 0;
        int newSize = newMgram.getLimiterSize();
        int nextPrio = 0;
        PriorityQueue.PriorityQueueToken startToken = this.m_queueEnd[nextPrio + 1];
        PriorityQueue.PriorityQueueElement nextElem = startToken.m_next;
        PriorityQueue.PriorityQueueElement currentElem = null;
        while (true) {
            if (nextElem instanceof PriorityQueue.PriorityQueueToken) {
                if (++nextPrio < this.m_numPriorities) {
                    nextElem = this.m_queueEnd[nextPrio + 1].m_next;
                    continue;
                }
                break;
            }
            currentElem = nextElem;
            nextElem = currentElem.m_next;
            discardable = false;
            payload = currentElem.getPayload();
            if (payload != null && payload instanceof IMgram && (currentMgram = (IMgram)payload).isDiscardable()) {
                discardable = true;
            }
            if (!discardable) continue;
            int deletedSize = currentMgram.getLimiterSize();
            this.deleteElem(currentElem);
            totalSize += deletedSize;
            limiter.updateSize(-deletedSize, currentMgram.getPriority());
            if (limiter.hasRoom(newSize, newMgram.getPriority())) break;
        }
        if (totalSize > 0) {
            limiter.updateMinPriority(-totalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getExpiredMsgs(PrioQueueLimiter limiter) {
        Vector<Object> v = null;
        if (this.getEnqueued() != 0) {
            ExpirationPriorityQueue expirationPriorityQueue = this;
            synchronized (expirationPriorityQueue) {
                PriorityQueue.PriorityQueueToken t = this.m_queueEnd[this.m_highestNonEmptyPriority + 1];
                PriorityQueue.PriorityQueueElement e = t.m_next;
                PriorityQueue.PriorityQueueElement current = null;
                boolean bExpired = false;
                while (e != null) {
                    if (e instanceof PriorityQueue.PriorityQueueToken) {
                        e = e.m_next;
                        continue;
                    }
                    current = e;
                    e = e.m_next;
                    Object obj = current.getPayload();
                    if (obj instanceof IMgram && ((IMgram)obj).getType() == 27) {
                        IMgram batch = (IMgram)obj;
                        if (batch.isTTE() && batch.getTTE() < System.currentTimeMillis()) {
                            bExpired = true;
                        }
                        if (!bExpired) continue;
                        this.deleteElem(current);
                        if (limiter != null) {
                            limiter.add(-batch.getLimiterSize(), batch.getPriority());
                        }
                        if (v == null) {
                            v = new Vector();
                        }
                        if (batch.getBatchHandle().isAtomic()) {
                            v.addElement(batch);
                            continue;
                        }
                        Iterator iter = batch.getBatchHandle().getBatchIterator();
                        while (iter.hasNext()) {
                            IMgram mgram = (IMgram)iter.next();
                            v.addElement(mgram);
                        }
                        continue;
                    }
                    bExpired = this.checkForExpiredMsg(current);
                    if (!bExpired) continue;
                    this.deleteElem(current);
                    if (limiter != null) {
                        IMgram mgram = (IMgram)current.getPayload();
                        limiter.add(-mgram.getLimiterSize(), mgram.getPriority());
                    }
                    if (v == null) {
                        v = new Vector<Object>();
                    }
                    v.addElement(current.getPayload());
                }
            }
        }
        return v;
    }

    public boolean isMsgExpired(Object obj) {
        long now;
        IMgram m = (IMgram)obj;
        if (m.getNoOutqueueExpire()) {
            return false;
        }
        if (this.m_precheck != null && this.m_precheck.precheck(m) != 0) {
            return true;
        }
        if (!m.isTTE()) {
            return false;
        }
        long expTm = m.getTTE();
        return expTm < (now = System.currentTimeMillis());
    }

    protected boolean checkForExpiredMsg(PriorityQueue.PriorityQueueElement elem) {
        Object obj = elem.getPayload();
        if (obj instanceof IMgram) {
            return this.isMsgExpired(obj);
        }
        return false;
    }

    protected void deleteElem(PriorityQueue.PriorityQueueElement elem) {
        PriorityQueue.PriorityQueueElement next;
        if (this.m_cursor == elem) {
            this.m_cursor = null;
        }
        PriorityQueue.PriorityQueueElement prev = elem.m_prev;
        prev.m_next = next = elem.m_next;
        next.m_prev = prev;
        int n = elem.m_prio;
        this.m_elementsEnqueued[n] = this.m_elementsEnqueued[n] - 1;
        --this.m_totalEnqueued;
        if (this.m_totalEnqueued == 0) {
            this.m_highestNonEmptyPriority = -1;
        } else if (this.m_highestNonEmptyPriority == elem.m_prio) {
            while (this.m_highestNonEmptyPriority >= 0 && this.m_elementsEnqueued[this.m_highestNonEmptyPriority] == 0) {
                --this.m_highestNonEmptyPriority;
            }
        }
    }

    public boolean remove(Object obj, int priority) {
        return this.remove(obj, priority, false);
    }

    public boolean contains(Object obj, int priority) {
        return this.contains(obj, priority, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object obj, int priority, boolean reverseTraversal) {
        ExpirationPriorityQueue expirationPriorityQueue = this;
        synchronized (expirationPriorityQueue) {
            if (this.m_elementsEnqueued[priority] > 0) {
                PriorityQueue.PriorityQueueElement elem = null;
                if (reverseTraversal) {
                    elem = this.m_queueEnd[priority];
                    elem = elem.m_prev;
                } else {
                    elem = this.m_queueEnd[priority + 1];
                    elem = elem.m_next;
                }
                while (elem != null && elem.getPriority() == priority) {
                    if (elem.getPayload().equals(obj)) {
                        this.deleteElem(elem);
                        return true;
                    }
                    if (reverseTraversal) {
                        elem = elem.m_prev;
                        continue;
                    }
                    elem = elem.m_next;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object obj, int priority, boolean reverseTraversal) {
        ExpirationPriorityQueue expirationPriorityQueue = this;
        synchronized (expirationPriorityQueue) {
            if (this.m_elementsEnqueued[priority] > 0) {
                PriorityQueue.PriorityQueueElement elem;
                if (this.m_cursor == null || priority != this.m_cursorPriority) {
                    if (reverseTraversal) {
                        this.m_cursor = this.m_queueEnd[priority];
                        this.m_cursor = this.m_cursor.m_prev;
                    } else {
                        this.m_cursor = this.m_queueEnd[priority + 1];
                        this.m_cursor = this.m_cursor.m_next;
                    }
                    this.m_cursorPriority = priority;
                }
                if ((elem = this.m_cursor) != null && elem.getPriority() == priority) {
                    do {
                        if (elem.m_implementsContains) {
                            if (((IContains)elem.getPayload()).contains(obj)) {
                                this.m_cursor = elem;
                                return true;
                            }
                        } else if (elem.getPayload().equals(obj)) {
                            this.m_cursor = elem;
                            return true;
                        }
                        if ((elem = reverseTraversal ? elem.m_prev : elem.m_next).getPriority() == priority) continue;
                        if (reverseTraversal) {
                            elem = this.m_queueEnd[priority];
                            elem = elem.m_prev;
                            continue;
                        }
                        elem = this.m_queueEnd[priority + 1];
                        elem = elem.m_next;
                    } while (elem != this.m_cursor);
                }
            }
        }
        return false;
    }
}

