/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.XmlConfigReader;
import com.sonicsw.net.http.prAccessor;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import progress.message.broker.Config;
import progress.message.crypto.PBETool;
import progress.message.resources.prMessageFormat;

public class XmlConfigFileReader
extends XmlConfigReader {
    @Override
    public InputStream getInputStream(String filename, String type, String protocol) throws ConfigurationException {
        InputStream is = null;
        String configPwd = Config.getProperty("HTTP_CONFIGURATION_DECRYPT_PASSWORD");
        if (configPwd != null) {
            try {
                byte[] inidata = PBETool.readPBEStream(filename, configPwd);
                is = new ByteArrayInputStream(inidata);
            }
            catch (FileNotFoundException fnfe) {
                Object[] obj = new Object[]{filename, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP_DIRECT_FILE_NOT_FOUND");
                throw new ConfigurationException(prMessageFormat.format(msg, obj));
            }
            catch (IOException ioe) {
                Object[] obj = new Object[]{filename, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                String msg = prAccessor.getString("HTTP_DIRECT_CONFIG_FILE_DECRYPT_ERROR");
                throw new ConfigurationException(prMessageFormat.format(msg, obj));
            }
        }
        try {
            is = new FileInputStream(filename);
        }
        catch (FileNotFoundException fnfe) {
            Object[] obj = new Object[]{filename, HttpHelper.DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_DIRECT_FILE_NOT_FOUND");
            throw new ConfigurationException(prMessageFormat.format(msg, obj));
        }
        return is;
    }
}

