/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public abstract class X509KeyManagerWrapper
implements X509KeyManager {
    private X509KeyManager m_delegate = null;
    private KeyStore m_keyStore = null;
    private String m_keyAliasToUse;
    private char[] m_keyPassword;
    protected boolean DEBUG = false;

    public void setDelegate(X509KeyManager delegate, KeyStore keystore) {
        this.m_delegate = delegate;
        this.m_keyStore = keystore;
    }

    public void setKeyAlias(String aliasToUse, char[] keyPassword) {
        this.m_keyAliasToUse = aliasToUse;
        this.m_keyPassword = keyPassword;
    }

    public X509KeyManager getDelegate() {
        return this.m_delegate;
    }

    public KeyStore getKeyStore() {
        return this.m_keyStore;
    }

    protected String getKeyAlias() {
        return this.m_keyAliasToUse;
    }

    protected char[] getKeyPassword() {
        return this.m_keyPassword;
    }

    public void setDebug(boolean b) {
        this.DEBUG = b;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        throw new SecurityException("Choosing the client alias to use is not supported.");
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        throw new SecurityException("Choosing the server alias to use is not supported.");
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey key;
        block5: {
            key = null;
            if (this.m_keyAliasToUse.equals(alias) && this.m_keyStore != null && this.m_keyPassword != null) {
                try {
                    key = (PrivateKey)this.m_keyStore.getKey(alias, this.m_keyPassword);
                }
                catch (Exception ex) {
                    if (!this.DEBUG) break block5;
                    ex.printStackTrace();
                }
            }
        }
        if (key == null) {
            key = this.m_delegate.getPrivateKey(alias);
        }
        if (this.DEBUG) {
            System.out.println(this.getClass().getName() + ".getPrivateKey(): retrieving private key for alias = " + alias + (key == null ? " Failed" : " OK"));
        }
        return key;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain = this.m_delegate.getCertificateChain(alias);
        if (this.DEBUG) {
            String s = this.getClass().getName() + ".getCertificateChain(): retrieving certificate chain for " + alias;
            if (chain != null) {
                System.out.println(s + " OK, subject DN is " + chain[0].getSubjectDN());
            } else {
                System.out.println(s + " Failed.");
            }
        }
        return chain;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (this.DEBUG) {
            System.out.println(this.getClass().getName() + ".getClientAliases(): keyType = " + keyType + ", issue(s):\n");
            if (issuers != null) {
                for (int i = 0; i < issuers.length; ++i) {
                    System.out.println("issuers # " + (i + 1) + " : " + issuers[i]);
                }
            }
        }
        String[] validAliases = this.m_delegate.getClientAliases(keyType, issuers);
        if (this.DEBUG) {
            System.out.println(this.getClass().getName() + ".getClientAliases(): returning " + validAliases);
        }
        return validAliases;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (this.DEBUG) {
            System.out.println(this.getClass().getName() + ".getServerAliases(): keyType = " + keyType + ", issue(s):\n");
            if (issuers != null) {
                for (int i = 0; i < issuers.length; ++i) {
                    System.out.println("issuers # " + (i + 1) + " : " + issuers[i]);
                }
            }
        }
        String[] validAliases = this.m_delegate.getServerAliases(keyType, issuers);
        if (this.DEBUG) {
            System.out.println(this.getClass().getName() + ".getServerAliases(): returning " + validAliases);
        }
        return validAliases;
    }
}

