/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrowsableBaseQueue;
import progress.message.broker.BrowserElement;
import progress.message.broker.Config;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IExpirable;
import progress.message.broker.IReceivable;
import progress.message.broker.IRecycler;
import progress.message.broker.ISavable;
import progress.message.broker.ISavableQueueContext;
import progress.message.broker.ISelectable;
import progress.message.broker.ISizeChangeListener;
import progress.message.broker.LogManager;
import progress.message.broker.MessageGroupSelector;
import progress.message.broker.MessageGroupTable;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.SavableQElement;
import progress.message.broker.SelectorElement;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.EvalNumberException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.TokenMgrError;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.LongHashTable;
import progress.message.util.server.LongVector;

public final class AdministrativelyCreatedQueue
extends BrowsableBaseQueue
implements IExpirable,
IReceivable,
IRecycler,
ISavable,
ISelectable {
    private static final byte REENQUEUE_COUNT = 1;
    LongVector m_receivers;
    LongHashTable m_browsers;
    LongHashTable m_selectors;
    long m_saveThreshold;
    long m_currentInMemorySize;
    QToken[] m_inMemoryListTokens;
    Vector m_recycledQElements;
    long m_maxRecycledQElementCount;
    BrowsableBaseQueue.BrowseResultsContainer m_theBrowseResultsContainer;
    LogManager m_logMgr;
    ISizeChangeListener m_sizeChangeListener;
    Object m_saveObj = new Object();
    boolean cancelRecycler;
    private IAgentQueue m_parent = null;
    private boolean m_isMessageGroupEnabled = false;
    private String m_messageGroupIdPropertyName = "JMSXGroupID";
    private String m_messageGroupSeqPropertyName = "JMSXGroupSeq";
    private MessageGroupTable m_messageGroupTable = null;
    private int m_messageGroupIdleTimeout = -1;
    private int m_messageGroupMinReceiversToDispatch = 2;
    private int m_messageGroupMaxWaitTimeToDispatch = 10000;
    public static final long s_DFLT_SAVE_THRESHOLD = 0x180000L;
    public static final long s_DFLT_MAX_QUEUE_SIZE = 0x100000L;
    static final int s_SAVABLE_QUEUE_ELEMENT_TYPE_CODE = 1;

    public void setParent(IAgentQueue parent) {
        this.m_parent = parent;
    }

    public void setMessageGroupIdPropertyName(String name) {
        this.m_messageGroupIdPropertyName = name;
    }

    public String getMessageGroupIdPropertyName() {
        return this.m_messageGroupIdPropertyName;
    }

    public void setMessageGroupSeqPropertyName(String name) {
        this.m_messageGroupSeqPropertyName = name;
    }

    public String getMessageGroupSeqPropertyName(String name) {
        return this.m_messageGroupSeqPropertyName;
    }

    public void setMessageGroupIdleTimeoutInMiliSeconds(int timeoutInMiliseconds) {
        this.m_messageGroupIdleTimeout = timeoutInMiliseconds;
        if (this.m_messageGroupTable != null && this.m_messageGroupTable.getGroupIdleTimeout() != this.m_messageGroupIdleTimeout) {
            this.m_messageGroupTable.setGroupIdleTimeout(this.m_messageGroupIdleTimeout);
        }
    }

    public void setMessageGroupMaxWaitTimeInMiliSeconds(int waitInMiliseconds) {
        this.m_messageGroupMaxWaitTimeToDispatch = waitInMiliseconds;
    }

    public void setMessageGroupMinReceivers(int minReceivers) {
        this.m_messageGroupMinReceiversToDispatch = minReceivers;
    }

    public void enableMessageGroup(String groupID, int idleTimeoutInSeconds, int maxWaitTimeInSeconds, int minReceivers) {
        this.m_isMessageGroupEnabled = true;
        if (groupID != null && groupID.length() > 0) {
            this.setMessageGroupIdPropertyName(groupID);
        }
        if (idleTimeoutInSeconds > 0) {
            this.setMessageGroupIdleTimeoutInMiliSeconds(idleTimeoutInSeconds * 1000);
        }
        if (maxWaitTimeInSeconds >= 0) {
            this.setMessageGroupMaxWaitTimeInMiliSeconds(maxWaitTimeInSeconds * 1000);
        }
        if (minReceivers > 0) {
            this.setMessageGroupMinReceivers(minReceivers);
        }
        if (this.DEBUG) {
            this.debug("enabling message group for queue " + this.m_qName + ", group idle timeout = " + this.m_messageGroupIdleTimeout + ", dispatch wait time = " + this.m_messageGroupMaxWaitTimeToDispatch + ", min receivers to start = " + this.m_messageGroupMinReceiversToDispatch);
        }
        this.m_messageGroupTable = new MessageGroupTable(8, Config.MAX_MESSAGE_GROUPS, this);
        if (this.m_messageGroupIdleTimeout > 0) {
            this.m_messageGroupTable.setGroupIdleTimeout(this.m_messageGroupIdleTimeout);
        }
    }

    public boolean isMessageGroupEnabled() {
        return this.m_isMessageGroupEnabled;
    }

    public AdministrativelyCreatedQueue(String qName, int numPriorities, int maxQueueSize, ISavableQueueContext sqc, Hashtable env) {
        super(qName, numPriorities, maxQueueSize, sqc);
        this.debugName("AdministrativelyCreatedQueue");
        this.m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        this.m_saveThreshold = 0x180000L;
        this.m_currentInMemorySize = 0L;
        this.m_inMemoryListTokens = new QToken[this.m_numPriorities + 1];
        for (int i = 0; i <= this.m_numPriorities; ++i) {
            this.m_inMemoryListTokens[i] = new QToken();
            if (i <= 0) continue;
            this.m_inMemoryListTokens[i - 1].m_prev = this.m_inMemoryListTokens[i];
            this.m_inMemoryListTokens[i].m_next = this.m_inMemoryListTokens[i - 1];
        }
        this.m_maxRecycledQElementCount = 50L;
        this.m_recycledQElements = new Vector();
        this.m_theBrowseResultsContainer = new BrowsableBaseQueue.BrowseResultsContainer(this);
    }

    void setSizeChangeListener(ISizeChangeListener l) {
        this.m_sizeChangeListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(IMgram m) {
        boolean needDbWait = false;
        if (m == null) {
            return;
        }
        Object object = this.m_saveObj;
        synchronized (object) {
            try {
                AdministrativelyCreatedQueue administrativelyCreatedQueue = this;
                synchronized (administrativelyCreatedQueue) {
                    long tracking = m.getGuarenteedTrackingNum();
                    byte prio = m.getPriority();
                    long len = m.getEnqueuedSize();
                    SavableQElement elem = this.createQueueElemForPayload(len, m, prio, tracking);
                    if (m.getBrokerHandle().isFromDB()) {
                        elem.setSaved();
                        elem.setInDB();
                    }
                    m.getBrokerHandle().setPtpEnqueueTime(0L);
                    elem.setEnqueueTime(System.currentTimeMillis());
                    super.enqueue(elem, prio, len);
                    this.linkInMemory(elem, prio);
                    this.updateSelectorsOnEnqueue(elem);
                    if (this.m_currentInMemorySize > this.m_saveThreshold) {
                        needDbWait = this.enforceSaveThreshold(true);
                    }
                    this.notifySizeChange();
                    this.notifyAll();
                }
            }
            finally {
                if (needDbWait) {
                    ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().finishEnqueues();
                }
            }
        }
    }

    public synchronized void reenqueue(IMgram m, boolean preserveRedelivery) {
        if (m == null) {
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        SavableQElement elem = this.createQueueElemForPayload(len, m, prio, tracking);
        long tm = m.getBrokerHandle().getPtpEnqueueTime();
        if (tm > 0L) {
            elem.setEnqueueTime(tm);
            m.getBrokerHandle().setPtpEnqueueTime(0L);
        } else {
            elem.setEnqueueTime(System.currentTimeMillis());
        }
        if (m.getBrokerHandle().isFromDB()) {
            elem.setSaved();
            elem.setInDB();
        } else if (m.getBrokerHandle().isDBSaveRequested()) {
            elem.setSaved();
        }
        super.reenqueue(elem, prio, len, preserveRedelivery);
        this.relinkInMemory(elem, prio);
        this.updateSelectorsOnReenqueue(elem);
        this.notifySizeChange();
        this.notifyAll();
    }

    private SavableQElement createQueueElemForPayload(long len, IMgram m, int prio, long tracking) {
        long tte = m.getTTE();
        m.getBrokerHandle().setLocalQueueName(this.m_qName);
        SavableQElement elem = (SavableQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new SavableQElement(m, tracking, prio, len, tte);
        }
        return elem;
    }

    @Override
    public synchronized Object dequeue(int prio) {
        SavableQElement elem = null;
        while ((elem = (SavableQElement)super.dequeue(prio)) != null) {
            int expiredReason;
            this.cancelPendingSave(elem);
            IMgram payload = (IMgram)elem.getPayload();
            if (payload != null) {
                this.delinkInMemory(elem);
            }
            if ((expiredReason = this.retrieveExpiredReason(elem)) != 0) {
                this.updateDataAddExpiredMsgAndRecyle(elem, payload, expiredReason);
                continue;
            }
            if (payload != null) break;
            payload = this.tryRetrieve(elem);
            if (payload == null) {
                this.updateSelectorsOnDequeue(elem);
                this.updateBrowsersOnDequeue(elem);
                AdministrativelyCreatedQueue.cleanMessage(elem);
                this.recycle(elem, 1);
                continue;
            }
            elem.setPayload(payload);
            break;
        }
        return this.onDequeue(elem);
    }

    @Override
    public synchronized Object dequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    public synchronized Object dequeueByTrackingNum(long tracking) {
        SavableQElement elem = (SavableQElement)super.dequeue(tracking);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        } else {
            payload = this.tryRetrieve(elem);
            if (payload == null) {
                AdministrativelyCreatedQueue.cleanMessage(elem);
            } else {
                elem.setPayload(payload);
            }
        }
        return this.onDequeue(elem);
    }

    private static void cleanMessage(SavableQElement elem) {
        AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
        if (tracker != null) {
            try {
                tracker.canceled(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized Object dequeue(long receiverID) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        if (this.m_selectors == null) {
            return this.dequeue();
        }
        SelectorElement se = (SelectorElement)this.m_selectors.get(receiverID);
        if (se == null) {
            return this.dequeue();
        }
        SavableQElement elem = (SavableQElement)this.select(se);
        if (elem != null) {
            super.dequeue(elem);
        }
        return this.onDequeue(elem);
    }

    public synchronized Object dequeueWait() throws InterruptedException {
        while (this.m_totalEnqueuedCount == 0) {
            this.wait();
        }
        return this.dequeue();
    }

    public synchronized Object dequeueWait(long receiverID) throws InterruptedException {
        SelectorElement se = null;
        if (this.m_selectors != null) {
            se = (SelectorElement)this.m_selectors.get(receiverID);
        }
        Object payload = null;
        while (payload == null) {
            if (this.m_selectors == null || se == null) {
                while (this.m_totalEnqueuedCount == 0) {
                    this.wait();
                }
            } else {
                while (se.getAtEnd()) {
                    this.wait();
                }
            }
            payload = this.dequeue(receiverID);
        }
        return payload;
    }

    @Override
    public synchronized void clear() throws InterruptedException {
        Enumeration enumeration;
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        if (this.DEBUG) {
            this.debug("Starting clear() of queue " + this.m_qName);
        }
        QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (next != null) {
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            SavableQElement sqe = (SavableQElement)next;
            boolean lastOne = this.m_totalEnqueuedCount == 1;
            this.cancelPendingSave(sqe);
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(sqe.getTracking());
            if (tracker != null) {
                tracker.canceled(lastOne);
            } else if (sqe.isSaved()) {
                boolean deleted = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().deleteMsg(this.m_qName, sqe.getTracking(), true);
                QueueMsgAckedEvt evt = new QueueMsgAckedEvt(sqe.getTracking(), null, deleted);
                IMgram msg = (IMgram)sqe.getPayload();
                if (msg != null) {
                    evt.setReplicateOnly(msg.isNonPersistentReplicated());
                }
                this.m_logMgr.addEvent(evt, lastOne);
                if (lastOne) {
                    this.m_logMgr.waitForFlush(evt);
                }
            }
            next = sqe.getNext();
            super.dequeue(sqe);
            if (sqe.getPayload() != null) {
                this.delinkInMemory(sqe);
            }
            this.recycle(sqe, 1);
        }
        if (this.m_selectors != null) {
            enumeration = this.m_selectors.elements();
            SelectorElement se = null;
            while (enumeration.hasMoreElements()) {
                se = (SelectorElement)enumeration.nextElement();
                if (se == null) continue;
                se.resetCursor();
            }
        }
        if (this.m_browsers != null) {
            enumeration = this.m_browsers.elements();
            BrowserElement be = null;
            while (enumeration.hasMoreElements()) {
                be = (BrowserElement)enumeration.nextElement();
                if (be == null) continue;
                be.resetOnClear();
            }
        }
        ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().flush();
        this.m_totalEnqueuedCount = 0;
        this.setCurrentEnqueuedSize(0L);
        this.m_currentInMemorySize = 0L;
        for (int i = 0; i < this.m_numPriorities; ++i) {
            this.m_elementsEnqueuedCount[i] = 0;
        }
        this.m_highestNonEmptyPriority = -1;
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
        if (this.DEBUG) {
            this.debug("Completed clear() of queue " + this.m_qName);
        }
    }

    @Override
    public synchronized void unreserve(int size) {
        super.unreserve(size);
        this.notifySpaceAvailable();
    }

    @Override
    synchronized void notifySpaceAvailable() {
        long min_notifysize;
        long available = this.getCurrentAvailableSize();
        long l = min_notifysize = (long)Config.FLOW_CONTROL_NOTIFY_SIZE <= this.m_maxQueueSize ? (long)Config.FLOW_CONTROL_NOTIFY_SIZE : (long)Config.FLOW_CONTROL_DEFAULT_NOTIFY_SIZE;
        if (available > 0L && available >= min_notifysize) {
            this.m_bqc.getFlowControlManager().onSpaceAvailable(this.getQueueAddress(), available);
        }
    }

    public boolean hasMsgHitDeliveryLimit(QElement elem) {
        return Config.BROKER_MAX_DELIVERY_COUNT > 0 && elem.getReenqueueCount() >= Config.BROKER_MAX_DELIVERY_COUNT;
    }

    @Override
    public boolean hasMsgExpired(QElement elem) {
        SavableQElement selem = (SavableQElement)elem;
        long tte = selem.getTTE();
        if (tte == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= tte;
    }

    @Override
    public synchronized void checkForExpiredMsgs() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return;
        }
        QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (next != null) {
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            SavableQElement elem = (SavableQElement)next;
            next = elem.getNext();
            int expiredReason = this.retrieveExpiredReason(elem);
            if (expiredReason == 0) continue;
            this.dequeueExpiredMsg(elem, expiredReason);
        }
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
    }

    private void dequeueExpiredMsg(SavableQElement elem, int reason) {
        super.dequeue(elem);
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        }
        this.updateDataAddExpiredMsgAndRecyle(elem, payload, reason);
    }

    private void updateDataAddExpiredMsgAndRecyle(SavableQElement elem, IMgram payload, int expiredReason) {
        this.updateSelectorsOnDequeue(elem);
        this.updateBrowsersOnDequeue(elem);
        this.m_bqc.getAgentQueueProcessor().getCleanupThread().addExpiredMsg(payload, this.m_qName, elem.getTracking(), expiredReason);
        this.recycle(elem, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openLocalJMSReceiver(long receiverID, String selectorString) throws ParseException, TokenMgrError {
        AdministrativelyCreatedQueue.traceReceiverId(receiverID);
        AdministrativelyCreatedQueue administrativelyCreatedQueue = this;
        synchronized (administrativelyCreatedQueue) {
            if (this.m_receivers == null) {
                this.m_receivers = new LongVector();
            }
            if (!this.m_receivers.contains(receiverID)) {
                this.m_receivers.addElement(receiverID);
            }
            MessageSelector ms = null;
            if (this.m_isMessageGroupEnabled) {
                if (selectorString != null) {
                    throw new ParseException("Selector not allowed with the message group enabled.");
                }
                ms = new MessageGroupSelector(receiverID, this.m_messageGroupTable, this.m_messageGroupIdPropertyName, this.m_messageGroupSeqPropertyName);
            } else {
                if (selectorString == null) {
                    return true;
                }
                StringReader sr = new StringReader(selectorString);
                Selector parser = new Selector(sr);
                ms = parser.MessageSelector();
            }
            if (ms == null) {
                return false;
            }
            if (this.m_selectors == null) {
                this.m_selectors = new LongHashTable();
            }
            SelectorElement se = new SelectorElement(ms, this.m_numPriorities, this.m_queuePriorityToken, this.m_qName);
            this.m_selectors.put(receiverID, se);
        }
        if (this.m_isMessageGroupEnabled) {
            this.m_messageGroupTable.onOpenReceiver(receiverID);
            if (this.m_messageGroupMaxWaitTimeToDispatch > 0) {
                if (this.m_receivers.size() == 1) {
                    this.m_messageGroupTable.setDispatchingDelayed(true, this.m_messageGroupMaxWaitTimeToDispatch);
                } else if (this.m_receivers.size() == this.m_messageGroupMinReceiversToDispatch && this.m_messageGroupTable.isDispatchingDelayed()) {
                    this.m_messageGroupTable.setDispatchingDelayed(false, 0);
                }
            }
        }
        return true;
    }

    public synchronized boolean openRemoteReceiver(long receiverID, String selectorString) {
        if (this.m_selectors == null) {
            this.m_selectors = new LongHashTable();
        }
        MessageSelector ms = null;
        SelectorElement se = (SelectorElement)this.m_selectors.get(receiverID);
        if (selectorString.equals("")) {
            if (this.DEBUG) {
                this.debug(this.m_qName + ": openRemoteReceiver: Setting has match all selector on SelectorElement for receiverID: " + receiverID);
            }
            se = this.createSectorElement(receiverID, se);
            se.setHasMatchAllSelector();
        } else {
            StringReader sr = new StringReader(selectorString);
            Selector parser = new Selector(sr);
            try {
                ms = parser.MessageSelector();
            }
            catch (ParseException pe) {
                BrokerComponent.getComponentContext().logMessage((Throwable)pe, 2);
                return false;
            }
            catch (TokenMgrError tme) {
                BrokerComponent.getComponentContext().logMessage((Throwable)tme, 2);
                return false;
            }
            se = this.createSectorElement(receiverID, se);
            se.setMessageSelector(ms, selectorString);
        }
        return true;
    }

    private SelectorElement createSectorElement(long receiverID, SelectorElement seParam) {
        SelectorElement se = seParam;
        if (se == null) {
            se = new SelectorElement(null, this.m_numPriorities, this.m_queuePriorityToken, this.m_qName);
            this.m_selectors.put(receiverID, se);
        }
        return se;
    }

    @Override
    public synchronized void closeLocalJMSReceiver(long receiverID) {
        SelectorElement se;
        AdministrativelyCreatedQueue.traceReceiverId(receiverID);
        if (this.m_receivers != null && !this.m_receivers.isEmpty()) {
            this.m_receivers.removeElement(receiverID);
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = (SelectorElement)this.m_selectors.remove(receiverID)) != null) {
            se.recycle();
            Object var3_2 = null;
        }
    }

    private static void traceReceiverId(long receiverID) {
    }

    public synchronized boolean onDisconnectClient(long receiverID) {
        boolean initiateDispatch = false;
        if (this.m_isMessageGroupEnabled && this.m_messageGroupTable.onCloseReceiver(receiverID) && this.updateMessageGroupSelectors(this.m_selectors) > 0) {
            initiateDispatch = true;
        }
        return initiateDispatch;
    }

    public synchronized void redoQueueMessageGroupAssign(long clientId, String groupName) {
        if (this.m_isMessageGroupEnabled) {
            this.m_messageGroupTable.redoQueueMessageGroupAssign(clientId, groupName);
        }
    }

    public void redoQueueMessageGroupUnassign(List<String> groupNames) {
        if (this.m_isMessageGroupEnabled) {
            this.m_messageGroupTable.redoQueueMessageGroupUnassign(groupNames);
        }
    }

    public void redoSyncQueueMessageGroups(long clientId, List<String> groupNames) {
        if (this.m_isMessageGroupEnabled) {
            this.m_messageGroupTable.redoSyncQueueMessageGroups(clientId, groupNames);
        }
    }

    public boolean onNewMgram(IMgram m, IClientContext publisher) {
        boolean ret = true;
        if (this.m_isMessageGroupEnabled) {
            String group = MessageGroupSelector.getGroupID(m, this.m_messageGroupIdPropertyName);
            if (group == null) {
                return ret;
            }
            this.m_messageGroupTable.onNewMessage(group);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMessageGroupDispatch(boolean resetSelectors) {
        if (this.m_parent != null) {
            boolean hasSelectors;
            AdministrativelyCreatedQueue administrativelyCreatedQueue = this;
            synchronized (administrativelyCreatedQueue) {
                boolean bl = hasSelectors = this.m_selectors.size() > 0;
                if (hasSelectors && resetSelectors) {
                    this.updateMessageGroupSelectors(this.m_selectors);
                }
            }
            if (hasSelectors) {
                ((AgentAdministrativelyCreatedQueue)this.m_parent).initiateDispatching();
            }
        }
    }

    public synchronized boolean closeRemoteReceiver(long receiverID, String selectorString) {
        if (this.m_selectors == null) {
            return true;
        }
        SelectorElement se = (SelectorElement)this.m_selectors.get(receiverID);
        if (se == null) {
            return true;
        }
        if (this.DEBUG) {
            this.debug(this.m_qName + ": closeRemoteReceiver: Removing selector: " + (selectorString.equals("") ? "NO SELECTOR" : selectorString) + " from se for receiverID: " + receiverID);
        }
        if (se.removeMessageSelector(selectorString)) {
            this.m_selectors.remove(receiverID);
            if (se != null) {
                se.recycle();
                se = null;
            }
            this.traceRemovedSelectorElement(receiverID);
            return true;
        }
        if (this.DEBUG) {
            this.debug(this.m_qName + ": closeRemoteReceiver: Not removing SelectorElement since selectors are left for receiverID: " + receiverID);
        }
        return false;
    }

    public synchronized void closeRemoteReceiver(long receiverID) {
        if (this.DEBUG) {
            this.debug(this.m_qName + ": closeRemoteReceiver: Entering for receiverID: " + receiverID);
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty()) {
            SelectorElement se = (SelectorElement)this.m_selectors.remove(receiverID);
            this.traceRemovedSelectorElement(receiverID);
            if (se != null) {
                se.recycle();
                Object var3_2 = null;
            }
        }
    }

    private void traceRemovedSelectorElement(long receiverID) {
        if (this.DEBUG) {
            this.debug(this.m_qName + ": closeRemoteReceiver: Removed SelectorElement since no selector info is left for receiverID: " + receiverID);
        }
    }

    @Override
    public synchronized boolean isLocalJMSReceiverOpen(long receiverID) {
        if (this.m_receivers == null || this.m_receivers.isEmpty()) {
            return false;
        }
        boolean b = this.m_receivers.contains(receiverID);
        return b;
    }

    @Override
    public synchronized int getLocalJMSReceiverCount() {
        if (this.m_receivers == null) {
            return 0;
        }
        return this.m_receivers.size();
    }

    @Override
    public synchronized void recycle(Object obj, int typeCode) {
        SavableQElement elt;
        if (this.cancelRecycler) {
            return;
        }
        if (typeCode == 1 && !(elt = (SavableQElement)obj).isSaved()) {
            elt.recycle();
            if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
                this.m_recycledQElements.add(elt);
            }
        }
    }

    @Override
    public synchronized Object reuse(int typeCode) {
        Object obj = null;
        if (typeCode == 1 && !this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    @Override
    public synchronized void setSaveThresholdInBytes(int saveThreshold) {
        this.m_saveThreshold = Math.abs((long)saveThreshold);
    }

    @Override
    public synchronized void setSaveThresholdInKiloBytes(int svThreshold) {
        long saveThreshold = Math.abs((long)svThreshold);
        this.m_saveThreshold = saveThreshold > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : saveThreshold * 1024L;
    }

    @Override
    public synchronized long getSaveThresholdInBytes() {
        return this.m_saveThreshold;
    }

    @Override
    public synchronized int getSaveThresholdInKiloBytes() {
        int saveThreshold = (int)(this.m_saveThreshold / 1024L);
        return saveThreshold;
    }

    private boolean enforceSaveThreshold(boolean useDeferredEnqueue) {
        boolean sentOneOrMoreToDb = false;
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null && this.m_currentInMemorySize > this.m_saveThreshold) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.setPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.setPostProcess();
                sqe.setPayload(null);
            } else {
                sqe.setPostProcess();
                if (useDeferredEnqueue) {
                    ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsgDeferEnqueue(this.m_qName, sqe);
                    sentOneOrMoreToDb = true;
                    this.cancelRecycler = true;
                } else {
                    ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg(this.m_qName, sqe);
                }
                sqe.setSaved();
            }
            sqe.unsetAsyncReq();
            elem = sqe.getPrevInMemory();
            this.delinkInMemory(sqe);
        }
        return sentOneOrMoreToDb;
    }

    @Override
    protected IMgram retrieve(QElement elem) {
        IMgram payload = (IMgram)elem.getPayload();
        if (payload == null && (payload = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, elem.getTracking())) == null) {
            throw new EAssertFailure("Message to retrieve for queue " + this.m_qName + " was not found in db, QElement: " + elem.toString());
        }
        return payload;
    }

    private IMgram tryRetrieve(SavableQElement elem) {
        IMgram payload = (IMgram)elem.getPayload();
        if (payload == null && (payload = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, elem.getTracking())) == null) {
            BrokerComponent.getComponentContext().logMessage("AdministrativelyCreatedQueue: queue= " + this.m_qName + ": Message to retrieve was not found in db; SavableQElement: " + elem.toString() + " " + Thread.currentThread().getName(), 3);
        }
        return payload;
    }

    @Override
    public synchronized int restore(List elements) {
        if (elements == null) {
            return 0;
        }
        int restoredCount = 0;
        for (SavableQElement elem : elements) {
            restoredCount = this.restoreSingleElement(elem, restoredCount);
        }
        this.notifySizeChange();
        return restoredCount;
    }

    private int restoreSingleElement(SavableQElement elem, int restoredCount) {
        Object payload = elem.getPayload();
        long tracking = elem.getTracking();
        if (tracking <= 0L) {
            elem.recycle();
            return restoredCount;
        }
        int expiredReason = this.getExpiredReason(elem);
        if (expiredReason != 0) {
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addExpiredMsg((IMgram)payload, this.m_qName, tracking, expiredReason);
            elem.recycle();
            return restoredCount;
        }
        if (this.getCurrentTotalSize() + elem.getPayloadSize() < this.getSaveThresholdInBytes()) {
            IMgram mgram = this.tryRetrieve(elem);
            if (mgram == null) {
                AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
                if (tracker != null) {
                    try {
                        tracker.canceled(false);
                    }
                    catch (InterruptedException ex) {
                        this.debug("Got InterruptedException", ex);
                    }
                }
                elem.recycle();
                return restoredCount;
            }
            AdministrativelyCreatedQueue.updateMgramBrokerHandle(mgram);
            elem.setPayload(mgram);
        }
        this.updateTotalSize(elem.getPayloadSize());
        this.incrementEnqueuedCounts(elem.getPriority());
        this.updateTracker(elem, payload, tracking);
        this.updateElement(elem);
        this.updateMinEnqueueTime(restoredCount);
        return restoredCount + 1;
    }

    private int getExpiredReason(SavableQElement elem) {
        int expiredReason = this.retrieveExpiredReason(elem);
        return expiredReason;
    }

    private static void updateMgramBrokerHandle(IMgram mgram) {
        mgram.getBrokerHandle().setFromDB(true);
        mgram.getBrokerHandle().setPtpEnqueueTime(0L);
    }

    private void updateElement(SavableQElement elem) {
        elem.setInDB();
        elem.setSaved();
        elem.setEnqueueTime(System.currentTimeMillis());
        this.link(elem, elem.getPriority());
        if (elem.getPayload() != null) {
            this.linkInMemory(elem, elem.getPriority());
        }
        AdministrativelyCreatedQueue.setReenqueueCount(elem);
    }

    private void updateTracker(SavableQElement elem, Object payload, long tracking) {
        AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
        if (tracker == null) {
            try {
                tracker = new AgentQueueMsgTracker(tracking, this.m_qName, (byte)elem.getPriority(), elem.getTTE(), elem.getPayloadSize());
            }
            catch (EDuplicateKey edk) {
                tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
            }
        }
        tracker.setLocalQueueName(this.m_qName);
        tracker.saved();
        if (payload != null) {
            IMgram mgram = (IMgram)payload;
            tracker.setReplicateOnly(mgram.isNonPersistentReplicated());
        }
    }

    private static void setReenqueueCount(SavableQElement elem) {
        if (Config.PTP_REDELIVERED_ON_BROKER_RESTART) {
            elem.setReenqueueCount((byte)1);
            if (elem.getPayload() != null) {
                ((IMgram)elem.getPayload()).setSuccessor(true);
                ((IMgram)elem.getPayload()).setReenqueueCount((byte)1);
            }
        }
    }

    private void updateMinEnqueueTime(int restoredCount) {
        if (restoredCount + 1 == 1) {
            this.updateMinEnqueueTime();
        }
    }

    @Override
    public synchronized void forcedSave() {
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (!mg.isJMSPersistent()) {
                elem = sqe.getPrevInMemory();
                continue;
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.unsetPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.unsetPostProcess();
            } else {
                sqe.unsetPostProcess();
                ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg(this.m_qName, sqe);
                sqe.setSaved();
            }
            elem = sqe.getPrevInMemory();
        }
    }

    private void cancelPendingSave(SavableQElement elem) {
        elem.unsetPostProcess();
        if (elem.isSaved() && !elem.isInDB()) {
            boolean cancelled = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().cancelSave(elem.getTracking());
            if (cancelled) {
                elem.unsetSaved();
            } else {
                IMgram payload = (IMgram)elem.getPayload();
                if (payload != null) {
                    payload.getBrokerHandle().setDBSaveRequested(true);
                }
            }
        }
    }

    private void asyncRetrievalCheck() {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        if (elem.getPayload() != null) {
            return;
        }
        if (!((SavableQElement)elem).isAsyncReq()) {
            if (((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgramAsync(this.m_qName, elem.getTracking())) {
                ((SavableQElement)elem).setAsyncReq();
            } else {
                return;
            }
        }
        long totSz = elem.getPayloadSize();
        while ((elem = elem.getNext()) != null) {
            if (elem instanceof QToken) continue;
            if (totSz + elem.getPayloadSize() > this.m_saveThreshold) break;
            if (elem.getPayload() == null && !((SavableQElement)elem).isAsyncReq()) {
                if (!((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgramAsync(this.m_qName, elem.getTracking())) break;
                ((SavableQElement)elem).setAsyncReq();
            }
            totSz += elem.getPayloadSize();
        }
    }

    private void linkInMemory(SavableQElement newLast, int prio) {
        QToken token = this.m_inMemoryListTokens[prio];
        QElement oldLast = token.m_prev;
        if (oldLast instanceof QToken) {
            oldLast.m_next = newLast;
        } else {
            ((SavableQElement)oldLast).setNextInMemory(newLast);
        }
        newLast.setPrevInMemory(oldLast);
        newLast.setNextInMemory(token);
        token.m_prev = newLast;
        this.m_currentInMemorySize += newLast.getPayloadSize();
    }

    private void relinkInMemory(SavableQElement newFirst, int prio) {
        QToken token = this.m_inMemoryListTokens[prio + 1];
        QElement oldFirst = token.m_next;
        if (oldFirst instanceof QToken) {
            oldFirst.m_prev = newFirst;
        } else {
            ((SavableQElement)oldFirst).setPrevInMemory(newFirst);
        }
        newFirst.setNextInMemory(oldFirst);
        newFirst.setPrevInMemory(token);
        token.m_next = newFirst;
        this.m_currentInMemorySize += newFirst.getPayloadSize();
    }

    private void delinkInMemory(SavableQElement sqe) {
        QElement prev = sqe.getPrevInMemory();
        QElement next = sqe.getNextInMemory();
        if (prev == null || next == null) {
            return;
        }
        if (prev instanceof QToken) {
            prev.setNext(next);
        } else {
            ((SavableQElement)prev).setNextInMemory(next);
        }
        if (next instanceof QToken) {
            next.setPrevious(prev);
        } else {
            ((SavableQElement)next).setPrevInMemory(prev);
        }
        sqe.setPrevInMemory(null);
        sqe.setNextInMemory(null);
        this.m_currentInMemorySize -= sqe.getPayloadSize();
    }

    @Override
    public synchronized Object select(SelectorElement se) {
        if (se.getAtEnd()) {
            if (this.DEBUG) {
                this.debug("select(): selector has reached the end of the queue");
            }
            return null;
        }
        MessageSelector ms = se.getMessageSelector();
        boolean okToSkipMatch = se.hasMatchAllSelector();
        boolean match = false;
        QElement elem = null;
        IMgram m = null;
        int prio = se.getSearchPriority();
        while (!match && prio >= 0) {
            block17: {
                elem = se.getCursorElement(prio);
                if (elem instanceof QToken) {
                    se.setSearchPriority(--prio);
                    continue;
                }
                int expiredReason = this.retrieveExpiredReason(elem);
                if (expiredReason != 0) {
                    this.dequeueExpiredMsg((SavableQElement)elem, expiredReason);
                    prio = se.getSearchPriority();
                    continue;
                }
                m = this.retrieve((SavableQElement)elem);
                if (okToSkipMatch) {
                    match = true;
                    if (this.DEBUG) {
                        this.debug(this.m_qName + ": No need to check against any MessageSelectors contained by the SelectorElement as okToSkipMatch: " + okToSkipMatch + " m = " + m);
                    }
                } else {
                    try {
                        if (se.hasMultipleSelectors()) {
                            Enumeration msgSelectorEnum = se.getMessageSelectorList();
                            ms = null;
                            while (msgSelectorEnum.hasMoreElements() && !(match = (ms = (MessageSelector)msgSelectorEnum.nextElement()).match(m))) {
                            }
                        } else {
                            if (ms == null) {
                                throw new NullPointerException("MessageSelector is null in " + this.getClass().getName() + ".select(SelectorElement se)");
                            }
                            match = ms.match(m);
                        }
                    }
                    catch (EvalException ee) {
                        if (!(ee instanceof EvalNumberException)) break block17;
                        BrokerComponent.getComponentContext().logMessage("Selector EvalNumberException: " + ee.getMessage(), 2);
                        if (ms == null) break block17;
                        ms.dump("");
                    }
                }
            }
            if (match) continue;
            se.incrementCursor(prio);
            prio = se.getSearchPriority();
        }
        if (match) {
            this.cancelPendingSave((SavableQElement)elem);
            if (elem.getPayload() == null) {
                elem.setPayload(m);
            } else {
                this.delinkInMemory((SavableQElement)elem);
            }
            return elem;
        }
        return null;
    }

    private <T0 extends QElement> int retrieveExpiredReason(T0 elem) {
        int expiredReason = 0;
        if (this.hasMsgExpired(elem)) {
            expiredReason = 1;
        } else if (this.hasMsgHitDeliveryLimit(elem)) {
            expiredReason = 28;
        }
        return expiredReason;
    }

    private synchronized void updateSelectorsOnEnqueue(QElement elem) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnEnqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnReenqueue(QElement elem) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnReenqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnDequeue(QElement elem) {
        if (elem == null) {
            return;
        }
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnDequeue(elem);
        }
    }

    private synchronized int updateMessageGroupSelectors(LongHashTable selectors) {
        int count = 0;
        if (selectors == null || selectors.isEmpty()) {
            return count;
        }
        count = selectors.size();
        if (this.DEBUG) {
            this.debug("Updating message group selector(s), count = " + count);
        }
        Enumeration enumeration = selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.resetCursor();
        }
        return count;
    }

    synchronized void updateMessageGroupConsumerSelector(long receiverID) {
        SelectorElement se;
        if (this.DEBUG) {
            this.debug("Updating message group selector for receiver " + receiverID);
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = (SelectorElement)this.m_selectors.get(receiverID)) != null) {
            se.resetCursor();
        }
    }

    private void notifySizeChange() {
        ISizeChangeListener l = this.m_sizeChangeListener;
        if (l != null) {
            l.onSizeChange();
        }
    }

    private synchronized Object onDequeue(SavableQElement elem) {
        IMgram payload = null;
        if (elem != null) {
            this.updateSelectorsOnDequeue(elem);
            this.updateBrowsersOnDequeue(elem);
            payload = (IMgram)elem.getPayload();
            if (payload != null) {
                byte reenqueues = elem.getReenqueueCount();
                if (reenqueues > 0) {
                    payload.setSuccessor(true);
                    payload.setReenqueueCount(reenqueues);
                }
                payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
            }
            this.recycle(elem, 1);
        }
        this.asyncRetrievalCheck();
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
        return payload;
    }

    public void writeSyncGroupAssignments() throws ECannotFlushEvents {
        if (this.m_isMessageGroupEnabled) {
            this.m_messageGroupTable.writeSyncGroupAssignments();
        }
    }
}

