/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.HashMap;
import progress.message.broker.ClientContextEventHandlerForPASS;
import progress.message.broker.IClientContextEventHandler;
import progress.message.broker.IClientContextTracker;
import progress.message.util.EAssertFailure;

public final class ClientContextTracker
implements IClientContextTracker {
    private static ClientContextTracker m_ccTracker;
    private static final Object m_syncObject;
    private HashMap m_ccUsageTable = new HashMap();
    private HashMap m_clientContextEventHandlerMap = new HashMap();

    public static ClientContextTracker getClientContextTracker() {
        return m_ccTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decreseClientContextUsageCount(String uid) {
        Object eventHandlers;
        int newUsageCount = Integer.MIN_VALUE;
        Object object = m_syncObject;
        synchronized (object) {
            if (!this.m_ccUsageTable.containsKey(uid)) {
                return Integer.MIN_VALUE;
            }
            Integer currentUsageCount = (Integer)this.m_ccUsageTable.get(uid);
            if (currentUsageCount == null || currentUsageCount < 0) {
                String s = currentUsageCount == null ? "null" : currentUsageCount.toString();
                throw new EAssertFailure("Usage count for \"" + uid + "\" was " + s + ".");
            }
            newUsageCount = currentUsageCount - 1;
            if (newUsageCount <= 0) {
                this.m_ccUsageTable.remove(uid);
            }
        }
        if (newUsageCount <= 0) {
            eventHandlers = this.getAllEventHandlers();
            if (eventHandlers != null && ((IClientContextEventHandler[])eventHandlers).length > 0) {
                for (int i = 0; i < ((IClientContextEventHandler[])eventHandlers).length; ++i) {
                    try {
                        if (eventHandlers[i] == null) continue;
                        eventHandlers[i].onRemoval(uid);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new EAssertFailure(e);
                    }
                }
            }
            return 0;
        }
        eventHandlers = m_syncObject;
        synchronized (eventHandlers) {
            this.putNewUsageCount(newUsageCount, uid);
        }
        eventHandlers = this.getAllEventHandlers();
        if (eventHandlers != null && ((IClientContextEventHandler[])eventHandlers).length > 0) {
            for (int i = 0; i < ((IClientContextEventHandler[])eventHandlers).length; ++i) {
                try {
                    if (eventHandlers[i] == null) continue;
                    eventHandlers[i].onDecrement(uid);
                    continue;
                }
                catch (Throwable e) {
                    throw new EAssertFailure(e);
                }
            }
        }
        return newUsageCount;
    }

    @Override
    public String[] getAllClientContextUids() {
        if (this.m_ccUsageTable != null) {
            String[] uids = new String[this.m_ccUsageTable.size()];
            this.m_ccUsageTable.keySet().toArray(uids);
            return uids;
        }
        return null;
    }

    @Override
    public String[] getAllEventHandlerIDs() {
        if (this.m_clientContextEventHandlerMap != null) {
            String[] handlerIds = new String[this.m_clientContextEventHandlerMap.size()];
            this.m_clientContextEventHandlerMap.keySet().toArray(handlerIds);
            return handlerIds;
        }
        return null;
    }

    @Override
    public IClientContextEventHandler[] getAllEventHandlers() {
        if (this.m_clientContextEventHandlerMap != null) {
            IClientContextEventHandler[] handlers = new IClientContextEventHandler[this.m_clientContextEventHandlerMap.size()];
            this.m_clientContextEventHandlerMap.values().toArray(handlers);
            return handlers;
        }
        return null;
    }

    @Override
    public int getCurrentClientContextUsage(String uid) {
        Integer currentUsageCount = (Integer)this.m_ccUsageTable.get(uid);
        if (currentUsageCount == null) {
            return Integer.MIN_VALUE;
        }
        return currentUsageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int increaseClientContextUsageCount(String uid) {
        int newUsageCount;
        block13: {
            newUsageCount = Integer.MIN_VALUE;
            boolean isCreatedFirstTime = false;
            Object object = m_syncObject;
            synchronized (object) {
                Integer currentUsageCount = (Integer)this.m_ccUsageTable.get(uid);
                if (currentUsageCount == null) {
                    currentUsageCount = new Integer(0);
                    isCreatedFirstTime = true;
                }
                if (currentUsageCount < 0) {
                    String s = currentUsageCount == null ? "null" : currentUsageCount.toString();
                    throw new EAssertFailure("Usage count for \"" + uid + "\" was " + s + ".");
                }
                newUsageCount = currentUsageCount + 1;
                this.putNewUsageCount(newUsageCount, uid);
            }
            IClientContextEventHandler[] eventHandlers = this.getAllEventHandlers();
            if (eventHandlers == null || eventHandlers.length <= 0) break block13;
            if (isCreatedFirstTime) {
                for (int i = 0; i < eventHandlers.length; ++i) {
                    try {
                        if (eventHandlers[i] == null) continue;
                        eventHandlers[i].onCreation(uid);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new EAssertFailure(e);
                    }
                }
            } else {
                for (int i = 0; i < eventHandlers.length; ++i) {
                    try {
                        if (eventHandlers[i] == null) continue;
                        eventHandlers[i].onIncrement(uid);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new EAssertFailure(e);
                    }
                }
            }
        }
        return newUsageCount;
    }

    private void putNewUsageCount(int newUsageCount, String uid) {
        this.m_ccUsageTable.put(uid, new Integer(newUsageCount));
    }

    @Override
    public boolean isClientContextTracked(String uid) {
        return this.m_ccUsageTable.containsKey(uid);
    }

    @Override
    public boolean isEventHandlerIdInUse(String id) {
        return this.m_clientContextEventHandlerMap.containsKey(id);
    }

    @Override
    public void registerEventHandler(String handlerId, IClientContextEventHandler handler) {
        this.m_clientContextEventHandlerMap.put(handlerId, handler);
    }

    @Override
    public void removeEventHandlers() {
        this.m_clientContextEventHandlerMap.clear();
    }

    @Override
    public void unRegisterEventHandler(String handlerId) {
        this.m_clientContextEventHandlerMap.remove(handlerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static {
        m_syncObject = new Object();
        if (m_ccTracker == null) {
            Class<ClientContextTracker> clazz = ClientContextTracker.class;
            // MONITORENTER : progress.message.broker.ClientContextTracker.class
            if (m_ccTracker == null) {
                m_ccTracker = new ClientContextTracker();
            }
            // MONITOREXIT : clazz
        }
        ClientContextEventHandlerForPASS h = new ClientContextEventHandlerForPASS();
        m_ccTracker.registerEventHandler(h.getEventHandlerId(), h);
    }
}

