/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public final class GetPreparedGlobalTransactions
implements IMessageHandler {
    private AgentRegistrar m_reg;

    GetPreparedGlobalTransactions(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block6: {
            Message req = env.getMessage();
            Message rep = new Message();
            try {
                long retrieverId = AddrUtil.getIdFromAdmin(env.getSubject());
                Vector txnInfos = this.m_reg.getTransactionMgr().getPreparedGlobalTransactions(retrieverId);
                int len = txnInfos.size();
                rep.writeInt(len);
                Enumeration enu = txnInfos.elements();
                while (enu.hasMoreElements()) {
                    rep.writeObject(enu.nextElement());
                }
                s.reply(rep, env);
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (EGeneralException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block6;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

