/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;
import progress.message.zclient.SessionConfig;

public class RoutingConnectionInfo
extends DebugObject
implements Cloneable,
Serializable,
ISubjectMatchObject {
    private String m_routingNodeName = null;
    private String m_connectionURLs = null;
    private String[] m_arrayOfConnectionURLs = null;
    private String m_userName = null;
    private byte[] m_passwordBytes = null;
    private String m_passwordString = null;
    private boolean m_loadBalance = false;
    private boolean m_sequentialLoadBalancing = false;
    private int m_timeoutSecs = 0;
    private long m_globalSubscriptionExpiration = 0L;
    private boolean m_forwardRoutings = false;
    private boolean m_staticRouting = false;
    private String m_outboundBrokerName = null;
    private boolean m_groupMessagesByUrl = true;
    private boolean m_advertised = false;
    private String m_routingAcceptor = "";
    private boolean m_propagateJMSXUserID = false;
    private IHttpProxyConfig m_proxyConfig;
    private String m_utName = null;
    private char[] m_utPassword = null;
    private String m_x509Alias = null;
    private char[] m_x509Password = null;
    private String m_destX509IssuerName = null;
    private String m_destX509SerialNumber = null;
    private long m_rmIdleTimeout = 0L;
    private long m_rmSequenceExpiration = 0L;
    public static int ROUTE_TYPE_SONIC = 0;
    public static int ROUTE_TYPE_DIRECT = 1;
    public static int ROUTE_TYPE_JMS = 2;
    public static int ROUTE_TYPE_SOAP = 3;
    public static int ROUTE_TYPE_WS = 4;
    private int m_routeType = ROUTE_TYPE_SONIC;

    public RoutingConnectionInfo() {
        super(DebugState.GLOBAL_DEBUG_ON ? "RoutingConnectionInfo" : null);
        this.m_routingNodeName = null;
    }

    public RoutingConnectionInfo(String routingNodeName) {
        this(routingNodeName, ROUTE_TYPE_SONIC);
    }

    public RoutingConnectionInfo(String routingNodeName, int routeType) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RoutingConnectionInfo" : null);
        this.m_routingNodeName = routingNodeName;
        this.setRouteType(routeType);
    }

    public String getRoutingNodeName() {
        return this.m_routingNodeName;
    }

    public String getConnectionURLs() {
        return this.m_connectionURLs;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public byte[] getPasswordBytes() {
        return this.m_passwordBytes;
    }

    public String getPassword() {
        return this.m_passwordString;
    }

    public int getTimeout() {
        return this.m_timeoutSecs;
    }

    public void setGlobalSubscriptionExpiration(long l) {
        this.m_globalSubscriptionExpiration = l;
    }

    public long getGlobalSubscriptionExpiration() {
        return this.m_globalSubscriptionExpiration;
    }

    public boolean isLoadBalance() {
        return this.m_loadBalance;
    }

    public boolean isSequentialLoadBalancing() {
        return this.m_sequentialLoadBalancing;
    }

    public boolean isForwardRoutings() {
        return this.m_forwardRoutings;
    }

    public boolean isStaticRouting() {
        return this.m_staticRouting;
    }

    public String getOutboundBrokerName() {
        return this.m_outboundBrokerName;
    }

    public int getRouteType() {
        return this.m_routeType;
    }

    public boolean isAdvertised() {
        return this.m_advertised;
    }

    public boolean groupMessagesByUrl() {
        return this.m_groupMessagesByUrl;
    }

    public String getUsernameTokenName() {
        return this.m_utName;
    }

    public char[] getUsernameTokenPassword() {
        return this.m_utPassword;
    }

    public String getX509Alias() {
        return this.m_x509Alias;
    }

    public char[] getX509Password() {
        return this.m_x509Password;
    }

    public String getDestinationX509IssuerName() {
        return this.m_destX509IssuerName;
    }

    public String getDestinationX509SerialNumber() {
        return this.m_destX509SerialNumber;
    }

    public String getRoutingAcceptor() {
        return this.m_routingAcceptor;
    }

    public long getRmIdleTimeout() {
        return this.m_rmIdleTimeout;
    }

    public long getRmSequenceExpiration() {
        return this.m_rmSequenceExpiration;
    }

    public boolean getPropagateJMSXUserID() {
        return this.m_propagateJMSXUserID;
    }

    public void setUsernameTokenName(String utName) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting UsernameToken name to " + utName);
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - Username token name \"" + utName + "\"", SessionConfig.getLevelInfo());
        this.m_utName = utName;
    }

    public void setUsernameTokenPassword(char[] pwd) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting UsernameToken password to " + new String(pwd));
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - Username token password is (re)set", SessionConfig.getLevelInfo());
        this.m_utPassword = pwd;
    }

    public void setX509Alias(String alias) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting X509V3 token alias to " + alias);
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - X509V3 token alias \"" + alias + "\"", SessionConfig.getLevelInfo());
        this.m_x509Alias = alias;
    }

    public void setX509Password(char[] pwd) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting X509V3 token password to " + new String(pwd));
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - X509V3 token password is (re)set", SessionConfig.getLevelInfo());
        this.m_x509Password = pwd;
    }

    public void setDestinationX509IssuerName(String issuer) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting destination X509v3 token, issuer name = " + issuer);
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - destination X509V3 token issuer \"" + issuer + "\"", SessionConfig.getLevelInfo());
        this.m_destX509IssuerName = issuer;
    }

    public void setDestinationX509SerialNumber(String sn) {
        if (this.DEBUG) {
            this.debug("Routing node " + this.m_routingNodeName + ": setting destination X509V3 token, serial number = " + sn);
        }
        SessionConfig.logMessage("Configuring node \"" + this.m_routingNodeName + "\" - destination X509V3 token serial number \"" + sn + "\"", SessionConfig.getLevelInfo());
        this.m_destX509SerialNumber = sn;
    }

    public void setRoutingNodeName(String routingNodeName) {
        this.m_routingNodeName = routingNodeName;
    }

    public void setConnectionURLs(String connectionURLs) {
        this.m_connectionURLs = connectionURLs;
        this.setArrayOfURLs();
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public void setPassword(byte[] passwordBytes) {
        this.m_passwordBytes = passwordBytes;
        char[] passwordChars = new char[this.m_passwordBytes.length / 2];
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.m_passwordBytes));
        try {
            for (int i = 0; i < passwordChars.length; ++i) {
                passwordChars[i] = dis.readChar();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_passwordString = new String(passwordChars);
    }

    public void setPassword(String password) {
        this.m_passwordString = password;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeChars(password);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_passwordBytes = baos.toByteArray();
    }

    public void setTimeout(int timeoutSecs) {
        this.m_timeoutSecs = timeoutSecs;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.m_loadBalance = loadBalance;
    }

    public void setSequentialLoadBalancing(boolean sequentialLoadBalancing) {
        this.m_sequentialLoadBalancing = sequentialLoadBalancing;
    }

    public void setForwardRoutings(boolean forwardRoutings) {
        this.m_forwardRoutings = forwardRoutings;
    }

    public void setStaticRouting(boolean staticRouting) {
        this.m_staticRouting = staticRouting;
    }

    public void setOutboundBrokerName(String outboundBrokerName) {
        this.m_outboundBrokerName = outboundBrokerName == null ? "" : outboundBrokerName;
    }

    public void setGroupByUrl(boolean groupByUrl) {
        this.m_groupMessagesByUrl = groupByUrl;
    }

    public void setAdvertised(boolean advertised) {
        this.m_advertised = advertised;
    }

    public final void setRouteType(int type) {
        this.m_routeType = type;
    }

    public void setRoutingAcceptor(String routingAcceptor) {
        this.m_routingAcceptor = routingAcceptor == null ? "" : routingAcceptor;
    }

    public void setRmIdleTimeout(long rmIdleTimeout) {
        this.m_rmIdleTimeout = rmIdleTimeout;
    }

    public void setRmSequenceExpiration(long rmSequenceExpiration) {
        this.m_rmSequenceExpiration = rmSequenceExpiration;
    }

    public void setPropagateJMSXUserID(boolean propagateJMSXUserID) {
        this.m_propagateJMSXUserID = propagateJMSXUserID;
    }

    public String[] getArrayOfURLs() {
        if (this.m_arrayOfConnectionURLs == null) {
            this.setArrayOfURLs();
        }
        return this.m_arrayOfConnectionURLs;
    }

    public void setArrayOfURLs() {
        if (this.m_connectionURLs == null) {
            this.m_arrayOfConnectionURLs = null;
            return;
        }
        StringTokenizer st = new StringTokenizer(this.m_connectionURLs, ",");
        int numBrokers = st.countTokens();
        if (numBrokers > 0) {
            this.m_arrayOfConnectionURLs = new String[numBrokers];
            for (int i = 0; i < numBrokers; ++i) {
                this.m_arrayOfConnectionURLs[i] = st.nextToken();
            }
        } else {
            this.m_arrayOfConnectionURLs = null;
        }
    }

    public Object clone() {
        RoutingConnectionInfo clone = null;
        try {
            clone = (RoutingConnectionInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure("caught: " + e, e);
        }
        return clone;
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeUTF(this.getRoutingNodeName());
        output.writeUTF(this.getConnectionURLs());
        output.writeUTF(this.getUserName());
        output.writeUTF(this.getPassword());
        output.writeBoolean(this.isLoadBalance());
        output.writeBoolean(this.isSequentialLoadBalancing());
        output.writeInt(this.getTimeout());
        output.writeLong(this.getGlobalSubscriptionExpiration());
        output.writeBoolean(this.isForwardRoutings());
        output.writeBoolean(this.isStaticRouting());
        output.writeUTF(this.getOutboundBrokerName());
        output.writeUTF(this.getRoutingAcceptor());
    }

    public void unserialize(DataInput input) throws IOException {
        this.setRoutingNodeName(input.readUTF());
        if (this.DEBUG) {
            this.debug("routing node: " + this.getRoutingNodeName());
        }
        this.setConnectionURLs(input.readUTF());
        if (this.DEBUG) {
            this.debug("connectionURLs: " + this.getConnectionURLs());
        }
        this.setUserName(input.readUTF());
        if (this.DEBUG) {
            this.debug("username: " + this.getUserName());
        }
        this.setPassword(input.readUTF());
        if (this.DEBUG) {
            this.debug("password: " + this.getPassword());
        }
        this.setLoadBalance(input.readBoolean());
        if (this.DEBUG) {
            this.debug("load balance: " + this.isLoadBalance());
        }
        this.setSequentialLoadBalancing(input.readBoolean());
        if (this.DEBUG) {
            this.debug("sequential: " + this.isSequentialLoadBalancing());
        }
        this.setTimeout(input.readInt());
        if (this.DEBUG) {
            this.debug("timeout: " + this.getTimeout());
        }
        this.setGlobalSubscriptionExpiration(input.readLong());
        if (this.DEBUG) {
            this.debug("sub expi: " + this.getGlobalSubscriptionExpiration());
        }
        this.setForwardRoutings(input.readBoolean());
        if (this.DEBUG) {
            this.debug("forward routings: " + this.isForwardRoutings());
        }
        this.setStaticRouting(input.readBoolean());
        if (this.DEBUG) {
            this.debug("static routing: " + this.isStaticRouting());
        }
        this.setOutboundBrokerName(input.readUTF());
        if (this.DEBUG) {
            this.debug("broker name: " + this.getOutboundBrokerName());
        }
        this.setRoutingAcceptor(input.readUTF());
        if (this.DEBUG) {
            this.debug("routing acceptor: " + this.getRoutingAcceptor());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("RoutingConnectionInfo");
        }
        this.unserialize(in);
    }

    @Override
    public String toString() {
        return "RoutingConnectionInfo(Node:" + this.m_routingNodeName + ",URLs:\"" + this.m_connectionURLs + "\",User:" + this.m_userName + ",LB:" + this.m_loadBalance + ",Seq:" + this.m_sequentialLoadBalancing + ",Timeout:" + this.m_timeoutSecs + ",Glob Sub Exp:" + this.m_globalSubscriptionExpiration + ",FWD:" + this.m_forwardRoutings + ",Static:" + this.m_staticRouting + ",Outbound Broker:" + this.m_outboundBrokerName + ",proxyHost:" + (this.m_proxyConfig != null ? this.m_proxyConfig.getHost() : " null") + ",proxyPort:" + (this.m_proxyConfig != null ? Integer.toString(this.m_proxyConfig.getPort()) : " null") + ",proxyUserName:" + (this.m_proxyConfig != null ? this.m_proxyConfig.getUserName() : " null") + ",proxyUserPassword:DO NOT DISPLAY),routingAcceptor:" + this.m_routingAcceptor;
    }

    public IHttpProxyConfig getProxyConfig() {
        return this.m_proxyConfig;
    }

    public void setProxyConfig(IHttpProxyConfig config) {
        this.m_proxyConfig = config;
    }

    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
        result.addRoutingNode(this);
    }

    @Override
    public final boolean localEffect() {
        return false;
    }

    @Override
    public boolean isBatchable() {
        return false;
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }
}

