/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.security.Principal;
import java.util.Objects;
import progress.message.zclient.Group;

public final class RoutingUserAclEntry {
    Principal m_principal;
    String m_node;
    boolean m_canSend;
    boolean m_isGroup;
    boolean m_includesGroupPerms;
    public static boolean GRANT = true;
    public static boolean DENY = false;

    public RoutingUserAclEntry(Principal principal, String node) {
        this.m_principal = principal;
        this.m_node = node;
        this.m_canSend = DENY;
        this.m_isGroup = principal instanceof Group;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public String getNode() {
        return this.m_node;
    }

    public synchronized void setPermission(boolean canSend) {
        this.m_canSend = canSend;
    }

    public synchronized void setPosPermission() {
        this.m_canSend = GRANT;
    }

    public synchronized void setNegPermission() {
        this.m_canSend = DENY;
    }

    public synchronized boolean getPermission() {
        return this.m_canSend;
    }

    public boolean checkPermission() {
        return this.m_canSend;
    }

    public RoutingUserAclEntry copyForPrincipal(Principal principal) {
        return this.copyData(principal, this.m_node);
    }

    public RoutingUserAclEntry copyForNode(String node) {
        return this.copyData(this.m_principal, node);
    }

    private RoutingUserAclEntry copyData(Principal principal, String node) {
        RoutingUserAclEntry newEntry = this.copy();
        newEntry.m_principal = principal;
        newEntry.m_isGroup = principal instanceof Group;
        newEntry.m_node = node;
        return newEntry;
    }

    private RoutingUserAclEntry copy() {
        RoutingUserAclEntry copyEntry = new RoutingUserAclEntry(this.m_principal, this.m_node);
        copyEntry.m_isGroup = this.m_isGroup;
        copyEntry.m_node = this.m_node;
        copyEntry.m_canSend = this.m_canSend;
        return copyEntry;
    }

    public boolean equals(Object obj) {
        return obj instanceof RoutingUserAclEntry && ((RoutingUserAclEntry)obj).getPrincipal().equals(this.m_principal);
    }

    public int hashCode() {
        return Objects.hash(this.m_principal);
    }
}

