/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.prAccessor;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

public class UnsubscribeAll
implements IMessageHandler {
    private static volatile AgentRegistrar m_reg;

    UnsubscribeAll(AgentRegistrar reg) {
        m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            m_reg.unsubscribeAllExternal(requestor, true, true, env);
        }
        catch (EInvalidAdminAddress eiaa) {
            BrokerComponent.getComponentContext().logMessage((Throwable)eiaa, 2);
            UnsubscribeAll.sendReply(env, 0);
        }
        catch (EClientNotRegistered ex1) {
            UnsubscribeAll.sendReply(env, 0);
        }
    }

    static void sendReply(Envelope req, int status) {
        block2: {
            try {
                Message rep = new Message();
                rep.writeShort(status);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, req, false);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR271") + e.getMessage(), (Throwable)e, 2);
            }
        }
    }
}

