/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.PublishMessage;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

class PublishEncoder
extends DemuxEncoder<PublishMessage> {
    PublishEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(PublishMessage message, IByteBuffer out) {
        if (message.getTopic() == null || message.getTopic().getName() == null || message.getTopic().getName().isEmpty()) {
            throw new MqttException("Publish with empty topic name");
        }
        ByteBuffer variableHeaderBuff = new ByteBuffer(2);
        try {
            variableHeaderBuff.merge(MqttCodecUtils.encodeString(message.getTopic().getName()));
            if (message.getQos() == MqttQoS.AT_LEAST_ONCE || message.getQos() == MqttQoS.EXACTLY_ONCE) {
                if (message.getMessageId() == null) {
                    throw new MqttException("Publish with QoS > 0 and no ID set");
                }
                variableHeaderBuff.writeUnsignedShort(message.getMessageId());
            }
            variableHeaderBuff.write(message.getPayload());
            int variableHeaderSize = variableHeaderBuff.countUnread();
            byte flags = MqttCodecUtils.encodeFlags(message);
            ByteBuffer buff = new ByteBuffer(2 + variableHeaderSize);
            buff.writeByte(0x30 | flags);
            buff.merge(MqttCodecUtils.encodeRemainingLength(variableHeaderSize));
            buff.merge(variableHeaderBuff);
            out.merge(buff);
        }
        finally {
            variableHeaderBuff.clear();
        }
    }
}

