/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.IOException;
import java.io.PrintStream;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISHA;

public final class SHA
extends MessageDigest
implements ISHA,
Cloneable {
    public static final boolean DEBUG = false;
    protected int[] data;
    protected int[] digest;
    protected byte[] tmp;
    protected int[] w;
    private byte[] contextBuf;

    @Override
    public final int hash_length() {
        return 20;
    }

    @Override
    public final int data_length() {
        return 64;
    }

    @Override
    public String name() {
        return "SHA";
    }

    public SHA() {
        this.java_init();
        this.reset();
    }

    @Override
    public Object clone() {
        SHA clone = (SHA)super.clone();
        if (this.data != null) {
            clone.data = (int[])this.data.clone();
        }
        if (this.digest != null) {
            clone.digest = (int[])this.digest.clone();
        }
        if (this.tmp != null) {
            clone.tmp = (byte[])this.tmp.clone();
        }
        if (this.w != null) {
            clone.w = (int[])this.w.clone();
        }
        if (this.contextBuf != null) {
            clone.contextBuf = (byte[])this.contextBuf.clone();
        }
        return clone;
    }

    private void java_init() {
        this.digest = new int[5];
        this.data = new int[16];
        this.tmp = new byte[64];
        this.w = new int[80];
    }

    @Override
    public void md_reset() {
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
    }

    @Override
    protected void md_transform() {
        this.java_transform();
    }

    protected void java_transform() {
        SHA.byte2int(this.data, 0, this.buf(), 0, 16);
        this.transform(this.data);
    }

    @Override
    protected void md_digest(byte[] buf, int offset, int len) {
        if (len < 20) {
            throw new EAssertFailure("len < 20");
        }
        this.java_digest(buf, offset, len);
    }

    private void java_digest(byte[] buf, int offParam, int len) {
        int off = offParam;
        int pos = this.buf_off();
        if (pos != 0) {
            System.arraycopy(this.buf(), 0, this.tmp, 0, pos);
        }
        this.tmp[pos++] = -128;
        if (pos > 56) {
            while (pos < 64) {
                this.tmp[pos++] = 0;
            }
            SHA.byte2int(this.data, 0, this.tmp, 0, 16);
            this.transform(this.data);
            pos = 0;
        }
        while (pos < 56) {
            this.tmp[pos++] = 0;
        }
        SHA.byte2int(this.data, 0, this.tmp, 0, 14);
        this.data[14] = (int)(this.bitcount() >>> 32);
        this.data[15] = (int)this.bitcount();
        this.transform(this.data);
        for (int i = 0; i < 5; ++i) {
            int d = this.digest[i];
            buf[off++] = (byte)(d >>> 24);
            buf[off++] = (byte)(d >>> 16);
            buf[off++] = (byte)(d >>> 8);
            buf[off++] = (byte)d;
        }
    }

    public static byte[] hash(String msg) {
        return SHA.hash(msg, (MessageDigest)new SHA());
    }

    public static byte[] hash(byte[] msg) {
        return SHA.hash(msg, (MessageDigest)new SHA());
    }

    protected static int f1(int a, int b, int c) {
        return (c ^ a & (b ^ c)) + 1518500249;
    }

    protected static int f2(int a, int b, int c) {
        return (a ^ b ^ c) + 1859775393;
    }

    protected static int f3(int a, int b, int c) {
        return (a & b | c & (a | b)) + -1894007588;
    }

    protected static int f4(int a, int b, int c) {
        return (a ^ b ^ c) + -899497514;
    }

    protected void transform(int[] X) {
        int i;
        int A = this.digest[0];
        int B = this.digest[1];
        int C = this.digest[2];
        int D = this.digest[3];
        int E = this.digest[4];
        int[] W = this.w;
        for (i = 0; i < 16; ++i) {
            W[i] = X[i];
        }
        for (i = 16; i < 80; ++i) {
            int j;
            W[i] = j = W[i - 16] ^ W[i - 14] ^ W[i - 8] ^ W[i - 3];
            W[i] = j << 1 | j >>> -1;
        }
        E += (A << 5 | A >>> -5) + SHA.f1(B, C, D) + W[0];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f1(A, B, C) + W[1];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f1(E, A, B) + W[2];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f1(D, E, A) + W[3];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f1(C, D, E) + W[4];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f1(B, C, D) + W[5];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f1(A, B, C) + W[6];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f1(E, A, B) + W[7];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f1(D, E, A) + W[8];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f1(C, D, E) + W[9];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f1(B, C, D) + W[10];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f1(A, B, C) + W[11];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f1(E, A, B) + W[12];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f1(D, E, A) + W[13];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f1(C, D, E) + W[14];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f1(B, C, D) + W[15];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f1(A, B, C) + W[16];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f1(E, A, B) + W[17];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f1(D, E, A) + W[18];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f1(C, D, E) + W[19];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f2(B, C, D) + W[20];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f2(A, B, C) + W[21];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f2(E, A, B) + W[22];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f2(D, E, A) + W[23];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f2(C, D, E) + W[24];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f2(B, C, D) + W[25];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f2(A, B, C) + W[26];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f2(E, A, B) + W[27];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f2(D, E, A) + W[28];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f2(C, D, E) + W[29];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f2(B, C, D) + W[30];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f2(A, B, C) + W[31];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f2(E, A, B) + W[32];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f2(D, E, A) + W[33];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f2(C, D, E) + W[34];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f2(B, C, D) + W[35];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f2(A, B, C) + W[36];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f2(E, A, B) + W[37];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f2(D, E, A) + W[38];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f2(C, D, E) + W[39];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f3(B, C, D) + W[40];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f3(A, B, C) + W[41];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f3(E, A, B) + W[42];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f3(D, E, A) + W[43];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f3(C, D, E) + W[44];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f3(B, C, D) + W[45];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f3(A, B, C) + W[46];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f3(E, A, B) + W[47];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f3(D, E, A) + W[48];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f3(C, D, E) + W[49];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f3(B, C, D) + W[50];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f3(A, B, C) + W[51];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f3(E, A, B) + W[52];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f3(D, E, A) + W[53];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f3(C, D, E) + W[54];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f3(B, C, D) + W[55];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f3(A, B, C) + W[56];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f3(E, A, B) + W[57];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f3(D, E, A) + W[58];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f3(C, D, E) + W[59];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f4(B, C, D) + W[60];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f4(A, B, C) + W[61];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f4(E, A, B) + W[62];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f4(D, E, A) + W[63];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f4(C, D, E) + W[64];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f4(B, C, D) + W[65];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f4(A, B, C) + W[66];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f4(E, A, B) + W[67];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f4(D, E, A) + W[68];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f4(C, D, E) + W[69];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f4(B, C, D) + W[70];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f4(A, B, C) + W[71];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f4(E, A, B) + W[72];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f4(D, E, A) + W[73];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f4(C, D, E) + W[74];
        C = C << 30 | C >>> -30;
        E += (A << 5 | A >>> -5) + SHA.f4(B, C, D) + W[75];
        B = B << 30 | B >>> -30;
        D += (E << 5 | E >>> -5) + SHA.f4(A, B, C) + W[76];
        A = A << 30 | A >>> -30;
        C += (D << 5 | D >>> -5) + SHA.f4(E, A, B) + W[77];
        E = E << 30 | E >>> -30;
        B += (C << 5 | C >>> -5) + SHA.f4(D, E, A) + W[78];
        D = D << 30 | D >>> -30;
        A += (B << 5 | B >>> -5) + SHA.f4(C, D, E) + W[79];
        C = C << 30 | C >>> -30;
        this.digest[0] = this.digest[0] + A;
        this.digest[1] = this.digest[1] + B;
        this.digest[2] = this.digest[2] + C;
        this.digest[3] = this.digest[3] + D;
        this.digest[4] = this.digest[4] + E;
    }

    @Override
    protected void md_update(byte[] input, int offset, int len) {
        this.java_update(input, offset, len);
    }

    public static final void byte2int(int[] dst, int dst_offParam, byte[] src, int src_off, int len) {
        int dst_off = dst_offParam;
        while (len-- > 0) {
            dst[dst_off++] = src[src_off++] << 24 | (src[src_off++] & 0xFF) << 16 | (src[src_off++] & 0xFF) << 8 | src[src_off++] & 0xFF;
        }
    }

    public static void main(String[] argv) throws IOException {
        try {
            SHA.self_test(System.out, argv);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void self_test(PrintStream out, String[] argv) throws Exception {
        SHA.test(out, "Anyone got any SHA-1 test data?", "09B9E9C04A84CE274942048ACF3A6F2FF4A8A39C");
    }

    private static void test(PrintStream out, String msg, String hashStrParam) {
        String hashStr = hashStrParam;
        hashStr = hashStr.toUpperCase();
        SHA sha = new SHA();
        sha.add(msg);
        String x = SHA.toString(sha.digest());
        out.println("Message " + msg);
        out.println("calc hash:" + x);
        out.println("real hash:" + hashStr);
        if (hashStr.equals(x)) {
            out.println("Good");
        } else {
            out.println("************* SHA FAILED **************");
        }
    }

    private static byte[] fromString(String inHex) {
        int len = inHex.length();
        int pos = 0;
        byte[] buffer = new byte[(len + 1) / 2];
        if (len % 2 == 1) {
            buffer[0] = (byte)SHA.asciiToHex(inHex.charAt(0));
            pos = 1;
            --len;
        }
        int ptr = pos;
        while (len > 0) {
            buffer[pos++] = (byte)(SHA.asciiToHex(inHex.charAt(ptr++)) << 4 | SHA.asciiToHex(inHex.charAt(ptr++)));
            len -= 2;
        }
        return buffer;
    }

    private static final String toString(byte[] buffer) {
        StringBuffer returnBuffer = new StringBuffer();
        int len = buffer.length;
        for (int pos = 0; pos < len; ++pos) {
            returnBuffer.append(SHA.hexToAscii(buffer[pos] >>> 4 & 0xF)).append(SHA.hexToAscii(buffer[pos] & 0xF));
        }
        return returnBuffer.toString();
    }

    private static final int asciiToHex(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new Error(prAccessor.getString("STR040"));
    }

    private static char hexToAscii(int h) {
        if (h >= 10 && h <= 15) {
            return (char)(65 + (h - 10));
        }
        if (h >= 0 && h <= 9) {
            return (char)(48 + h);
        }
        throw new Error(prAccessor.getString("STR041"));
    }
}

