/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse.util;

import progress.message.db.pse.IRWXLock;

public class ReentrantRWXLock
implements IRWXLock {
    private int m_activeReaders;
    private Thread m_currentWriter;
    private int m_writeLocks;
    private Thread m_currentExclusive;

    @Override
    public void acquireReadLock() {
        try {
            this.acquireReadLock(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void acquireReadLock(boolean interruptible) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t == this.m_currentWriter) {
            if (this.m_currentExclusive == null) {
                ++this.m_activeReaders;
                return;
            }
            throw new IllegalMonitorStateException("DbLock.acquireReadLock: currentHolder of ExclusiveLock cannot acquire ReadLock;");
        }
        boolean interrupted = false;
        while (this.m_currentExclusive != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (interruptible) {
                    throw e;
                }
                interrupted = true;
            }
        }
        ++this.m_activeReaders;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void acquireUpdateLock() {
        try {
            this.acquireUpdateLock(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void acquireUpdateLock(boolean interruptible) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t == this.m_currentWriter) {
            if (this.m_currentExclusive == null) {
                ++this.m_writeLocks;
                return;
            }
            throw new IllegalMonitorStateException("DbLock.acquireUpdateLock: currentHolder of ExclusiveLock cannot acquire new Locks;");
        }
        boolean interrupted = false;
        while (this.m_currentWriter != null || this.m_currentExclusive != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (interruptible) {
                    throw e;
                }
                interrupted = true;
            }
        }
        this.m_currentWriter = t;
        this.m_writeLocks = 1;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void acquireExclusiveLock() {
        boolean interrupted = false;
        Thread t = this.retrieveThread();
        if (t == this.m_currentWriter) {
            interrupted = this.performWait2(interrupted, t);
            return;
        }
        this.performWait(interrupted, t);
    }

    private void performWait(boolean interruptedParam, Thread t) {
        boolean interrupted = interruptedParam;
        while (this.m_currentWriter != null || this.m_activeReaders != 0 || this.m_currentExclusive != null) {
            interrupted = this.doWait(interrupted);
        }
        this.setCurrentThreadAndInterrupt(t, interrupted);
    }

    private boolean performWait2(boolean interruptedParam, Thread t) {
        boolean interrupted = interruptedParam;
        while (this.m_activeReaders != 0 || this.m_currentExclusive != null) {
            interrupted = this.doWait(interrupted);
        }
        this.setCurrentThreadAndInterrupt(t, interrupted);
        return interrupted;
    }

    private void setCurrentThreadAndInterrupt(Thread t, boolean interrupted) {
        this.m_currentExclusive = t;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean doWait(boolean interruptedParam) {
        boolean interrupted = interruptedParam;
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        return interrupted;
    }

    private Thread retrieveThread() {
        Thread t = Thread.currentThread();
        if (this.m_currentExclusive == t) {
            throw new IllegalMonitorStateException("DbLock.acquireExclusiveLock: owner of exclusiveLock can't acquire ExclusiveLock;");
        }
        return t;
    }

    @Override
    public synchronized void releaseReadLock() {
        --this.m_activeReaders;
        if (this.m_activeReaders == 0) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void releaseUpdateLock() {
        Thread thisThread = Thread.currentThread();
        if (thisThread == this.m_currentExclusive) {
            throw new IllegalMonitorStateException("DbLock.releaseUpdateLock: Exclusive Lock not released ");
        }
        if (thisThread == this.m_currentWriter) {
            --this.m_writeLocks;
            if (this.m_writeLocks == 0) {
                this.m_currentWriter = null;
                this.notifyAll();
            }
        } else {
            throw new IllegalMonitorStateException("DbLock.releaseUpdateLock: currentThread not owner " + thisThread + " owner= " + this.m_currentWriter);
        }
    }

    @Override
    public synchronized void releaseExclusiveLock() {
        Thread thisThread = Thread.currentThread();
        if (thisThread != this.m_currentExclusive) {
            throw new IllegalMonitorStateException("DbLock.releaseExclusiveLock: currentThread not owner " + thisThread);
        }
        this.m_currentExclusive = null;
        this.notifyAll();
    }

    @Override
    public boolean hasUpdateLock() {
        return Thread.currentThread() == this.m_currentWriter;
    }

    public boolean hasExclusiveLock() {
        return Thread.currentThread() == this.m_currentExclusive;
    }
}

