/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSInfo;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.client.EGeneralException;
import progress.message.interbroker.IBEvent;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerSession;
import progress.message.util.DebugState;
import progress.message.zclient.Connection;
import progress.message.zclient.Message;
import progress.message.zclient.SessionConfig;

public class CWADSEvent
extends IBEvent {
    private CWADSInfo m_currentInfo;
    private Message m_req;

    protected CWADSEvent(int eventType, IClientContext cc, BrokerSubscription sub) throws ESubscriptionNotFound {
        super(DebugState.GLOBAL_DEBUG_ON ? "CWADSEvent" : null);
        Interbroker ib = Interbroker.getInterbroker();
        if (ib == null) {
            return;
        }
        InterbrokerSession ibs = ib.getIBSession();
        if (ibs == null) {
            return;
        }
        Connection conn = ibs.getConnection();
        if (conn == null) {
            return;
        }
        this.m_req = new Message(SessionConfig.getAdminPrefix(conn.getEffectiveUid(), conn.getApplicationId()) + ".CWADSUpdate");
        this.m_currentInfo = new CWADSInfo(cc, sub);
        this.m_currentInfo.setType(eventType);
        try {
            this.m_currentInfo.serializeInfo(this.m_req);
        }
        catch (IOException ioe) {
            BrokerComponent.getBrokerComponent();
            BrokerComponent.logMessage("Error serializing cwads request", ioe, BrokerComponent.getLevelSevere());
        }
    }

    @Override
    public void process(Interbroker ib) {
        try {
            ib.processCWADSUpdate(this);
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
    }

    Message getMessage() {
        Message clone = (Message)this.m_req.protectedClone();
        return clone;
    }
}

