/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.client.tunnel;

import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.zclient.SessionConfig;

public class HttpProxyConfig
implements IHttpProxyConfig {
    protected static final String HTTP_PROTOCOL = "http";
    protected String m_proxyProtocol = "http";
    protected String m_proxyHost;
    protected int m_proxyPort = -1;
    protected String m_proxyUserName;
    protected String m_proxyUserPassword;

    public HttpProxyConfig() {
    }

    public HttpProxyConfig(String proxyProtocolParam, String proxyHost, int proxyPort, String userName, String userPassword) {
        String proxyProtocol = proxyProtocolParam;
        this.m_proxyProtocol = proxyProtocol = this.retrieveProxyProtocol(proxyProtocol);
        this.m_proxyHost = proxyHost;
        this.m_proxyPort = proxyPort;
        this.m_proxyUserName = userName;
        this.m_proxyUserPassword = userPassword;
    }

    @Override
    public final String getHost() {
        return this.m_proxyHost;
    }

    @Override
    public final int getPort() {
        return this.m_proxyPort;
    }

    @Override
    public final String getUserName() {
        return this.m_proxyUserName;
    }

    @Override
    public final String getUserPassword() {
        return this.m_proxyUserPassword;
    }

    @Override
    public String getProtocol() {
        return this.m_proxyProtocol;
    }

    @Override
    public final String toString() {
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + "/uid=" + this.getUserName() + ", psw=" + this.m_proxyUserPassword;
    }

    protected final void processURL(String urlParam) {
        String url = urlParam;
        if (url == null || url.trim().length() == 0) {
            return;
        }
        url = url.trim();
        String proxyPortStr = null;
        try {
            if (url.startsWith("HTTP://") || url.startsWith("http://") || url.startsWith("HTTPS://") || url.startsWith("https://")) {
                int hostIndex = url.indexOf(":");
                this.m_proxyProtocol = url.substring(0, hostIndex);
                int portIndex = url.lastIndexOf(":");
                this.m_proxyHost = url.substring(hostIndex + 3, portIndex);
                proxyPortStr = url.substring(portIndex + 1);
            } else {
                int portIndex = url.lastIndexOf(":");
                this.m_proxyHost = url.substring(0, portIndex);
                proxyPortStr = url.substring(portIndex + 1);
            }
            if (proxyPortStr != null) {
                this.m_proxyPort = Integer.parseInt(proxyPortStr);
            }
        }
        catch (Exception e) {
            String msg = "Invalid URL: " + url + ". Make sure proper URL format is used - e.g. http://host:port";
            SessionConfig.logMessage(msg, SessionConfig.INFO);
            msg = "Invalid URL: " + url + ". " + e.getClass().getName() + ". " + e.getMessage();
            SessionConfig.logMessage(msg, SessionConfig.SEVERE);
        }
        this.m_proxyProtocol = this.retrieveProxyProtocol(this.m_proxyProtocol);
    }

    private String retrieveProxyProtocol(String m_proxyProtocolParam) {
        String m_proxyProtocol = m_proxyProtocolParam;
        if (m_proxyProtocol == null || m_proxyProtocol.trim().length() == 0) {
            m_proxyProtocol = HTTP_PROTOCOL;
        }
        return m_proxyProtocol;
    }
}

