/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsse;

import java.io.File;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.cert.X509Certificate;
import progress.message.security.cert.ECertificateException;

public final class jsseX509Certificate
extends progress.message.security.cert.X509Certificate {
    private X509Certificate m_impl = null;

    protected jsseX509Certificate(X509Certificate x509cert) {
        this.m_impl = x509cert;
    }

    public static jsseX509Certificate loadX509Certificate(String file) throws ECertificateException {
        throw jsseX509Certificate.getECertificateException("loadX509Certificate");
    }

    public static jsseX509Certificate loadX509Certificate(File file) {
        return jsseX509Certificate.loadX509Certificate(file.getAbsolutePath());
    }

    protected X509Certificate getX509CertificateImpl() {
        return this.m_impl;
    }

    @Override
    public Principal getSubjectDN() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSubjectDN");
        }
        try {
            return this.m_impl.getSubjectDN();
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public Principal getIssuerDN() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getIssuerDN");
        }
        try {
            return this.m_impl.getIssuerDN();
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public int getVersion() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getVersion");
        }
        try {
            return this.m_impl.getVersion();
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public BigInteger getSerialNumber() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSerialNumber");
        }
        try {
            return this.m_impl.getSerialNumber();
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public String getIssuerCommonName() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getIssuerCommonName");
        }
        try {
            return this.parseCN(this.m_impl.getIssuerDN().getName());
        }
        catch (Exception e) {
            throw new ECertificateException(e.getMessage(), e);
        }
    }

    @Override
    public String getSubjectCommonName() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSubjectCommonName");
        }
        try {
            return this.parseCN(this.m_impl.getSubjectDN().getName());
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public Date getNotBefore() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getNotBefore");
        }
        try {
            return this.m_impl.getNotBefore();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public Date getNotAfter() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getNotAfter");
        }
        try {
            return this.m_impl.getNotAfter();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] getTBSCertificate() throws ECertificateException, CertificateEncodingException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getTBSCertificate");
        }
        throw jsseX509Certificate.getECertificateException("getTBSCertificate");
    }

    @Override
    public byte[] getSignature() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSignature");
        }
        throw jsseX509Certificate.getECertificateException("getSignature");
    }

    @Override
    public String getSigAlgName() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSigAlgName");
        }
        try {
            return this.m_impl.getSigAlgName();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getSigAlgOID() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSigAlgOID");
        }
        try {
            return this.m_impl.getSigAlgOID();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getIssuerUniqueID");
        }
        throw jsseX509Certificate.getECertificateException("getIssuerUniqueID");
    }

    @Override
    public boolean[] getSubjectUniqueID() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSubjectUniqueID");
        }
        throw jsseX509Certificate.getECertificateException("getSubjectUniqueID");
    }

    @Override
    public boolean[] getKeyUsage() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getKeyUsage");
        }
        throw jsseX509Certificate.getECertificateException("getKeyUsage");
    }

    @Override
    public int getBasicConstraints() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getBasicConstraints");
        }
        throw jsseX509Certificate.getECertificateException("getBasicConstraints");
    }

    @Override
    public void checkValidity() throws ECertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("checkValidity");
        }
        try {
            this.m_impl.checkValidity();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] getSigAlgParams() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getSigAlgParams");
        }
        try {
            return this.m_impl.getSigAlgParams();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void checkValidity(Date date) throws ECertificateException, CertificateExpiredException, CertificateNotYetValidException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("checkValidity");
        }
        try {
            this.m_impl.checkValidity(date);
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] getEncoded() throws ECertificateException, CertificateEncodingException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getEncoded");
        }
        try {
            return this.m_impl.getEncoded();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public String toString() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("toString");
        }
        try {
            return this.m_impl.toString();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public PublicKey getPublicKey() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getPublicKey");
        }
        try {
            return this.m_impl.getPublicKey();
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void verify(PublicKey key) throws ECertificateException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.checkImpl();
        try {
            this.m_impl.verify(key);
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws ECertificateException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.checkImpl();
        try {
            this.m_impl.verify(key, sigProvider);
        }
        catch (Exception ex) {
            throw new ECertificateException(ex.getMessage(), ex);
        }
    }

    private void checkImpl() {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("verify");
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("hasUnsupportedCriticalExtension");
        }
        throw jsseX509Certificate.getECertificateException("hasUnsupportedCriticalExtension");
    }

    @Override
    public byte[] getExtensionValue(String oid) throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getExtensionValue");
        }
        throw jsseX509Certificate.getECertificateException("getExtensionValue");
    }

    public Set getCriticalExtensionOIDs() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getCriticalExtensionOIDs");
        }
        throw jsseX509Certificate.getECertificateException("getCriticalExtensionOIDs");
    }

    public Set getNonCriticalExtensionOIDs() throws ECertificateException {
        if (this.m_impl == null) {
            throw jsseX509Certificate.getECertificateException("getNonCriticalExtensionOIDs");
        }
        throw jsseX509Certificate.getECertificateException("getNonCriticalExtensionOIDs");
    }

    private String parseCN(String rdn) {
        if (rdn == null) {
            return null;
        }
        StringTokenizer tknizer = new StringTokenizer(rdn, ",", false);
        while (tknizer.hasMoreElements()) {
            String token = (String)tknizer.nextElement();
            if (!(token = token.trim()).startsWith("CN=")) continue;
            return token.substring(3, token.length());
        }
        return null;
    }
}

