/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

public final class WrappedDataInputStream
extends InputStream {
    private DataInput m_di;

    public WrappedDataInputStream(DataInput di) {
        this.m_di = di;
    }

    @Override
    public int read() throws IOException {
        return this.m_di.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.m_di.readFully(b);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.m_di.readFully(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int skip = (int)(n % Integer.MAX_VALUE);
        int iterations = (int)(n / Integer.MAX_VALUE);
        for (int count = 0; count < iterations; ++count) {
            this.m_di.skipBytes(Integer.MAX_VALUE);
        }
        this.m_di.skipBytes(skip);
        return n;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

