/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.http.client;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.INetworkLinkConfig;
import com.sonicsw.blackbird.http.client.HTTPAuthenticationException;
import com.sonicsw.blackbird.http.client.IHTTPAuthenticator;
import com.sonicsw.blackbird.http.client.IHTTPClient;
import com.sonicsw.blackbird.http.client.IHTTPCredentials;
import com.sonicsw.blackbird.http.client.IHTTPCredentialsProvider;
import com.sonicsw.blackbird.http.impl.HTTPConstants;
import com.sonicsw.blackbird.http.impl.client.AuthenticatorCredentialsProvider;
import com.sonicsw.blackbird.http.impl.client.FixedCredentialsProvider;
import com.sonicsw.blackbird.http.impl.client.HTTPClient;
import com.sonicsw.blackbird.http.impl.client.auth.BasicAuthenticator;
import com.sonicsw.blackbird.http.impl.client.auth.DigestAuthenticator;
import com.sonicsw.blackbird.http.impl.client.auth.NTLMAuthenticator;
import java.net.Authenticator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class HTTPClientFactory {
    private static final boolean DEBUG = false;
    public static final String HTTP_NTLM_AUTH_DOMAIN_PROP = "http.auth.ntlm.domain";
    public static final String HTTP_NTLM_AUTH_WORKSTATION_PROP = "sonic.http.auth.ntlmWorkStation";
    private static final String HTTP_JAVA_AUTHENTICATOR_CLASS_PROP_DEPRECATED = "sonic.https.proxyAuthenticator";
    public static final String HTTP_PREFFERED_AUTH_SCHEMES_PROP = "sonic.http.client.preferredAuthSchemes";
    public static final String HTTP_CREDENTIALS_PROVIDER_CLASS_PROP = "sonic.http.authenticator";
    private static volatile IHTTPCredentialsProvider m_defCredsProvider;
    public static final String SCHEME_NTLM = "ntlm";
    public static final String SCHEME_DIGEST = "digest";
    public static final String SCHEME_BASIC = "basic";
    private static volatile String HTTP_PREFFERED_AUTH_SCHEMES;
    private static final Map m_authSchemeClasses;
    private static String[] m_preferedSchemes;

    static final void loadProps(Properties props) {
        if (!HTTPConstants.HTTP_RUNNING_FROM_BROWSER) {
            String credProviderClassname = props.getProperty(HTTP_CREDENTIALS_PROVIDER_CLASS_PROP);
            if (credProviderClassname == null) {
                credProviderClassname = props.getProperty(HTTP_JAVA_AUTHENTICATOR_CLASS_PROP_DEPRECATED);
            }
            if (credProviderClassname != null) {
                try {
                    Object credProvider = Class.forName(credProviderClassname).newInstance();
                    if (credProvider instanceof IHTTPCredentialsProvider) {
                        HTTPClientFactory.setDefaultCredentialsProvider((IHTTPCredentialsProvider)credProvider);
                    } else if (credProvider instanceof Authenticator) {
                        Authenticator.setDefault((Authenticator)credProvider);
                        HTTPClientFactory.setDefaultCredentialsProvider(new AuthenticatorCredentialsProvider());
                    }
                }
                catch (Throwable thrown) {
                    HTTPClientFactory.debug("Error creating credentials provider: " + credProviderClassname + ", " + thrown.getMessage());
                    thrown.printStackTrace();
                }
            } else {
                HTTPClientFactory.setDefaultCredentialsProvider(new AuthenticatorCredentialsProvider());
            }
        } else {
            HTTPClientFactory.setDefaultCredentialsProvider(new AuthenticatorCredentialsProvider());
        }
        HTTP_PREFFERED_AUTH_SCHEMES = props.getProperty(HTTP_PREFFERED_AUTH_SCHEMES_PROP);
    }

    public static final IHTTPClient createHTTPClient(INetworkLinkConfig config) throws EEvsIOException {
        return new HTTPClient(config);
    }

    public static final IHTTPCredentialsProvider createCredentialsProvider(String username, String password) {
        return new FixedCredentialsProvider(username, password);
    }

    public static final IHTTPCredentialsProvider getDefaultCredentialsProvider() {
        return m_defCredsProvider;
    }

    public static final void setDefaultCredentialsProvider(IHTTPCredentialsProvider provider) {
        m_defCredsProvider = provider;
    }

    public static IHTTPAuthenticator getAuthenticator(Map schemes, IHTTPCredentialsProvider credProvider, String protocol, String host, int port) throws HTTPAuthenticationException {
        String[] schemeList = m_preferedSchemes;
        boolean unsupportedScheme = true;
        for (int i = 0; i < schemeList.length; ++i) {
            List challengeList;
            IHTTPAuthenticator auth = (IHTTPAuthenticator)m_authSchemeClasses.get(schemeList[i]);
            if (auth == null || (challengeList = (List)schemes.get(schemeList[i])) == null) continue;
            unsupportedScheme = false;
            for (Map params : challengeList) {
                try {
                    IHTTPCredentials creds = credProvider.getCredentials(protocol, host, port, auth.getSchemeName(), (String)params.get("realm"));
                    if (creds == null) continue;
                    auth = auth.createNew();
                    auth.setCredentials(creds);
                    auth.processChallenge(params);
                    return auth;
                }
                catch (Exception exception) {
                }
            }
        }
        if (unsupportedScheme) {
            throw new HTTPAuthenticationException("No compatible authentication schemes for " + host + ":" + port + ". The server supports: " + schemes.keySet().toString());
        }
        throw new HTTPAuthenticationException("Missing credentials for " + protocol + "://" + host + ":" + port);
    }

    public static final synchronized void registerAuthScheme(IHTTPAuthenticator authenticator) {
        m_authSchemeClasses.put(authenticator.getSchemeName().toLowerCase(), authenticator);
        String[] newPrefs = null;
        if (m_preferedSchemes != null) {
            newPrefs = new String[m_preferedSchemes.length + 1];
            for (int i = 0; i < m_preferedSchemes.length; ++i) {
                newPrefs[i] = m_preferedSchemes[i];
            }
            newPrefs[newPrefs.length - 1] = authenticator.getSchemeName();
            m_preferedSchemes = newPrefs;
        } else {
            m_preferedSchemes = new String[]{authenticator.getSchemeName()};
        }
    }

    public static final synchronized void setAuthSchemePreferences(String preference) {
        StringTokenizer tok = new StringTokenizer(preference, " ,");
        String[] prefs = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            prefs[0] = tok.nextToken().toLowerCase();
        }
        m_preferedSchemes = prefs;
    }

    private static final void debug(String str, Throwable thrown) {
        HTTPClientFactory.debug(str + thrown == null ? "" : " Related Exception: " + thrown.getMessage());
        thrown.printStackTrace();
    }

    private static final void debug(String str) {
        System.out.println("HTTPClientFactory: " + str);
    }

    static {
        m_authSchemeClasses = Collections.synchronizedMap(new HashMap(3));
        try {
            HTTPClientFactory.loadProps(System.getProperties());
        }
        catch (SecurityException se) {
            System.out.println("Insufficient privledges for loading http client props: " + se.getMessage());
        }
        m_authSchemeClasses.put(SCHEME_NTLM, new NTLMAuthenticator());
        m_authSchemeClasses.put(SCHEME_DIGEST, new DigestAuthenticator());
        m_authSchemeClasses.put(SCHEME_BASIC, new BasicAuthenticator());
        if (HTTP_PREFFERED_AUTH_SCHEMES == null) {
            m_preferedSchemes = new String[3];
            HTTPClientFactory.m_preferedSchemes[0] = SCHEME_DIGEST;
            HTTPClientFactory.m_preferedSchemes[1] = SCHEME_NTLM;
            HTTPClientFactory.m_preferedSchemes[2] = SCHEME_BASIC;
        } else {
            HTTPClientFactory.setAuthSchemePreferences(HTTP_PREFFERED_AUTH_SCHEMES);
        }
    }
}

