/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mq.common.runtime.IDestination;
import com.sonicsw.mq.common.runtime.IMessageHeader;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import com.sonicsw.mq.common.runtime.impl.MessageHeaderToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.client.prAccessor;
import progress.message.util.EPropertyCheckFailed;
import progress.message.util.PropertyChecker;

public class MessageHeader
implements IMessageHeader,
Serializable {
    static final long serialVersionUID = 7959210244105569514L;
    private static final short CURRENT_VERSION = 0;
    private Hashtable m_properties;
    private IMessageHeaderToken m_token;
    private boolean m_hasCorrelationID = false;
    private String m_correlationID;
    private int m_deliveryMode;
    private long m_expiration;
    private boolean m_hasMessageID = false;
    private String m_messageID;
    private int m_priority;
    private boolean m_redelivered;
    private long m_timestamp;
    private boolean m_hasType = false;
    private String m_type;
    private boolean m_hasReplyTo = false;
    private IDestination m_replyTo;
    private boolean m_hasDestination = false;
    private IDestination m_destination;
    private String m_brokerName;
    private static final String s_msgSize_key = "_SONICMQ_MESSAGE_ENQUEUED_SIZE_";
    private int m_msgSize = -1;

    public MessageHeader(MessageHeaderToken token, Hashtable properties) {
        this.m_properties = properties;
        this.m_token = token;
    }

    @Override
    public IMessageHeaderToken getToken() throws MFException {
        return this.m_token;
    }

    @Override
    public boolean getBooleanProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkBooleanProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public byte getByteProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkByteProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public double getDoubleProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkDoubleProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public float getFloatProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkFloatProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public int getIntProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkIntProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public String getJMSCorrelationID() throws MFException {
        return this.m_correlationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        this.m_correlationID = correlationID;
        this.m_hasCorrelationID = correlationID != null;
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws MFException {
        if (this.m_hasCorrelationID) {
            return this.m_correlationID.getBytes();
        }
        return null;
    }

    @Override
    public int getJMSDeliveryMode() throws MFException {
        return this.m_deliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.m_deliveryMode = deliveryMode;
    }

    @Override
    public IDestination getJMSDestination() throws MFException {
        return this.m_destination;
    }

    public void setJMSDestination(IDestination dest) {
        this.m_destination = dest;
        this.m_hasDestination = dest != null;
    }

    @Override
    public long getJMSExpiration() throws MFException {
        return this.m_expiration;
    }

    public void setJMSExpiration(long expiration) {
        this.m_expiration = expiration;
    }

    @Override
    public String getJMSMessageID() throws MFException {
        return "ID:" + this.m_messageID;
    }

    public void setJMSMessageID(String messageID) {
        this.m_messageID = messageID;
        this.m_hasMessageID = messageID != null;
    }

    @Override
    public int getJMSPriority() throws MFException {
        return this.m_priority;
    }

    public void setJMSPriority(int priority) {
        this.m_priority = priority;
    }

    @Override
    public boolean getJMSRedelivered() throws MFException {
        return this.m_redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) {
    }

    @Override
    public IDestination getJMSReplyTo() throws MFException {
        return this.m_replyTo;
    }

    public void setJMSReplyTo(IDestination dest) {
        this.m_replyTo = dest;
        this.m_hasReplyTo = dest != null;
    }

    @Override
    public long getJMSTimestamp() throws MFException {
        return this.m_timestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    public String getJMSType() throws MFException {
        return this.m_type;
    }

    public void setJMSType(String type) {
        this.m_type = type;
        this.m_hasType = type != null;
    }

    @Override
    public long getLongProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkLongProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public Object getObjectProperty(String name) throws MFException {
        return this.m_properties.get(name);
    }

    @Override
    public Enumeration getPropertyNames() throws MFException {
        return this.m_properties.keys();
    }

    @Override
    public short getShortProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkShortProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public String getStringProperty(String name) throws MFException {
        Object property = this.m_properties.get(name);
        try {
            return PropertyChecker.checkStringProperty(property);
        }
        catch (EPropertyCheckFailed e) {
            throw new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID"));
        }
    }

    @Override
    public String getBrokerName() throws MFException {
        return this.m_brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.m_brokerName = brokerName;
    }

    @Override
    public int getEnqueuedSize() throws MFException {
        return this.m_msgSize;
    }

    void setEnqueuedSize(int size) {
        this.m_msgSize = size;
    }

    @Override
    public boolean propertyExists(String name) throws MFException {
        return this.m_properties.containsKey(name);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeBoolean(this.m_hasCorrelationID);
        if (this.m_hasCorrelationID) {
            stream.writeUTF(this.m_correlationID);
        }
        stream.writeInt(this.m_deliveryMode);
        stream.writeLong(this.m_expiration);
        stream.writeBoolean(this.m_hasMessageID);
        if (this.m_hasMessageID) {
            stream.writeUTF(this.m_messageID);
        }
        stream.writeInt(this.m_priority);
        stream.writeBoolean(this.m_redelivered);
        stream.writeLong(this.m_timestamp);
        stream.writeBoolean(this.m_hasType);
        if (this.m_hasType) {
            stream.writeUTF(this.m_type);
        }
        stream.writeBoolean(this.m_hasReplyTo);
        if (this.m_hasReplyTo) {
            stream.writeObject(this.m_replyTo);
        }
        stream.writeBoolean(this.m_hasDestination);
        if (this.m_hasDestination) {
            stream.writeObject(this.m_destination);
        }
        stream.writeUTF(this.m_brokerName);
        stream.writeObject(this.m_token);
        if (this.m_msgSize != -1) {
            this.m_properties.put(s_msgSize_key, this.m_msgSize);
        }
        stream.writeObject(this.m_properties);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        switch (stream.readShort()) {
            case 0: {
                this.m_hasCorrelationID = stream.readBoolean();
                if (this.m_hasCorrelationID) {
                    this.m_correlationID = stream.readUTF();
                }
                this.m_deliveryMode = stream.readInt();
                this.m_expiration = stream.readLong();
                this.m_hasMessageID = stream.readBoolean();
                if (this.m_hasMessageID) {
                    this.m_messageID = stream.readUTF();
                }
                this.m_priority = stream.readInt();
                this.m_redelivered = stream.readBoolean();
                this.m_timestamp = stream.readLong();
                this.m_hasType = stream.readBoolean();
                if (this.m_hasType) {
                    this.m_type = stream.readUTF();
                }
                this.m_hasReplyTo = stream.readBoolean();
                if (this.m_hasReplyTo) {
                    this.m_replyTo = (IDestination)stream.readObject();
                }
                this.m_hasDestination = stream.readBoolean();
                if (this.m_hasDestination) {
                    this.m_destination = (IDestination)stream.readObject();
                }
                this.m_brokerName = stream.readUTF();
                this.m_token = (IMessageHeaderToken)stream.readObject();
                this.m_properties = (Hashtable)stream.readObject();
                this.m_msgSize = -1;
                Object property = this.m_properties.remove(s_msgSize_key);
                if (property == null) break;
                try {
                    this.m_msgSize = PropertyChecker.checkIntProperty(property);
                }
                catch (EPropertyCheckFailed e) {
                    new MFException(prAccessor.getString("MSG_TYPE_CONVERSN_INVALID")).printStackTrace();
                }
                break;
            }
        }
    }
}

