/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.jms;

import com.sonicsw.net.http.AccessController;
import com.sonicsw.net.http.HttpClientContext;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.net.http.HttpInRequest;
import com.sonicsw.net.http.HttpInResponse;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpProtocolHandler;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.MessageHandlingException;
import com.sonicsw.net.http.jms.JmsHttpCommand;
import com.sonicsw.net.http.jms.JmsHttpCommandConfirmSend;
import com.sonicsw.net.http.jms.JmsHttpCommandPoll;
import com.sonicsw.net.http.jms.JmsHttpCommandSend;
import com.sonicsw.net.http.jms.JmsHttpConfig;
import com.sonicsw.net.http.jms.JmsHttpInRequest;
import com.sonicsw.net.http.jms.JmsHttpInResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import progress.message.jclient.Message;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.ProgressPasswordUser;

public class JmsHttpProtocolHandler
extends HttpProtocolHandler {
    protected static final String REPLYTO_TYPE_JMS = "JMS";
    private JmsHttpConfig config = null;

    public JmsHttpProtocolHandler(HttpConfigInfo config) {
        super(config);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("JmsHttpProtocolHandler " + config.toString());
        }
        this.config = new JmsHttpConfig(config);
    }

    @Override
    public HttpInRequest getInRequest(HttpServletRequest req) {
        return new JmsHttpInRequest(req);
    }

    @Override
    public HttpInResponse getInResponse(HttpServletResponse res) {
        return new JmsHttpInResponse(res);
    }

    @Override
    public ProgressPasswordUser authenticate(HttpInRequest request) {
        AccessController ac = AccessController.getController();
        Object user = null;
        return super.authenticate(request, this.config.user, this.config.headerAuthentication, this.config.basicAuthentication, this.config.userPreconfigured, this.config.certificateAuthentication);
    }

    @Override
    public final boolean isBasicAuthSupported() {
        return this.config.basicAuthentication;
    }

    @Override
    public void service(HttpInRequest req, HttpInResponse resp, HttpClientContext httpContext) throws IOException {
        block32: {
            JmsHttpInRequest request = (JmsHttpInRequest)req;
            JmsHttpInResponse response = (JmsHttpInResponse)resp;
            long uniqueId = -1L;
            try {
                HttpRequestContext reqContext;
                HttpLock lock;
                Message message;
                String version = request.getProperty("X-JMS-Version", false);
                String action = request.getProperty("X-JMS-Action", false);
                JmsHttpCommand command = null;
                if (action != null) {
                    if (action.equalsIgnoreCase("push-msg")) {
                        command = new JmsHttpCommandSend(this.config, httpContext);
                    } else if (action.equalsIgnoreCase("confirm-push")) {
                        command = new JmsHttpCommandConfirmSend(this.config);
                    } else if (action.equalsIgnoreCase("pull-msg")) {
                        command = new JmsHttpCommandPoll(this.config, httpContext, this);
                    }
                } else {
                    command = this.config.isReceive() ? new JmsHttpCommandPoll(this.config, httpContext, this) : new JmsHttpCommandSend(this.config, httpContext);
                }
                Message message2 = message = command != null ? command.parseRequest(request, this.config) : null;
                if (message == null) {
                    if (action != null && action.equalsIgnoreCase("pull-msg")) {
                        HttpRequestContext reqContext2 = this.receiveMessageAndWait(request.getReceiveQueue(), httpContext, request.getReceiveTimeout());
                        HttpLock lock2 = reqContext2.getHttpLock();
                        if (lock2.getErrorType() != 200) {
                            response.createResponse(uniqueId, lock2.getErrorType(), lock2.getMessage());
                            return;
                        }
                        IMgram mgram = reqContext2.getMgram();
                        if (mgram == null) {
                            HttpConstants.DEBUG("Request queue empty", 0);
                            response.createResponse(uniqueId, 204, "The receive queue is empty, or the request timed out while waiting for the next message.");
                            return;
                        }
                        try {
                            if (command == null) {
                                throw new NullPointerException("JmsHttpCommand cannot be null.");
                            }
                            command.createEncodedContentResponse(response, mgram, "ISO-8859-1");
                            try {
                                this.ack(mgram);
                                break block32;
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception e) {
                            this.restore(mgram, request.getReceiveQueue());
                        }
                        break block32;
                    }
                    if (action.equalsIgnoreCase("push-msg")) {
                        response.createResponse(uniqueId, 400, "Duplicate id detected.  Message will be discarded.");
                        return;
                    }
                    if (command == null) {
                        throw new NullPointerException("JmsHttpCommand cannot be null.");
                    }
                    command.createResponse(response, null);
                    break block32;
                }
                if (httpContext == null) {
                    response.createResponse(uniqueId, 500, "Service temporarily unavailable.");
                    return;
                }
                if (!this.checkMaxMessageSize(message.getBodySize(), request, response)) {
                    return;
                }
                if (!this.config.isOneway()) {
                    this.setRequestReplyTo(message, REPLYTO_TYPE_JMS, httpContext);
                }
                if ((lock = (reqContext = this.sendMessageReusableLock(message, httpContext)).getHttpLock()).getContentReplyExpected() && reqContext.getMgram() != null) {
                    try {
                        response.createEncodedContentResponse(reqContext.getMgram(), "ISO-8859-1");
                    }
                    catch (MessageHandlingException e) {
                        response.createResponse(500, e.getMessage());
                        int dmqReason = 10;
                        String msg = this.getPrBundleMsg("HTTP_DIRECT_UNSUPPORTED_MESSAGE_TYPE");
                        this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
                    }
                    catch (Exception e) {
                        response.createResponse(500, "Failed to process content reply.");
                        int dmqReason = 4;
                        String msg = this.getPrBundleMsg("HTTP_DIRECT_CONNECTION_UNREACHABLE");
                        this.dmqNoException(reqContext.getMgram(), dmqReason, msg);
                    }
                } else if (lock.getErrorType() != 200) {
                    response.createResponse(uniqueId, lock.getErrorType(), lock.getMessage());
                } else {
                    command.createResponse(response, message);
                }
            }
            catch (UnsupportedEncodingException e) {
                response.createResponse(uniqueId, 400, "Unsupported encoding");
            }
            catch (Exception e) {
                if (HttpHelper.isMsgTooBigException(e)) {
                    response.create413MessageTooLargeResponse();
                    JmsHttpProtocolHandler.logLargeMessageWarning(request);
                }
                response.createResponse(uniqueId, 400, "Invalid request: " + e.getMessage());
            }
        }
    }
}

