/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.action;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.security.action.ActionWithParts;
import com.sonicsw.wsp.SecurityPolicyException;
import org.apache.ws.security.policy.model.InitiatorToken;
import org.apache.ws.security.policy.model.ProtectionToken;
import org.apache.ws.security.policy.model.RecipientToken;

public abstract class EncryptionSignatureBase
extends ActionWithParts {
    private InitiatorToken m_initiatorToken;
    private RecipientToken m_recipientToken;
    private ProtectionToken m_protectionToken;
    private boolean m_mustSupportRefKeyIdentifier = false;
    private boolean m_mustSupportRefIssuerSerial = false;
    private boolean m_requireClientEntropy = false;
    private boolean m_requireServerEntropy = false;

    public EncryptionSignatureBase() {
    }

    public EncryptionSignatureBase(int spVersion) {
        super(spVersion);
    }

    public InitiatorToken getInitiatorToken() {
        return this.m_initiatorToken;
    }

    public void setInitiatorToken(InitiatorToken initiatorToken) {
        this.m_initiatorToken = initiatorToken;
    }

    public RecipientToken getRecipientToken() {
        return this.m_recipientToken;
    }

    public void setRecipientToken(RecipientToken recipientToken) {
        this.m_recipientToken = recipientToken;
    }

    public ProtectionToken getProtectionToken() throws SecurityPolicyException {
        if (HttpHelper.ENABLE_SECURE_CONVERSATION) {
            return this.m_protectionToken;
        }
        throw new SecurityPolicyException("WS-SecureConversation support is not yet implemented.");
    }

    public void setProtectionToken(ProtectionToken protectionToken) throws SecurityPolicyException {
        if (!HttpHelper.ENABLE_SECURE_CONVERSATION) {
            throw new SecurityPolicyException("WS-SecureConversation support is not yet implemented.");
        }
        this.m_protectionToken = protectionToken;
    }

    public boolean getMustSupportRefKeyIdentifier() {
        return this.m_mustSupportRefKeyIdentifier;
    }

    public void setMustSupportRefKeyIdentifier(boolean mustSupport) {
        this.m_mustSupportRefKeyIdentifier = mustSupport;
    }

    public boolean getMustSupportRefIssuerSerial() {
        return this.m_mustSupportRefIssuerSerial;
    }

    public void setMustSupportRefIssuerSerial(boolean mustSupport) {
        this.m_mustSupportRefIssuerSerial = mustSupport;
    }

    public boolean getRequireClientEntropy() {
        return this.m_requireClientEntropy;
    }

    public void setRequireClientEntropy(boolean mustSupport) {
        this.m_requireClientEntropy = mustSupport;
    }

    public boolean getRequireServerEntropy() {
        return this.m_requireServerEntropy;
    }

    public void setRequireServerEntropy(boolean mustSupport) {
        this.m_requireServerEntropy = mustSupport;
    }
}

