/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.net.http.HttpHelper;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.model.SecureConversationToken;
import com.sonicsw.ws.security.policy.parser.processors.BootstrapProcessor;
import com.sonicsw.ws.security.policy.parser.processors.IssuerProcessor;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.w3c.dom.Element;

public class SecureConversationTokenProcessor {
    private boolean m_initialized = false;
    private String m_id;

    private void initializeSecureConversationToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        IssuerProcessor issuerProc = new IssuerProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.issuer.copy();
        tmpSpt.setProcessTokenMethod((Object)issuerProc);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireDerivedKeys.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireExternalUriReference.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.sc10SecurityContextToken.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        BootstrapProcessor bootstrapProc = new BootstrapProcessor();
        tmpSpt = SecurityPolicy.bootstrapPolicy.copy();
        tmpSpt.setProcessTokenMethod((Object)bootstrapProc);
        spt.setChildToken(tmpSpt);
    }

    public Object doSecureConversationToken(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        if (!HttpHelper.ENABLE_SECURE_CONVERSATION) {
            DebugObjects.getSecureConversationDebug().debug("WS-SecureConversation support is not yet implemented.");
            return new Boolean(false);
        }
        switch (spc.getAction()) {
            case 1: {
                if (this.m_initialized) break;
                try {
                    this.initializeSecureConversationToken(spt);
                    SecureConversationToken secureConversationToken = (SecureConversationToken)spc.readCurrentPolicyEngineData();
                    String includetokenUri = spc.getAssertion().getAttribute(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken"));
                    try {
                        if (includetokenUri != null) {
                            secureConversationToken.setInclusion(includetokenUri);
                        }
                    }
                    catch (WSSPolicyException e) {
                        DebugObjects.getSecureConversationDebug().debug(e.getMessage());
                        return new Boolean(false);
                    }
                    this.m_initialized = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        return new Boolean(true);
    }

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        DebugObjects.getSecureConversationDebug().debug(this.getClass().getName() + ": Found SecureConversationToken list element");
        this.m_id = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public Object doRequireDerivedKeys(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((SecureConversationToken)spc.readCurrentPolicyEngineData()).setRequireDerivedKeys(true);
        }
        return new Boolean(true);
    }

    public Object doRequireExternalUriReference(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((SecureConversationToken)spc.readCurrentPolicyEngineData()).setRequireExternalUriReference(true);
        }
        return new Boolean(true);
    }

    public Object doSC10SecurityContextToken(SecurityProcessorContext spc) {
        DebugObjects.getSecureConversationDebug().debug("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]);
        if (spc.getAction() == 1) {
            ((SecureConversationToken)spc.readCurrentPolicyEngineData()).setSC10SecurityContextTokenRequired(true);
        }
        return new Boolean(true);
    }

    public String getId() {
        return this.m_id;
    }
}

