/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.ws.security.action.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class TimestampResult {
    private static boolean doDebug = false;
    private Calendar m_created;
    private Calendar m_expires;

    public TimestampResult(Calendar created, Calendar expires) {
        this.m_created = created;
        this.m_expires = expires;
    }

    public Calendar getCreated() {
        return this.m_created;
    }

    public Calendar getExpires() {
        return this.m_expires;
    }

    public boolean validate(Timestamp maa) {
        return this.verifyTimestamp(this.getCreated(), this.getExpires(), maa == null ? -1L : maa.getTTL());
    }

    private boolean verifyTimestamp(Calendar createdTime, Calendar expiredTime, long timeToLive) {
        Calendar rightNow = Calendar.getInstance();
        Calendar validCreation = Calendar.getInstance();
        long validCreationTime = validCreation.getTimeInMillis();
        validCreationTime = timeToLive > 0L ? (validCreationTime -= timeToLive * 1000L) : createdTime.getTimeInMillis() + timeToLive * 1000L;
        validCreation.setTimeInMillis(validCreationTime);
        if (doDebug) {
            System.out.println("TimestampInfo: Preparing to verify the timestamp");
            SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
            System.out.println("TimestampInfo: Current time is " + zulu.format(rightNow.getTime()));
            System.out.println("TimestampInfo: Not valid if created before " + zulu.format(validCreation.getTime()));
            System.out.println("TimestampInfo: Timestamp created = " + zulu.format(createdTime.getTime()));
            System.out.println("TimestampInfo: Timestamp expires = " + zulu.format(expiredTime.getTime()));
        }
        if (rightNow.after(expiredTime) || !createdTime.after(validCreation)) {
            if (doDebug) {
                System.out.println("TimestampInfo: The message was created too long ago");
            }
            return false;
        }
        if (doDebug) {
            System.out.println("TimestampInfo: Timestamp validation SUCCEEDED.");
        }
        return true;
    }
}

