/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DurableManager;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EGeneralCWADSException;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.durable.CWADSInfo;
import progress.message.broker.durable.CWADSInfoOp;
import progress.message.broker.durable.CWADSListXferOp;
import progress.message.broker.durable.CWADSListXferReplyOp;
import progress.message.broker.durable.CWADSPingOp;
import progress.message.broker.durable.CWADSPingReplyOp;
import progress.message.broker.durable.EDurableOperationException;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.ICWADSInfo;
import progress.message.broker.parser.ParseException;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectFailure;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.Username;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Session;

public final class CWADSMessageHandler
extends DebugObject
implements IMessageHandler {
    public static final int CWADS_UPDATE = 100;
    public static final int CWADS_NEW_PREVIOUS_NOTIFICATION = 104;
    public static final int CWADS_UNSUBSCRIBE = 102;
    public static final int CWADS_DISCONNECT = 103;
    public static final int CWADS_STARTDELIVERY = 111;
    public static final int CWADS_STOPDELIVERY = 113;
    public static final int CWADS_SUCCESS = 0;
    public static final int CWADS_FAILURE = -1;
    public static final String CWADS_INACTIVE = "$INACTIVE";
    private boolean DEBUG_RECONCILE = false;
    private int DEBUG_RECONCILE_MASK = 512;
    private AgentRegistrar m_reg;
    private final CWADSInfo m_currentRequest = new CWADSInfo();
    static Object s_handshakeSync = new Object();
    private static byte HANDSHAKE_PHASE_1 = 1;
    private static byte HANDSHAKE_PHASE_2 = (byte)2;

    public CWADSMessageHandler(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "CWADSMessageHandler" : null);
        this.m_reg = reg;
        this.m_reg.setCWADSMsgHandler(this);
        this.DEBUG_RECONCILE = this.checkDebugFlags(this.DEBUG_RECONCILE_MASK);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void handleMessage(Session s, Envelope env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleNewPreviousBrokerNotification(IClientContext targetcc, long senderID) throws InterruptedException {
        if (targetcc == null) {
            return;
        }
        targetcc.lock();
        try {
            targetcc.handleNewPreviousBrokerNotification(senderID);
        }
        finally {
            targetcc.unlock();
        }
    }

    private static final void sendReply(Envelope req, int retcode) {
    }

    private void unsubscribe(IClientContext targetcc) throws EClientNotRegistered, EOldVirtualClockException, InterruptedException {
        BrokerSubscription bs;
        if (targetcc != null && (bs = targetcc.getDurableBrokerSubscription()) != null) {
            if (this.DEBUG) {
                this.debug("executing CWADS_UNSUBSCRIBE for \n subject = " + bs.getSubject() + "\n timestamp = " + bs.getCreationTime() + "\n user = " + targetcc.getUid() + "/" + targetcc.getAppid());
            }
            this.m_reg.cancelDisconnectTimer(targetcc);
            this.m_reg.disconnect(targetcc.getId(), false);
            UnsubscribeEvt evt = new UnsubscribeEvt(null, targetcc.getId(), bs.getSubject());
            evt.setSuppressCWADSPropagation(true);
            this.m_reg.unsubscribe(evt);
            this.assertNoTimer(targetcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(IClientContext targetcc, boolean durableSMOSensitive) {
        block11: {
            try {
                if (!targetcc.isConnected()) break block11;
                try {
                    targetcc.getProxyingHandle().freezeProxy();
                    Object object = targetcc.getSyncObj();
                    synchronized (object) {
                        block12: {
                            if (!durableSMOSensitive || targetcc.getCWADSRestoringBroker() == null || targetcc.getCWADSRestoringBroker().getId() != targetcc.getId()) break block12;
                            if (this.DEBUG) {
                                this.debug("setDisconnectAfterFinalRemoteRestore for targetcc.getId(): " + targetcc.getId());
                            }
                            targetcc.setDisconnectAfterFinalRemoteRestore(true);
                            return;
                        }
                    }
                }
                finally {
                    targetcc.getProxyingHandle().unfreezeProxy();
                }
                this.m_reg.prepareDisconnect(targetcc.getId());
                this.m_reg.cancelDisconnectTimer(targetcc);
                this.m_reg.disconnect(targetcc.getId(), true);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
        }
    }

    private final SubscribeEvtForSelector createSubscribeEvtFromInfo(Envelope req, ICWADSInfo info) {
        SubscribeEvtForSelector evt = new SubscribeEvtForSelector(req, info.getId(), info.getSubject(), info.getLabel(), new String[]{info.getSelector()}, info.getSelectorAtBroker());
        evt.setCreationTime(info.getTimestamp());
        evt.setDurableStrictMessageOrder(info.getDurableSMO());
        evt.setTTE(info.getTTE());
        evt.setSuppressNotification(true);
        evt.setSuppressCWADSPropagation(true);
        return evt;
    }

    private ClientSecurityContext createClientSecurityContext(String uid, String appid, long targetccid) throws IOException {
        Principal principal = null;
        principal = !Config.ENABLE_SECURITY ? new Username(uid) : this.m_reg.getSecurityBean().getUser(uid);
        if (Config.ENABLE_SECURITY && principal == null) {
            try {
                if (Config.ENABLE_SECURITY) {
                    String[] user = new String[]{uid};
                    Broker.getBroker().getSecurityCache().updateExternalUsers(user);
                    principal = this.m_reg.getSecurityBean().getUser(uid);
                }
            }
            catch (Throwable e) {
                Object[] obj = new Object[]{uid};
                String s = prMessageFormat.format(prAccessor.getString("STR363"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 1);
            }
            if (principal == null) {
                Object[] obj = new Object[]{uid};
                String s = prMessageFormat.format(prAccessor.getString("STR363"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 1);
            }
        }
        ClientSecurityContext csc = new ClientSecurityContext(principal, uid, appid, targetccid, Config.ENABLE_SECURITY, Config.ENABLE_QOPSECURITY, null, null, -1L);
        return csc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void sendCWADSStartDelivery(IClientContext cc) {
        neighbors = InterbrokerHook.getActiveNeighbors();
        block6: for (n = 0; n < neighbors.length; ++n) {
            ncc = neighbors[n].getClient();
            if (ncc == null) continue;
            try {
                ncc.lock();
                switch (ncc.getState()) {
                    case -1: 
                    case 0: {
                        ** break;
lbl10:
                        // 1 sources

                        continue block6;
                    }
                    default: {
                        if (this.DEBUG) {
                            this.debug("Sending start delivery to: " + CWADSInfoHelper.access$000(ncc) + " for: " + CWADSInfoHelper.access$000(cc));
                        }
                        cc.getProxyingHandle().addStartedInboundProxy(ncc.getId());
                        continue block6;
                    }
                }
            }
            finally {
                ncc.unlock();
            }
        }
        if (InterbrokerHook.isSet()) {
            bs = cc.getDurableBrokerSubscription();
            if (bs == null) {
                return;
            }
            InterbrokerHook.notifyCWADSEvent(111, cc, bs);
        }
    }

    final void sendCWADSStopDelivery(IClientContext cc) {
        if (InterbrokerHook.isSet()) {
            BrokerSubscription bs = cc.getDurableBrokerSubscription();
            if (bs == null) {
                return;
            }
            InterbrokerHook.notifyCWADSEvent(113, cc, bs);
        }
    }

    final void sendRemoteRestorePhasesDone(IClientContext target, IClientContext durable) {
        if (!InterbrokerHook.isSet()) {
            return;
        }
        if (this.DEBUG) {
            this.debug("Sending remote restore done to:" + CWADSInfoHelper.getUidAppid(target) + " for: " + CWADSInfoHelper.getUidAppid(durable));
        }
        target.sendPriorityPush(MgramFactory.getMgramFactory().buildRemoteRestorePhasesDoneMgram(durable.getId()), 0, 9);
    }

    final void sendNewPreviousBrokerNotification(IClientContext durable) {
        if (InterbrokerHook.isSet()) {
            try {
                durable.lock();
                BrokerSubscription bs = durable.getDurableBrokerSubscription();
                if (bs != null) {
                    if (this.DEBUG) {
                        this.debug("Broadcasting CWADS_NEW_PREVIOUS_NOTIFICATION for: " + CWADSInfoHelper.getUidAppid(durable));
                    }
                    InterbrokerHook.notifyCWADSEvent(104, durable, bs);
                }
            }
            finally {
                durable.unlock();
            }
        }
    }

    final void sendCWADSUpdate(IClientContext durable) {
        if (InterbrokerHook.isSet()) {
            try {
                durable.lock();
                BrokerSubscription bs = durable.getDurableBrokerSubscription();
                if (bs != null) {
                    if (this.DEBUG) {
                        this.debug("Broadcasting CWADS_UPDATE for " + CWADSInfoHelper.getUidAppid(durable));
                    }
                    InterbrokerHook.notifyCWADSEvent(100, durable, bs);
                }
            }
            finally {
                durable.unlock();
            }
        }
    }

    final void sendCWADUnsubscribe(IClientContext durable, BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("Broadcasting CWADS_UNSUBSCRIBE for " + CWADSInfoHelper.getUidAppid(durable));
        }
        InterbrokerHook.notifyCWADSEvent(102, durable, bs);
    }

    final void sendCWADSDisconnect(IClientContext cc) throws EGeneralCWADSException {
        if (InterbrokerHook.isSet()) {
            BrokerSubscription bs = cc.getDurableBrokerSubscription();
            if (bs == null) {
                return;
            }
            if (this.DEBUG) {
                this.debug("Sending CWADS Disconnect for: " + CWADSInfoHelper.getUidAppid(cc));
            }
            InterbrokerHook.notifyCWADSEvent(103, cc, bs);
        }
    }

    final void sendCWADSPingRequest(long id, IClientContext target, long preemptingRootId) throws EGeneralCWADSException {
        if (!InterbrokerHook.isSet()) {
            return;
        }
        CWADSPingReplyOp returnResult = null;
        try {
            returnResult = this.pingInternal(target, id, preemptingRootId);
        }
        catch (InterruptedException e) {
            throw new EGeneralCWADSException("CWADS PING CANCELLED " + e.toString());
        }
        try {
            if (this.DEBUG) {
                this.debug("Comparing and updating as result of ping.");
            }
            this.compareAndUpdateCC(null, returnResult);
        }
        catch (Exception e) {
            EGeneralCWADSException ex = new EGeneralCWADSException("Failed to update durable subscription information: " + e.getMessage(), e);
            ex.initCause(e);
            throw ex;
        }
    }

    private final CWADSPingReplyOp pingInternal(IClientContext target, long durableId, long preemptingRootClientId) throws EGeneralCWADSException, InterruptedException {
        DurableManager durmgr = AgentRegistrar.getAgentRegistrar().getDurableManager();
        if (this.DEBUG) {
            this.debug("sending ping to " + target.getUid() + "/" + target.getAppid() + "for: " + CWADSInfoHelper.getUidAppid(durableId));
        }
        Collection result = null;
        try {
            IMgram pingOp = CWADSPingOp.makeMgram(durableId, preemptingRootClientId);
            pingOp.sync();
            result = durmgr.performCWADSRequest(target.getUid(), pingOp);
        }
        catch (EDurableOperationException e) {
            throw new EGeneralCWADSException("CWADS PING CANCELLED " + e.toString(), e);
        }
        catch (Exception e) {
            throw new EGeneralCWADSException("CWADS PING CANCELLED 100", e);
        }
        if (result == null) {
            throw new EGeneralCWADSException("CWADS PING CANCELLED 100");
        }
        Iterator iter = result.iterator();
        CWADSPingReplyOp returnResult = null;
        while (iter.hasNext()) {
            CWADSPingReplyOp reply = (CWADSPingReplyOp)iter.next();
            if (reply.getErrorCode() != 0) {
                if (this.DEBUG) {
                    this.debug("ping failed " + reply.getErrorCode());
                }
                throw new EGeneralCWADSException("CWADS PING FAILED " + reply.getErrorCode());
            }
            if (this.DEBUG) {
                this.debug("ping reply received " + reply.toString());
            }
            returnResult = reply;
        }
        if (returnResult == null) {
            throw new EGeneralCWADSException("CWADS PING FAILED 3");
        }
        return returnResult;
    }

    private final boolean compareToLocalInfo(ICWADSInfo info, IClientContext cc) {
        BrokerSubscription bs = cc.getDurableBrokerSubscription();
        if (bs == null) {
            if (this.DEBUG) {
                this.debug("CWADSListXferOp found no durable subscription for this cc");
            }
            return false;
        }
        if (this.DEBUG) {
            this.debug("CWADSInfo cc's active is " + cc.getCWADSActiveBroker() + "\nprevious is " + cc.getCWADSPreviousBroker());
        }
        if (info.getTimestamp() != bs.getCreationTime()) {
            if (this.DEBUG) {
                this.debug("CWADSInfo creation times do not match " + info.getTimestamp() + " vs. " + bs.getCreationTime());
            }
            return false;
        }
        if (this.hasSubscriptionChanged(info, bs)) {
            return false;
        }
        IClientContext activecc = cc.getCWADSActiveBroker();
        IClientContext previouscc = cc.getCWADSPreviousBroker();
        if (activecc == null && !info.getActiveUid().equals(CWADS_INACTIVE)) {
            if (this.DEBUG) {
                this.debug("CWADSInfo active's do not match, local is inactive, but remote is not");
            }
            return false;
        }
        if (activecc != null) {
            if (activecc.isInterbroker()) {
                if (cc.getDisconnectAfterFinalRemoteRestore() && info.getActiveUid().equals(CWADS_INACTIVE)) {
                    if (this.DEBUG) {
                        this.debug("CWADSInfo: Remote restore in progress with deferred disconnect: Mismatch active cc ok from previous.");
                    }
                } else if (!info.getActiveUid().equals(activecc.getUid()) || !info.getActiveAppid().equals(activecc.getAppid())) {
                    return this.debugActiveCcsNotMatch();
                }
            } else if (!info.getActiveUid().equals(Config.BROKER_UID) || !info.getActiveAppid().equals("Broker")) {
                return this.debugActiveCcsNotMatch();
            }
        }
        if (previouscc == null && !info.getPreviousUid().equals(CWADS_INACTIVE)) {
            if (this.DEBUG) {
                this.debug("CWADSInfo previous cs do not match, local is null, but remote is not.");
            }
            return false;
        }
        if (previouscc != null && (previouscc.isInterbroker() ? !info.getPreviousUid().equals(previouscc.getUid()) || !info.getPreviousAppid().equals(previouscc.getAppid()) : !info.getPreviousUid().equals(Config.BROKER_UID) || !info.getPreviousAppid().equals("Broker"))) {
            return this.debugPreviousCcsNotMatch();
        }
        return true;
    }

    private boolean debugActiveCcsNotMatch() {
        if (this.DEBUG) {
            this.debug("CWADSInfo active ccs do not match");
        }
        return false;
    }

    private boolean debugPreviousCcsNotMatch() {
        if (this.DEBUG) {
            this.debug("CWADSInfo previous ccs do not match");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean compareAndUpdateCC(Envelope req, ICWADSInfo info) throws EClientNotRegistered, EConnectFailure, EInvalidSubjectSyntax, InterruptedException, IOException, ESecurityPolicyViolation, ParseException {
        if (this.DEBUG) {
            this.debug("Comparing and updating cc: Remote info: " + info);
        }
        IClientContext targetcc = null;
        try {
            long activeid = -1L;
            if (!info.getActiveUid().equalsIgnoreCase(CWADS_INACTIVE)) {
                String activeUid = info.getActiveUid();
                String activeAppid = info.getActiveAppid();
                this.populateClient(activeUid, activeAppid);
            }
            long previousid = -1L;
            if (!info.getPreviousUid().equalsIgnoreCase(CWADS_INACTIVE)) {
                String previousUid = info.getPreviousUid();
                String previousAppid = info.getPreviousAppid();
                this.populateClient(previousUid, previousAppid);
            }
        }
        catch (EClientNotRegistered ecnr) {
            return false;
        }
        boolean needsUnlock = false;
        boolean lockingError = false;
        try {
            while (true) {
                block72: {
                    needsUnlock = false;
                    targetcc = this.m_reg.lockContext(info.getId());
                    if (targetcc != null && !targetcc.isDurable() || targetcc == null && !info.getAppid().startsWith("$DURABLE$")) {
                        BrokerComponent.logMessage("Invalid CWADS UPDATE event -\n" + info, BrokerComponent.getLevelWarning());
                        CWADSMessageHandler.targetccUnlockCheckingNull(targetcc);
                        boolean previousid = false;
                        return previousid;
                    }
                    if (targetcc == null) {
                        if (this.DEBUG) {
                            this.debug("Registering new cc for: " + info);
                        }
                        ClientSecurityContext csc = this.createClientSecurityContext(info.getUid(), info.getAppid(), info.getId());
                        targetcc = this.m_reg.registerAndLock(info.getId(), csc, null);
                    }
                    if (this.DEBUG) {
                        try {
                            CWADSInfo localInfo = new CWADSInfo(targetcc);
                            this.debug("Comparing and updating local info is: " + localInfo);
                        }
                        catch (ESubscriptionNotFound esnf) {
                            this.debug("Comparing and updating locally has null subscription: " + targetcc, esnf);
                        }
                    }
                    needsUnlock = true;
                    needsUnlock = false;
                    if (targetcc.waitForRegistryUpdate()) {
                        if (!this.DEBUG) continue;
                        this.debug("compareAndUpdate waited for registry update to complete ... starting over");
                        continue;
                    }
                    needsUnlock = true;
                    if (this.compareToLocalInfo(info, targetcc)) {
                        if (this.DEBUG) {
                            this.debug("Local and remote info agree returning without connecting: info= " + info);
                        }
                        targetcc.unlock();
                        needsUnlock = false;
                        boolean esnf = true;
                        return esnf;
                    }
                    if (CWADSInfoHelper.activeAtSender(info) && targetcc.getCWADSActiveBroker() != null && !CWADSInfoHelper.locallyActiveOnSender(targetcc, info) && targetcc.isActivelyConnected()) {
                        try {
                            CWADSInfo currentInfo = new CWADSInfo(targetcc);
                            IClientContext activecc = targetcc.getCWADSActiveBroker();
                            if (this.DEBUG) {
                                this.debug("sending ping to " + activecc.getUid() + "/" + activecc.getAppid());
                            }
                            targetcc.unlock();
                            needsUnlock = false;
                            targetcc.pingIfIdle(info.getRootClientId());
                            targetcc.lock();
                            needsUnlock = true;
                            needsUnlock = false;
                            if (targetcc.waitForRegistryUpdate()) continue;
                            needsUnlock = true;
                            if (!this.compareToLocalInfo(currentInfo, targetcc)) {
                                targetcc.unlock();
                                needsUnlock = false;
                                continue;
                            }
                        }
                        catch (ESubscriptionNotFound esnf) {
                            if (!this.DEBUG) break block72;
                            this.debug("Skipping durable ping because durable subscription not found" + esnf, esnf);
                        }
                    }
                }
                if (!this.okToApplyEvent(targetcc, info, 100)) {
                    if (this.DEBUG) {
                        this.debug("Not ok to apply event. info" + info);
                    }
                    targetcc.unlock();
                    needsUnlock = false;
                    boolean esnf = false;
                    return esnf;
                }
                IClientContext targetCWADSActiveBroker = targetcc.getCWADSActiveBroker();
                if (targetcc.isConnected() || targetCWADSActiveBroker != null) {
                    if (this.DEBUG) {
                        this.debug("OK to apply event, forcing disconnect of the active durable and checking if it still ok.");
                    }
                    if (CWADSInfoHelper.activeAtSender(info)) {
                        needsUnlock = false;
                        boolean isActiveBrokerDisconnecting = targetCWADSActiveBroker != null && targetCWADSActiveBroker.isDisconnecting();
                        boolean neighborDisconnecting = isActiveBrokerDisconnecting && !CWADSInfoHelper.locallyActiveLocally(targetcc);
                        if (neighborDisconnecting) continue;
                        this.forceDisconnect(targetcc);
                        this.assertNoTimer(targetcc);
                        continue;
                    }
                    targetcc.prepareDisconnect(7);
                    targetcc.unlock();
                    needsUnlock = false;
                    this.disconnect(targetcc, false);
                    this.assertNoTimer(targetcc);
                    continue;
                }
                try {
                    if (!this.m_reg.prepareConnect(targetcc, info.getRootClientId())) {
                        if (!this.DEBUG) continue;
                        this.debug("Prepared connect with AgentRegistrar failed: " + info);
                        continue;
                    }
                }
                catch (EUserAlreadyConnected euac) {
                    if (this.DEBUG) {
                        this.debug("Prepared connect with registrar, forcing disconnect", euac);
                    }
                    targetcc.lock();
                    needsUnlock = false;
                    this.forceDisconnect(targetcc);
                    this.assertNoTimer(targetcc);
                    continue;
                }
                catch (InterruptedException ie) {
                    needsUnlock = false;
                    Thread.currentThread().interrupt();
                    throw ie;
                }
                if (!targetcc.beginRegistryUpdate()) {
                    needsUnlock = false;
                    Thread.currentThread();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.debug("Registry Update lock not aquired for: " + info);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            BrokerComponent.logMessage(ioe, BrokerComponent.getLevelSevere());
            lockingError = true;
            throw ioe;
        }
        catch (InterruptedException ie) {
            lockingError = true;
            Thread.currentThread().interrupt();
            throw ie;
        }
        catch (RuntimeException re) {
            BrokerComponent.logMessage(re, BrokerComponent.getLevelSevere());
            lockingError = true;
            throw re;
        }
        finally {
            if (lockingError && needsUnlock && targetcc != null) {
                targetcc.unlock();
            }
        }
        try {
            IClientContext restoring;
            BrokerSubscription bs = targetcc.getDurableBrokerSubscription();
            SubscribeEvtForSelector subscribeEvt = this.createSubscribeEvtFromInfo(req, info);
            if (bs != null && !bs.prepareForResubscribe(subscribeEvt)) {
                if (this.DEBUG) {
                    this.debug("compareAndUpdateCC prepareForResubscribe needs unsubscriber for: " + info);
                }
                UnsubscribeEvt unsubscribeEvt = new UnsubscribeEvt(null, targetcc.getId(), bs.getSubject());
                unsubscribeEvt.setSuppressCWADSPropagation(true);
                targetcc.unlock();
                needsUnlock = false;
                this.m_reg.unsubscribe(unsubscribeEvt);
                targetcc.lock();
                needsUnlock = true;
            }
            IClientContext activecc = CWADSInfoHelper.getSenderActiveCC(targetcc, info);
            try {
                targetcc.getProxyingHandle().lockProxy();
                targetcc.setCWADSActiveBroker(activecc, false);
                targetcc.setCWADSPreviousBroker(CWADSInfoHelper.getSenderPreviousCC(targetcc, info));
                targetcc.setCWADSRestoringBroker(CWADSInfoHelper.getSenderRestoringBrokerCC(targetcc, info));
                IClientContext previous = targetcc.getCWADSPreviousBroker();
                if (previous != null) {
                    subscribeEvt.setPreviousBrokerCID(previous.getId());
                }
                if ((restoring = targetcc.getCWADSRestoringBroker()) != null) {
                    subscribeEvt.setRestoreToBrokerCID(restoring.getId());
                }
            }
            finally {
                targetcc.getProxyingHandle().unlockProxy();
            }
            boolean connectFailure = false;
            try {
                needsUnlock = false;
                targetcc = this.m_reg.preparedConnect(null, targetcc.getCSC(), targetcc, false, (short)0, true, info.getRootClientId());
            }
            catch (EConnectFailure ex) {
                if (this.DEBUG) {
                    this.debug("ERROR compareAndUpdateCC connect for: " + info, ex);
                }
                connectFailure = true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                connectFailure = true;
            }
            try {
                this.m_reg.subscribe(subscribeEvt, false, true, null);
            }
            catch (Throwable thrown) {
                if (this.DEBUG) {
                    this.debug("Caught Exception during subscribe");
                    Config.logMessage(thrown, 3);
                }
                connectFailure = true;
            }
            restoring = targetcc.getCWADSRestoringBroker();
            if (!connectFailure && restoring != null && restoring.getId() == targetcc.getId()) {
                if (this.DEBUG) {
                    this.debug("Starting restoring broker remote restore cycle for targetcc + " + targetcc);
                }
                targetcc.createMsgRestorerAndStart(true, true, true);
            }
            if (connectFailure || activecc == null || !activecc.isConnected()) {
                if (this.DEBUG) {
                    this.debug("DISCONNECTING cc after subscribe because update indicates it is inactive: " + targetcc);
                }
                boolean activeConnected = activecc != null && activecc.isConnected();
                this.disconnect(targetcc, !connectFailure && activeConnected);
                this.assertNoTimer(targetcc);
            }
        }
        catch (RuntimeException re) {
            BrokerComponent.logMessage(re, BrokerComponent.getLevelSevere());
            throw re;
        }
        finally {
            if (!needsUnlock) {
                targetcc.lock();
            }
            if (this.DEBUG) {
                try {
                    CWADSInfo updated = new CWADSInfo(targetcc);
                    this.debug("compareAndUpdateCC: ending registry update: " + updated);
                }
                catch (ESubscriptionNotFound esnf) {
                    this.debug("compareAndUpdateCC: ending registry update: " + esnf.getMessage(), esnf);
                }
            }
            targetcc.endRegistryUpdate();
            targetcc.unlock();
        }
        return true;
    }

    private void populateClient(String previousUid, String previousAppid) throws EClientNotRegistered {
        long previousid = 0L;
        if (!previousUid.equals(Config.BROKER_UID) || !previousAppid.equals("Broker")) {
            previousid = AddrUtil.stringToClientId(previousUid, previousAppid);
            this.m_reg.getClient(previousid);
        }
    }

    private static void targetccUnlockCheckingNull(IClientContext targetcc) {
        if (targetcc != null) {
            targetcc.unlock();
        }
    }

    private final boolean okToApplyEvent(IClientContext cc, ICWADSInfo info, int eventType) {
        BrokerSubscription bs;
        if (eventType == 104) {
            return true;
        }
        long eventTimestamp = info.getTimestamp();
        String remoteActiveUid = info.getActiveUid();
        String remoteActiveAppid = info.getActiveAppid();
        String remotePreviousUid = info.getPreviousUid();
        String remotePreviousAppid = info.getPreviousAppid();
        String senderUid = info.getSenderUid();
        String senderAppid = info.getSenderAppid();
        if (this.DEBUG) {
            this.debug("checking okToApplyEvent for " + info + "\n local broker id = " + AddrUtil.stringToClientId(Config.BROKER_UID, "Broker"));
        }
        if ((bs = cc.getDurableBrokerSubscription()) != null) {
            boolean activeAtBoth;
            Boolean eventShouldBeApplied = null;
            long localTimestamp = bs.getCreationTime();
            IClientContext localActiveCC = cc.getCWADSActiveBroker();
            IClientContext localPreviousCC = cc.getCWADSPreviousBroker();
            boolean localShouldDefer = false;
            boolean remoteShouldDefer = false;
            long remoteAuthority = -1L;
            if (localActiveCC != null) {
                if (localActiveCC.getUid().equalsIgnoreCase(senderUid) && localActiveCC.getAppid().equalsIgnoreCase(senderAppid)) {
                    if (this.DEBUG) {
                        this.debug(" okToApplyEvent local authority is based on activecc " + localActiveCC.getUid() + "/" + localActiveCC.getAppid());
                    }
                    localShouldDefer = true;
                }
            } else if (localActiveCC == null && remoteActiveUid.equals(senderUid) && remoteActiveAppid.equals(senderAppid)) {
                localShouldDefer = true;
                if (this.DEBUG) {
                    this.debug(" okToApplyEvent remote broker has locally active subscriber, local broker doesn't: local should defer");
                }
            } else if (localPreviousCC != null && localPreviousCC.getUid().equalsIgnoreCase(senderUid) && localPreviousCC.getAppid().equalsIgnoreCase(senderAppid) && !this.isStateEventType(eventType)) {
                localShouldDefer = true;
                if (this.DEBUG) {
                    this.debug("okToApplyEvent local authority is based on previouscc" + localPreviousCC.getUid() + "/" + localPreviousCC.getAppid());
                }
            }
            if (!remoteActiveUid.equals(CWADS_INACTIVE)) {
                remoteAuthority = AddrUtil.stringToClientId(remoteActiveUid, remoteActiveAppid);
                if (remoteActiveUid.equalsIgnoreCase(Config.BROKER_UID) && remoteActiveAppid.equalsIgnoreCase("Broker")) {
                    remoteShouldDefer = true;
                }
                if (this.DEBUG) {
                    this.debug(" okToApplyEvent remote authority is active " + remoteActiveUid + "/" + remoteActiveAppid + " " + remoteAuthority);
                }
            } else if (remoteActiveUid.equals(CWADS_INACTIVE) && localActiveCC != null) {
                if (localActiveCC.getId() == cc.getId()) {
                    remoteShouldDefer = true;
                    if (this.DEBUG) {
                        this.debug(" okToApplyEvent local broker has locally active subscriber, remote broker doesn't: remote should defer");
                    }
                } else if (!localActiveCC.getUid().equalsIgnoreCase(senderUid) || !localActiveCC.getAppid().equalsIgnoreCase(senderAppid)) {
                    remoteShouldDefer = true;
                    if (this.DEBUG) {
                        this.debug(" okToApplyEvent local broker has remotely active subscriber, remote broker doesn't: remote should defer");
                    }
                }
            } else if (!remotePreviousUid.equals(CWADS_INACTIVE)) {
                remoteAuthority = AddrUtil.stringToClientId(remotePreviousUid, remotePreviousAppid);
                if (remotePreviousUid.equalsIgnoreCase(Config.BROKER_UID) && remotePreviousAppid.equalsIgnoreCase("Broker") && eventType != 102) {
                    remoteShouldDefer = true;
                    if (this.DEBUG) {
                        this.debug("okToApplyEvent remote authority is previous " + remotePreviousUid + "/" + remotePreviousAppid + " " + remoteAuthority);
                    }
                }
            }
            boolean activeLocally = CWADSInfoHelper.locallyActiveLocally(cc);
            boolean activeAtSender = CWADSInfoHelper.activeAtSender(info);
            boolean bl = activeAtBoth = activeLocally && activeAtSender;
            if (activeAtBoth) {
                long localRootId = -1L;
                try {
                    localRootId = cc.getRootId();
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
                if (localRootId == info.getRootClientId() || this.m_reg.isInternalAppid(localRootId)) {
                    if (cc.isResumable() && !info.getIsResumable()) {
                        localShouldDefer = true;
                        if (this.DEBUG) {
                            this.debug("Durable active on sender but resumable locally, local will defer for: " + info);
                        }
                    } else if (info.getIsResumable() && !cc.isResumable()) {
                        remoteShouldDefer = true;
                        if (this.DEBUG) {
                            this.debug("Durable resumable on sender but active locally, remote will defer for: " + info);
                        }
                    }
                }
            } else if (activeAtSender && info.getIsResumable() && !activeLocally && localActiveCC != null) {
                remoteShouldDefer = true;
                if (this.DEBUG) {
                    this.debug("Durable resumable on sender but locally connected elsewhere, remote will defer for: " + info);
                }
            }
            if (CWADSInfoHelper.inactiveOnSender(info) && cc.isResumable() && cc.getCWADSActiveBroker() == null && eventType != 102) {
                remoteShouldDefer = true;
                localShouldDefer = false;
                if (this.DEBUG) {
                    this.debug("okToApplyEvent: inactive on remote but resumable locally remote should defer: " + info);
                }
            }
            if (this.DEBUG) {
                this.debug("okToApplyEvent localShouldDefer = " + localShouldDefer + " remoteShouldDefer + " + remoteShouldDefer);
            }
            if (localShouldDefer && !remoteShouldDefer) {
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG - okToApplyEvent - localShouldDefer and not remoteShouldDefer so we ARE applying event");
                }
                eventShouldBeApplied = Boolean.TRUE;
            } else if (!localShouldDefer && remoteShouldDefer) {
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG - okToApplyEvent - not localShouldDefer and remoteShouldDefer so we are NOT applying event");
                }
                eventShouldBeApplied = Boolean.FALSE;
            } else if (eventTimestamp == localTimestamp && !this.hasSubscriptionChanged(info, bs)) {
                if (localActiveCC != null && localPreviousCC != null && localActiveCC.getId() == AddrUtil.stringToClientId(remoteActiveUid, remoteActiveAppid) && localPreviousCC.getId() == AddrUtil.stringToClientId(remotePreviousUid, remotePreviousAppid)) {
                    eventShouldBeApplied = Boolean.FALSE;
                    if (this.DEBUG) {
                        this.debug("CWADS_DEBUG - okToApplyEvent - Active, but nothing has changed, no need to apply event." + localShouldDefer + remoteShouldDefer);
                    }
                } else if (localActiveCC == null && localPreviousCC == null && remoteActiveUid.equals(CWADS_INACTIVE) && remotePreviousUid.equals(CWADS_INACTIVE)) {
                    eventShouldBeApplied = Boolean.FALSE;
                    if (this.DEBUG) {
                        this.debug("CWADS_DEBUG - okToApplyEvent - Inactive, and nothing has changed, no need to apply event.");
                    }
                } else if (localActiveCC != null && localPreviousCC == null && localActiveCC.getId() == AddrUtil.stringToClientId(remoteActiveUid, remoteActiveAppid) && remotePreviousUid.equals(CWADS_INACTIVE)) {
                    eventShouldBeApplied = Boolean.FALSE;
                    if (this.DEBUG) {
                        this.debug("CWADS_DEBUG - okToApplyEvent - Active no Previous, and nothing else has changed, no need to apply event.");
                    }
                } else if (localActiveCC == null && localPreviousCC != null && remoteActiveUid.equals(CWADS_INACTIVE) && localPreviousCC.getId() == AddrUtil.stringToClientId(remotePreviousUid, remotePreviousAppid)) {
                    eventShouldBeApplied = Boolean.FALSE;
                    if (this.DEBUG) {
                        this.debug(" CWADS_DEBUG - okToApplyEvent - Inactive with matching previouscc, and nothing else has changed, no need to apply event.");
                    }
                }
            }
            if (eventShouldBeApplied == null) {
                if (localActiveCC == null) {
                    if (eventType == 102) {
                        if (this.DEBUG) {
                            this.debug(" okToApplyEvent - activecc == null and event type is CWADS_UNSUBSCRIBE so we are applying event");
                        }
                        eventShouldBeApplied = Boolean.TRUE;
                    } else if (eventTimestamp < localTimestamp) {
                        if (this.DEBUG) {
                            this.debug(" okToApplyEvent - activecc == null and event timestamp is older, so we are NOT applying event");
                        }
                        eventShouldBeApplied = Boolean.FALSE;
                    } else if (eventTimestamp > localTimestamp) {
                        if (this.DEBUG) {
                            this.debug(" okToApplyEvent - activecc == null and event timestamp is newer, so we ARE applying event");
                        }
                        eventShouldBeApplied = Boolean.TRUE;
                    } else {
                        eventShouldBeApplied = Boolean.FALSE;
                    }
                } else {
                    if (this.DEBUG) {
                        this.debug("CWADS_DEBUG - okToApplyEvent - comparing timestamps event = " + eventTimestamp + " local = " + localTimestamp);
                    }
                    if (eventType == 100) {
                        if (eventTimestamp < localTimestamp) {
                            if (this.DEBUG) {
                                this.debug(" CWADS_DEBUG - okToApplyEvent (UPDATE) - they both have active and event timestamp is older, so we ARE applying event");
                            }
                            eventShouldBeApplied = Boolean.TRUE;
                        } else if (eventTimestamp > localTimestamp) {
                            if (this.DEBUG) {
                                this.debug(" CWADS_DEBUG - okToApplyEvent (UPDATE) - they both have active and event timestamp is newer, so we ARE NOT applying event");
                            }
                            eventShouldBeApplied = Boolean.FALSE;
                        } else {
                            eventShouldBeApplied = Boolean.FALSE;
                        }
                    } else if (eventTimestamp < localTimestamp) {
                        if (this.DEBUG) {
                            this.debug(" CWADS_DEBUG - okToApplyEvent " + eventType + " - they both have active and event timestamp is older, so we ARE NOT applying event");
                        }
                        eventShouldBeApplied = Boolean.FALSE;
                    } else {
                        if (this.DEBUG) {
                            this.debug(" CWADS_DEBUG - okToApplyEvent " + eventType + " - they both have active and event timestamp is newer, so we ARE applying event");
                        }
                        eventShouldBeApplied = Boolean.TRUE;
                    }
                }
            }
            if (activeAtBoth && !eventShouldBeApplied.booleanValue()) {
                long activeid;
                long senderid;
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG okToApplyEvent - send CWADS_UPDATE back to sender, because our data is \"better\" ");
                }
                if ((senderid = AddrUtil.stringToClientId(senderUid, senderAppid)) == (activeid = AddrUtil.stringToClientId(remoteActiveUid, remoteActiveAppid))) {
                    try {
                        if (this.DEBUG) {
                            this.debug("okToApplyEvent decided it needed to send a CWADS update to senderid: " + senderid);
                        }
                        InterbrokerHook.sendCWADSEvent(100, cc, senderid);
                    }
                    catch (EGeneralCWADSException e) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                }
            }
            return eventShouldBeApplied;
        }
        return true;
    }

    private final boolean isStateEventType(int eventType) {
        switch (eventType) {
            case 103: 
            case 111: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    private final boolean hasSubscriptionChanged(ICWADSInfo info, BrokerSubscription bs) {
        if (info.getType() == 102) {
            return true;
        }
        if (!info.getLabel().equals(bs.getLabel())) {
            if (this.DEBUG) {
                this.debug("CWADSInfo labels do not match ");
            }
            return true;
        }
        if (info.getTTE() != bs.getTTE()) {
            if (this.DEBUG) {
                this.debug("CWADSInfo times to expire do not match " + info.getTTE() + " vs. " + bs.getTTE());
            }
            return true;
        }
        if (info.getSelectorAtBroker() != bs.getSelectorAtBroker()) {
            if (this.DEBUG) {
                this.debug("CWADSInfo SelectorAtBroker  do not match " + info.getSelectorAtBroker() + " vs. " + bs.getSelectorAtBroker());
            }
            return true;
        }
        if (!info.getSelector().equals(bs.getSelectorString())) {
            if (this.DEBUG) {
                this.debug("CWADSInfo selectors do not match " + info.getSelector() + " vs. " + bs.getSelectorString());
            }
            return true;
        }
        if (!info.getSubject().equals(bs.getSubject())) {
            if (this.DEBUG) {
                this.debug("CWADSInfo subjects do not match " + info.getSubject() + " vs. " + bs.getSubject());
            }
            return true;
        }
        if (info.getDurableSMO() != bs.getDurableStrictMessageOrder()) {
            if (this.DEBUG) {
                this.debug("CWADSInfo SMO doesn't match " + info.getDurableSMO() + " vs. " + bs.getDurableStrictMessageOrder());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forceDisconnect(IClientContext cc) {
        if (CWADSInfoHelper.locallyActiveLocally(cc)) {
            AgentConnection connection = cc.getConnection();
            try {
                if (connection != null) {
                    connection.prepareDisconnect(7);
                }
            }
            finally {
                cc.unlock();
            }
            try {
                if (connection == null) {
                    throw new NullPointerException("connection is null.");
                }
                connection.getAgentSender().sendThrough(MgramFactory.getMgramFactory().buildDisconnectReply(cc.getChannel(), false));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.disconnect(cc, false);
            if (connection == null) return;
            try {
                ISocket socket = connection.getSocket();
                if (socket == null) return;
                socket.close();
                return;
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                return;
            }
            finally {
                connection.close();
            }
        }
        cc.prepareDisconnect(1);
        cc.unlock();
        this.disconnect(cc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void CWADSNeighborHandshake(IClientContext neighborcc) throws EGeneralCWADSException {
        if (this.DEBUG_RECONCILE) {
            this.debug("CWADSMessageHandler.CWADSNeighborHandshake " + neighborcc.getUid() + "/" + neighborcc.getAppid());
        }
        if (neighborcc.getUid().equalsIgnoreCase(Config.BROKER_UID) && neighborcc.getAppid().equalsIgnoreCase("Broker")) {
            return;
        }
        if (this.CALLBACK) {
            this.callback("CWADSMessageHandler CWADSNeighborHandshake ", 300, new Object[]{neighborcc.getUid(), neighborcc.getAppid(), this, this.DEBUG});
        }
        Object object = s_handshakeSync;
        synchronized (object) {
            if (this.DEBUG_RECONCILE) {
                this.debug("CWADSMessageHandler.CWADSNeighborHandshake starting Phase I with " + neighborcc.getUid() + "/" + neighborcc.getAppid());
            }
            Collection result = null;
            DurableManager durmgr = this.m_reg.getDurableManager();
            Collection durSubs = durmgr.getAllDurableCCs();
            HashMap<Long, IClientContext> toReconcile = new HashMap<Long, IClientContext>(durSubs.size());
            if (!durSubs.isEmpty()) {
                LinkedList ownedHere = new LinkedList();
                Iterator p1_iterator = durSubs.iterator();
                while (p1_iterator.hasNext()) {
                    long ccid = ((IClientContext)p1_iterator.next()).getId();
                    IClientContext cc = this.m_reg.lockContext(ccid);
                    if (cc == null) {
                        if (!this.DEBUG_RECONCILE) continue;
                        this.debug("phase I  cc from durmgr's list " + ccid + " doesn't exist anymore");
                        continue;
                    }
                    try {
                        toReconcile.put(new Long(ccid), cc);
                        IClientContext activecc = cc.getCWADSActiveBroker();
                        IClientContext previouscc = cc.getCWADSPreviousBroker();
                        if (activecc != null && !activecc.isInterbroker()) {
                            this.debugPhaseIAdding(cc, ownedHere);
                            continue;
                        }
                        if (activecc != null || previouscc == null || previouscc.isInterbroker()) continue;
                        this.debugPhaseIAdding(cc, ownedHere);
                    }
                    finally {
                        cc.unlock();
                    }
                }
                if (!ownedHere.isEmpty()) {
                    block64: {
                        try {
                            result = durmgr.performCWADSRequest(neighborcc.getUid(), CWADSListXferOp.makeMgram(HANDSHAKE_PHASE_1, ownedHere.iterator()));
                        }
                        catch (EDurableOperationException e) {
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase I CANCELLED " + e.toString(), e);
                        }
                        catch (InterruptedException e) {
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase I CANCELLED " + e.toString(), e);
                        }
                        catch (Exception e) {
                            if (result != null) break block64;
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase I CANCELLED - No Reply Data returned 100", e);
                        }
                    }
                    if (result == null) {
                        throw new EGeneralCWADSException("CWADS LIST XFER Phase I CANCELLED - No Reply Data returned 100");
                    }
                    Iterator iter = result.iterator();
                    CWADSListXferReplyOp returnResult = null;
                    while (iter.hasNext()) {
                        CWADSListXferReplyOp reply = (CWADSListXferReplyOp)iter.next();
                        if (reply.getErrorCode() != 0) {
                            this.debugListXferFailed(reply);
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase I FAILED - Neighbor unable to process list: " + reply.getErrorCode());
                        }
                        returnResult = reply;
                    }
                    if (returnResult == null) {
                        throw new EGeneralCWADSException("CWADS LIST XFER Phase I FAILED - Neighbor sent no reply3");
                    }
                    Enumeration<CWADSInfoOp> enu = returnResult.infoMgramsEnum();
                    while (enu.hasMoreElements()) {
                        CWADSInfoOp info = enu.nextElement();
                        toReconcile.remove(new Long(info.getId()));
                        IClientContext cc = null;
                        try {
                            cc = this.m_reg.getClient(info.getId());
                        }
                        catch (EClientNotRegistered ecnr) {
                            if (!this.DEBUG_RECONCILE) continue;
                            this.debug("CWADS LIST XFER Phase I, durable no longer exists locally ignoring reply: " + info, ecnr);
                            continue;
                        }
                        try {
                            if (this.DEBUG_RECONCILE) {
                                this.debug("CWADS LIST XFER Phase I comparing REMOTE INFO: " + info + " to LOCAL INFO: " + CWADSInfoHelper.getLocalInfo(cc));
                            }
                            this.compareAndUpdateCC(null, info);
                            if (!this.DEBUG_RECONCILE) continue;
                            this.debug("CWADS LIST XFER Phase I comparison result: " + CWADSInfoHelper.getLocalInfo(cc));
                        }
                        catch (Exception e) {
                            BrokerComponent.logMessage("CWADS LIST XFER Phase I FAILED to update local durable subscription from remote broker's data", e, BrokerComponent.getLevelWarning());
                        }
                    }
                }
                if (this.DEBUG_RECONCILE) {
                    this.debug("Phase I done.");
                }
                this.sendLocalSecondaryState(neighborcc);
                HashMap ownedThere = new HashMap(toReconcile.size());
                Iterator p2_iterator = toReconcile.keySet().iterator();
                while (p2_iterator.hasNext()) {
                    Long ccid;
                    IClientContext cc;
                    if (this.DEBUG_RECONCILE) {
                        this.debug("CWADSMessageHandler.CWADSNeighborHandshake starting Phase II with " + CWADSInfoHelper.getUidAppid(neighborcc));
                    }
                    if ((cc = this.m_reg.lockContext(ccid = (Long)p2_iterator.next())) == null) {
                        if (!this.DEBUG_RECONCILE) continue;
                        this.debug("phase II  cc from durmgr's list " + ccid + " doesn't exist anymore");
                        continue;
                    }
                    try {
                        IClientContext activecc = cc.getCWADSActiveBroker();
                        IClientContext previouscc = cc.getCWADSPreviousBroker();
                        if (activecc != null && activecc.getUid().equalsIgnoreCase(neighborcc.getUid()) && activecc.getAppid().equalsIgnoreCase(neighborcc.getAppid())) {
                            this.debugPhaseIIAdding(cc, ccid, ownedThere);
                            continue;
                        }
                        if (activecc != null || previouscc == null || !previouscc.getUid().equalsIgnoreCase(neighborcc.getUid()) || !previouscc.getAppid().equalsIgnoreCase(neighborcc.getAppid())) continue;
                        this.debugPhaseIIAdding(cc, ccid, ownedThere);
                    }
                    finally {
                        cc.unlock();
                    }
                }
                if (!ownedThere.isEmpty()) {
                    IClientContext cc;
                    block65: {
                        try {
                            result = durmgr.performCWADSRequest(neighborcc.getUid(), CWADSListXferOp.makeMgram(HANDSHAKE_PHASE_2, ownedThere.values().iterator()));
                        }
                        catch (EDurableOperationException e) {
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase II CANCELLED " + e.toString(), e);
                        }
                        catch (InterruptedException e) {
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase II CANCELLED " + e.toString(), e);
                        }
                        catch (Exception e) {
                            if (result != null) break block65;
                            throw new EGeneralCWADSException("CWADS LIST XFER Phase II CANCELLED 100", e);
                        }
                    }
                    if (result == null) {
                        throw new EGeneralCWADSException("CWADS LIST XFER Phase II CANCELLED 100");
                    }
                    Iterator iter = result.iterator();
                    CWADSListXferReplyOp returnResult = null;
                    while (iter.hasNext()) {
                        CWADSListXferReplyOp reply = (CWADSListXferReplyOp)iter.next();
                        if (reply.getErrorCode() != 0) {
                            this.debugListXferFailed(reply);
                            throw new EGeneralCWADSException("CWADS LIST XFERPhase II FAILED " + reply.getErrorCode());
                        }
                        if (this.DEBUG_RECONCILE) {
                            this.debug("CWADS_DEBUG: LIST XFER Phase II reply received " + reply.toString());
                        }
                        returnResult = reply;
                    }
                    if (returnResult == null) {
                        throw new EGeneralCWADSException("CWADS LIST XFER FAILED 3");
                    }
                    Enumeration<CWADSInfoOp> enu = returnResult.infoMgramsEnum();
                    while (enu.hasMoreElements()) {
                        CWADSInfoOp info = enu.nextElement();
                        ownedThere.remove(new Long(info.getId()));
                        cc = null;
                        try {
                            cc = this.m_reg.getClient(info.getId());
                        }
                        catch (EClientNotRegistered ex) {
                            if (!this.DEBUG_RECONCILE) continue;
                            this.debug("Phase II reply received but skipping update since the cc has since unregistered for: " + info);
                            continue;
                        }
                        try {
                            if (this.DEBUG_RECONCILE) {
                                this.debug("CWADS LIST XFER Phase II comparing REMOTE INFO: " + info + " to LOCAL INFO: " + CWADSInfoHelper.getLocalInfo(cc));
                            }
                            this.compareAndUpdateCC(null, info);
                            if (!this.DEBUG_RECONCILE) continue;
                            this.debug("CWADS LIST XFER Phase II comparison result: " + CWADSInfoHelper.getLocalInfo(cc));
                        }
                        catch (Exception e) {
                            BrokerComponent.logMessage("CWADS LIST XFER Phase II FAILED to update local durable subscription from remote broker's data", e, BrokerComponent.getLevelWarning());
                        }
                    }
                    Iterator needToBeUnsubscribedIds = ownedThere.keySet().iterator();
                    while (needToBeUnsubscribedIds.hasNext()) {
                        try {
                            cc = this.m_reg.getClient((Long)needToBeUnsubscribedIds.next());
                            if (this.DEBUG_RECONCILE) {
                                try {
                                    this.debug("unsubscribing obsolete durable subscription for " + CWADSInfoHelper.getLocalInfo(cc));
                                }
                                catch (ESubscriptionNotFound esnf) {
                                    this.debug("unsubscribing obsolete durable subscription ", esnf);
                                }
                            }
                            this.unsubscribe(cc);
                        }
                        catch (EClientNotRegistered cc2) {
                        }
                        catch (EGeneralException e) {
                            if (!this.DEBUG_RECONCILE) continue;
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        catch (InterruptedException e) {
                            if (this.DEBUG_RECONCILE) {
                                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                            }
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            if (this.DEBUG_RECONCILE) {
                this.debug("CWADSMessageHandler.CWADSNeighborHandshake ending with " + neighborcc.getUid() + "/" + neighborcc.getAppid());
            }
        }
        if (this.DEBUG_RECONCILE) {
            this.debug("CWADSNeighborHandshake is done");
        }
    }

    private void debugPhaseIAdding(IClientContext cc, LinkedList ownedHere) {
        if (this.DEBUG_RECONCILE) {
            try {
                this.debug("phase I adding: " + CWADSInfoHelper.getLocalInfo(cc));
            }
            catch (ESubscriptionNotFound esnf) {
                this.debug("phase I adding: " + esnf, esnf);
            }
        }
        ownedHere.add(cc);
    }

    private void debugPhaseIIAdding(IClientContext cc, Long ccid, HashMap ownedThere) {
        if (this.DEBUG_RECONCILE) {
            try {
                this.debug("phase II adding: " + CWADSInfoHelper.getLocalInfo(cc));
            }
            catch (ESubscriptionNotFound esnf) {
                this.debug("phase II adding: " + esnf, esnf);
            }
        }
        ownedThere.put(ccid, cc);
    }

    private void debugListXferFailed(CWADSListXferReplyOp reply) {
        if (this.DEBUG_RECONCILE) {
            this.debug("CWADS_DEBUG: LIST XFER failed " + reply.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CWADSListXferReplyOp handleCWADSListXferOp(CWADSListXferOp op) {
        CWADSListXferReplyOp result = null;
        IClientContext cc = null;
        boolean fatalerror = false;
        ArrayList<IClientContext> subscriptions = new ArrayList<IClientContext>();
        Enumeration enu = op.getInfoMgrams();
        while (enu.hasMoreElements()) {
            IClientContext neighborcc = null;
            try {
                long durableCCID;
                CWADSInfoOp info;
                block20: {
                    info = new CWADSInfoOp((IMgram)enu.nextElement());
                    String bname = info.getSenderUid();
                    neighborcc = null;
                    try {
                        neighborcc = AgentRegistrar.getAgentRegistrar().getClient(AddrUtil.stringToClientId(bname, "Broker"));
                        neighborcc.lock();
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                        // empty catch block
                    }
                    if (this.DEBUG_RECONCILE) {
                        this.debug("CWADSListXferOp phase " + op.getPhase() + " checking " + info.toString());
                    }
                    durableCCID = AddrUtil.stringToClientId(info.getUid(), info.getAppid());
                    try {
                        cc = this.m_reg.getClient(durableCCID);
                    }
                    catch (EClientNotRegistered ecnr) {
                        if (op.getPhase() != 2) break block20;
                        if (neighborcc == null) continue;
                        neighborcc.unlock();
                        continue;
                    }
                }
                if (this.DEBUG_RECONCILE) {
                    this.debug("CWADSListXferOp phase " + op.getPhase() + "compareAndUpdateCC(null, info) where info = " + info.toString());
                }
                this.compareAndUpdateCC(null, info);
                try {
                    cc = this.m_reg.getClient(durableCCID);
                }
                catch (EClientNotRegistered ecnr) {
                    if (neighborcc == null) continue;
                    neighborcc.unlock();
                    continue;
                }
                if (cc == null) continue;
                subscriptions.add(cc);
            }
            catch (Exception e) {
                BrokerComponent.logMessage("Error handling Neighbor reconciliation request.", e, BrokerComponent.getLevelWarning());
                fatalerror = true;
                break;
            }
            finally {
                if (neighborcc == null) continue;
                neighborcc.unlock();
            }
        }
        if (fatalerror) {
            if (this.DEBUG_RECONCILE) {
                this.debug("CWADSListXferOp sending EDurableOperationException.SUBSCRIBER_NOT_FOUND reply due to fatal error");
            }
            result = new CWADSListXferReplyOp(true, null);
            result.setErrorCode(4);
        } else {
            if (this.DEBUG_RECONCILE) {
                this.debug("CWADSListXferOp sending CWADSListXferReplyOp");
            }
            result = new CWADSListXferReplyOp(true, subscriptions.iterator());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void sendLocalSecondaryState(IClientContext neighborcc) throws EGeneralCWADSException {
        if (this.DEBUG) {
            this.debug("Sending secondary state to " + neighborcc);
        }
lbl3:
        // 12 sources

        block10: for (IClientContext cc : this.m_reg.getDurableManager().getAllDurableCCs()) {
            try {
                neighborcc.lock();
                if (neighborcc.isDisconnecting() || cc.getProxyingHandle() == null) continue;
                try {
                    cc.getProxyingHandle().freezeProxy();
                    if (cc.getCWADSActiveBroker() == null || cc.getCWADSActiveBroker().getId() != cc.getId() || (bs = cc.getDurableBrokerSubscription()) == null) continue;
                    state = cc.getState();
                    switch (state) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (this.DEBUG) {
                                this.debug(cc.getUid() + "/" + cc.getAppid() + "sending the other side a start delivery because it's active here. state:" + state);
                            }
                            cc.getProxyingHandle().addStartedInboundProxy(neighborcc.getId());
                            InterbrokerHook.sendCWADSEvent(111, cc, neighborcc.getId());
                            ** break;
                        }
                        case -1: 
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (!this.DEBUG) continue block10;
                            this.debug(cc.getUid() + "/" + cc.getAppid() + "skip sending the other side a start delivery because it's active here but not in a started state:" + state);
                            ** break;
                        }
                        default: {
                            if (!this.DEBUG) continue block10;
                            this.debug(cc.getUid() + "/" + cc.getAppid() + "skip sending the other side a start delivery because we're in an unknown state :" + state);
                            continue block10;
                        }
                    }
                }
                finally {
                    cc.getProxyingHandle().unfreezeProxy();
                }
            }
            finally {
                neighborcc.unlock();
            }
        }
    }

    final void handleRemoteRestorePhasesDoneMgram(IMgram m) throws IOException, InterruptedException {
        try {
            IClientContext durableCC = this.m_reg.getClient(m.getPayloadInputStreamHandle().readLong());
            if (this.DEBUG) {
                this.debug("Remote restore done received for " + durableCC.getUid() + "/" + durableCC.getAppid() + " From: " + CWADSInfoHelper.getUidAppid(m.getBrokerHandle().getSenderID()));
            }
            durableCC.handleRemoteRestoreDone();
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    final void handleFirstMessageNotification(IMgram m) throws IOException {
        try {
            IClientContext durableCC = this.m_reg.getClient(m.getPayloadInputStreamHandle().readLong());
            if (this.DEBUG) {
                this.debug("First Message Notification received for " + durableCC.getUid() + "/" + durableCC.getAppid() + " From: " + CWADSInfoHelper.getUidAppid(m.getBrokerHandle().getSenderID()));
            }
            durableCC.getProxyingHandle().addLiveInboundProxy(m.getBrokerHandle().getSenderID());
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    final void handleLastMessageNotification(IMgram m) throws IOException {
        try {
            IClientContext durableCC = this.m_reg.getClient(m.getPayloadInputStreamHandle().readLong());
            if (this.DEBUG) {
                this.debug("Last Message Notification received for " + durableCC.getUid() + "/" + durableCC.getAppid() + " From: " + CWADSInfoHelper.getUidAppid(m.getBrokerHandle().getSenderID()));
            }
            durableCC.getProxyingHandle().removeLiveInboundProxy(m.getBrokerHandle().getSenderID());
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    private void assertNoTimer(IClientContext cc) {
        if (this.m_reg == null || this.m_reg.getDisconnectTimerManager() == null) {
            return;
        }
        if (!this.m_reg.getDisconnectTimerManager().outOfTime(cc.getId())) {
            System.out.println("Rogue timer running for:" + cc.getAppid());
            Thread.dumpStack();
        }
    }

    final void handleDeliveryFinishedNotification(IMgram m) throws IOException {
        try {
            IClientContext durableCC = this.m_reg.getClient(m.getPayloadInputStreamHandle().readLong());
            if (this.DEBUG) {
                this.debug("Delivery Finished Notification received for " + durableCC.getUid() + "/" + durableCC.getAppid() + " From: " + CWADSInfoHelper.getUidAppid(m.getBrokerHandle().getSenderID()));
            }
            durableCC.getProxyingHandle().removeStartedInboundProxy(m.getBrokerHandle().getSenderID());
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    private static final class CWADSInfoHelper {
        private CWADSInfoHelper() {
        }

        private static boolean activeAtSender(ICWADSInfo remoteInfo) {
            return remoteInfo.getActiveUid().equals(remoteInfo.getSenderUid()) && remoteInfo.getActiveAppid().equals(remoteInfo.getSenderAppid());
        }

        private static boolean locallyActiveLocally(IClientContext localCC) {
            return localCC.getCWADSActiveBroker() != null && localCC.getCWADSActiveBroker().getId() == localCC.getId();
        }

        private static boolean locallyActiveOnSender(IClientContext localCC, ICWADSInfo remoteInfo) {
            IClientContext localActiveCC = localCC.getCWADSActiveBroker();
            return localActiveCC != null && localActiveCC.getUid().equals(remoteInfo.getSenderUid()) && localActiveCC.getAppid().equals(remoteInfo.getSenderAppid());
        }

        private static String getSenderUidAppid(ICWADSInfo info) {
            return info.getSenderUid() + "/" + info.getSenderAppid();
        }

        private static String getActiveUidAppid(ICWADSInfo info) {
            return info.getActiveUid() + "/" + info.getActiveAppid();
        }

        private static String getActiveUidAppid(IClientContext cc) {
            if (cc.getCWADSActiveBroker() != null) {
                return cc.getCWADSActiveBroker().getUid() + "/" + cc.getCWADSActiveBroker().getAppid();
            }
            return "$INACTIVE/$INACTIVE";
        }

        private static String getUidAppid(IClientContext cc) {
            if (cc == null) {
                return "NULL";
            }
            return cc.getUid() + "/" + cc.getAppid();
        }

        private static String getUidAppid(long id) {
            try {
                return CWADSInfoHelper.getUidAppid(AgentRegistrar.getAgentRegistrar().getClient(id));
            }
            catch (EClientNotRegistered ecnr) {
                return "UNREGISTERED";
            }
        }

        private static final IClientContext getSenderActiveCC(IClientContext cc, ICWADSInfo remoteInfo) throws EClientNotRegistered {
            if (!CWADSInfoHelper.inactiveOnSender(remoteInfo)) {
                if (remoteInfo.getActiveUid().equals(Config.BROKER_UID) && remoteInfo.getActiveAppid().equals("Broker")) {
                    return cc;
                }
                return AgentRegistrar.getAgentRegistrar().getClient(AddrUtil.stringToClientId(remoteInfo.getActiveUid(), remoteInfo.getActiveAppid()));
            }
            return null;
        }

        private static final IClientContext getSenderRestoringBrokerCC(IClientContext targetcc, ICWADSInfo info) {
            if (info.getRestoringBrokerId() != -1L) {
                try {
                    IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(info.getRestoringBrokerId());
                    if (cc.getUid().equals(Config.BROKER_UID) && cc.getAppid().equals("Broker")) {
                        return targetcc;
                    }
                    return cc;
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
            }
            return null;
        }

        private static final IClientContext getSenderPreviousCC(IClientContext targetcc, ICWADSInfo info) {
            IClientContext previouscc = null;
            long previousid = -1L;
            if (!info.getPreviousUid().equalsIgnoreCase(CWADSMessageHandler.CWADS_INACTIVE)) {
                if (info.getPreviousUid().equals(Config.BROKER_UID) && info.getPreviousAppid().equals("Broker")) {
                    previouscc = targetcc;
                } else {
                    previousid = AddrUtil.stringToClientId(info.getPreviousUid(), info.getPreviousAppid());
                    try {
                        previouscc = AgentRegistrar.getAgentRegistrar().getClient(previousid);
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                        // empty catch block
                    }
                }
            }
            return previouscc;
        }

        private static boolean inactiveOnSender(ICWADSInfo remoteInfo) {
            return remoteInfo.getActiveAppid().equals(CWADSMessageHandler.CWADS_INACTIVE) || remoteInfo.getActiveUid().equals(CWADSMessageHandler.CWADS_INACTIVE);
        }

        private static ICWADSInfo getLocalInfo(IClientContext cc) throws ESubscriptionNotFound {
            return new CWADSInfo(cc);
        }
    }
}

