/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.parser.ParseException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.SearchResults;

public class GroupSubscription
extends DebugObject
implements ISubjectMatchObject {
    static final byte FIRST_SESSION_VERSION_WITH_CLIENT_SUPPORT = 25;
    private static final long DEFAULT_BACKLOGGED_SESSION_SKIP_WARNING_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private static final int DEFAULT_BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT = 5;
    private static Long s_backloggedSessionSkipWarnInterval;
    private static Integer s_backloggedSessionSkipWarnBunchLimit;
    private Map<String, Long[]> m_backloggedSessionSkipTracker = new HashMap<String, Long[]>();
    protected ISubject m_subject;
    private String m_groupName;
    private int m_durableMemberCount = 0;
    private int m_ftMemberCount = 0;
    private Boolean m_hasSelector = null;
    private String m_selector = null;
    private boolean DEBUG1;
    private Boolean m_isDupsOK = null;
    private volatile Boolean m_batchable = null;
    protected ArrayList<BrokerSubscription> m_subs;
    private int m_curSub;
    private int m_curCirculatingSub = 0;
    private int m_curDisDur;
    private boolean m_receiverAffinityReduction = Config.ENABLE_INTERBROKER && BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition() && !Config.DISABLE_DYNAMIC_GROUP_SUBSCRIPTION_DISTRIBUTION;
    private GroupSubscriptionClientContext m_groupcc = null;
    private AgentRegistrar m_reg = null;
    private Object m_groupSubSyncObj = new Object();
    private HashMap<Long, Long> m_receiversLastMessageTime = new HashMap();
    private Set<Long> m_nonReceivers = new HashSet<Long>();
    private Set<Long> m_circulatees = new HashSet<Long>();
    private boolean m_circulating;
    private long m_circulatingStartTime;
    private long m_circulatingEndTime;
    private Random m_random = new Random();
    private long m_affinities;
    private long m_handoffsReceived;
    private long m_handoffsSent;
    private long m_offloads;
    private long m_flowControlled;
    private long m_disconnectedReturns;
    private long m_affinitiesThisInterval;
    private long m_handoffsReceivedThisInterval;
    private long m_handoffsSentThisInterval;
    private long m_offloadsThisInterval;
    private long m_flowControlledThisInterval;
    private long m_disconnectedReturnsThisInterval;
    static final byte OFFLOADING_NO_CHECK = 0;
    static final byte OFFLOADING_FALSE = 1;
    static final byte OFFLOADING_TRUE = 2;
    private DebugObject m_instanceDebug;

    protected Object getGroupSubscriptionSyncObj() {
        return this.m_groupSubSyncObj;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    final void setGroupName(String groupName) {
        this.m_groupName = groupName;
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    protected void setSubject(ISubject subject) {
        this.m_subject = subject;
    }

    GroupSubscription(ISubject groupSubject, AgentRegistrar reg) {
        super("GroupSubscription " + groupSubject.getSubjectString());
        this.DEBUG1 = this.checkDebugFlags(64);
        if (this.DEBUG1) {
            this.debug("Constructor with " + groupSubject);
        }
        this.m_subject = groupSubject;
        this.setGroupName(groupSubject.getSubjectString());
        this.m_subs = new ArrayList();
        this.m_reg = reg;
        class InstanceDebug
        extends DebugObject {
            InstanceDebug() {
                super(GroupSubscription.this.m_groupName);
                this.updateDebugFlags = true;
            }
        }
        this.m_instanceDebug = new InstanceDebug();
    }

    @Override
    public String toString() {
        return "GroupSubscription for group " + this.m_groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(BrokerSubscription bs) throws EInvalidSubjectSyntax, ParseException {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            boolean isDupsOk;
            this.verifySelector(bs);
            this.m_subs.add(bs);
            if (this.DEBUG1) {
                this.debug("addSubscription added: bs= " + bs + " hasSelectors= " + bs.hasSelectors() + " groupSelector= " + this.m_selector + " m_subs.size= " + this.m_subs.size());
            }
            bs.setGroup(this);
            if (bs.getClient().isDurable()) {
                ++this.m_durableMemberCount;
            }
            if (bs.getClient().isXOnce()) {
                ++this.m_ftMemberCount;
            }
            boolean bl = isDupsOk = bs.getClient().getAckMode() == 3;
            if (this.m_isDupsOK == null || this.m_isDupsOK.booleanValue()) {
                this.m_isDupsOK = isDupsOk ? Boolean.TRUE : Boolean.FALSE;
            }
            this.calculateBatchable();
            if (this.DEBUG) {
                this.debug(" --> m_subs.size() = " + this.m_subs.size() + " isPurelyDurable() = " + this.isPurelyDurable());
            }
        }
    }

    public void subjectModified(ISubject added, ISubject removed) throws EInvalidSubjectSyntax {
        throw new UnsupportedOperationException("Subject modification is not supported for single subject groups.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("removeSubscription: " + bs);
        }
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            this.m_subs.remove(bs);
            if (this.DEBUG1) {
                this.debug("removeSubscription removed: bs= " + bs + " m_subs.size= " + this.m_subs.size());
            }
            bs.setGroup(null);
            if (bs.getClient().isDurable()) {
                --this.m_durableMemberCount;
            }
            if (bs.getClient().isXOnce()) {
                --this.m_ftMemberCount;
            }
            if (bs.getClient().getAckMode() != 3) {
                this.m_isDupsOK = null;
            }
            if (this.m_subs.isEmpty()) {
                this.m_hasSelector = null;
            }
            this.calculateBatchable();
            if (this.DEBUG) {
                String result = "GroupSubscription for group " + this.m_groupName + "\n[Local member count: " + this.m_subs.size() + " isPurelyDurable: " + this.isPurelyDurable() + "]";
                result = result + " on AgentRegistar.getId()=" + AgentRegistrar.getAgentRegistrar().getId() + " BROKER_APPID/NAME=" + "Broker" + "/" + Config.BROKER_NAME;
                int subCount = this.m_subs.size();
                for (int i = 0; i < subCount; ++i) {
                    BrokerSubscription bsi = this.m_subs.get(i);
                    IClientContext cc = bsi.getClient();
                    int state = cc.getState();
                    String stateString = "";
                    if (cc.isUnregistered()) {
                        stateString = " unregistered";
                    } else if (cc.isConnected()) {
                        stateString = " connected";
                    } else if (cc.isDisconnecting()) {
                        stateString = " disconnecting";
                    } else if (cc.isDisconnected()) {
                        stateString = " disconnected";
                    }
                    result = result + "\n  (" + i + ") " + bsi + " [State: " + state + stateString + "]";
                    result = result + "\n    --> [cc.getId()=" + cc.getId() + " cc.getAppId()=" + cc.getAppid() + "]";
                    if (cc.isDurable()) {
                        result = result + "-durable";
                    }
                    if (!cc.isInterbroker()) continue;
                    result = result + "-ib";
                }
                this.debug(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGroupMemberIds() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            ArrayList<Long> memberIds = new ArrayList<Long>();
            Iterator<BrokerSubscription> iter = this.m_subs.iterator();
            while (iter.hasNext()) {
                IClientContext cc = iter.next().getClient();
                if (cc == null) continue;
                memberIds.add(new Long(cc.getId()));
            }
            return memberIds.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performReceiverMaintenance() {
        if (!this.m_receiverAffinityReduction) {
            return;
        }
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            HashSet<Long> processed = new HashSet<Long>();
            this.m_nonReceivers.clear();
            long now = System.currentTimeMillis();
            Iterator<BrokerSubscription> iter = this.m_subs.iterator();
            while (iter.hasNext()) {
                long ibid;
                IClientContext cc = iter.next().getClient();
                IClientContext ibcc = this.getIBCC(cc);
                if (ibcc == null || processed.contains(ibid = ibcc.getId())) continue;
                processed.add(ibid);
                this.performIndividualReceiverMaintenance(ibid, now);
            }
            this.performIndividualReceiverMaintenance(this.m_reg.getId(), now);
            this.updateCirculatingState();
            this.traceReceiverStats();
        }
    }

    private void performIndividualReceiverMaintenance(long cid, long now) {
        Long lastMessageTime;
        if (this.m_receiversLastMessageTime.containsKey(cid) && now > (lastMessageTime = this.m_receiversLastMessageTime.get(cid)) + (long)(Config.GROUP_SUBSCRIPTIONS_RECEIVER_IDLE_TIMEOUT * 1000)) {
            this.m_receiversLastMessageTime.remove(cid);
        }
        if (!this.m_receiversLastMessageTime.containsKey(cid)) {
            this.m_nonReceivers.add(new Long(cid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceReceiverStats() {
        if (this.m_instanceDebug.checkDebugFlags(32)) {
            Object object = this.getGroupSubscriptionSyncObj();
            synchronized (object) {
                long now = System.currentTimeMillis();
                String circulatingState = "";
                if (this.m_circulating) {
                    long since = (now - this.m_circulatingStartTime) / 1000L;
                    long remaining = (this.m_circulatingStartTime + (long)(Config.GROUP_SUBSCRIPTIONS_CIRCULATION_TIME_LIMIT * 1000) - now) / 1000L;
                    circulatingState = new String("Circulating for: " + since + " secs. " + this.m_circulatees.size() + " circulations.\nCirculation time cap:" + (remaining < 0L ? remaining + "(overdue)" : Long.valueOf(remaining)) + " secs.");
                } else if (this.m_circulatingEndTime > 0L) {
                    long quietTime = (this.m_circulatingEndTime + (long)(Config.GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL * 1000) - now) / 1000L;
                    circulatingState = new String("Next circulation in : " + (quietTime < 0L ? quietTime + "(overdue)" : Long.valueOf(quietTime)) + "secs.");
                }
                long n = this.m_nonReceivers.size() + this.m_receiversLastMessageTime.size();
                this.m_instanceDebug.debug("Receiver stats:" + this.m_groupName + "\n" + circulatingState + "\nreceivers:" + this.clientsStr(this.m_receiversLastMessageTime.keySet()) + "\nm_nonreceivers:" + this.clientsStr(this.m_nonReceivers) + "\nm_affinities:" + this.m_affinitiesThisInterval + "(" + this.m_affinities + ")\nm_handoffsSent:" + this.m_handoffsSentThisInterval + "(" + this.m_handoffsSent + ")\nm_handoffsReceived:" + this.m_handoffsReceivedThisInterval + "(" + this.m_handoffsReceived + ")\nm_offloads:" + this.m_offloadsThisInterval + "(" + this.m_offloads + ")\nm_flowControlled:" + this.m_flowControlledThisInterval + "(" + this.m_flowControlled + ")\nm_disconnectedReturns:" + this.m_disconnectedReturnsThisInterval + "(" + this.m_disconnectedReturns + ")\nGiveaway(g) " + this.m_nonReceivers.size() + " out of every(n) " + n + " messages.\n");
                this.m_disconnectedReturnsThisInterval = 0L;
                this.m_flowControlledThisInterval = 0L;
                this.m_offloadsThisInterval = 0L;
                this.m_handoffsReceivedThisInterval = 0L;
                this.m_handoffsSentThisInterval = 0L;
                this.m_affinitiesThisInterval = 0L;
            }
        }
    }

    private String clientsStr(Set<Long> l) {
        StringBuffer sb = new StringBuffer();
        for (Long cid : l) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.m_reg.getClientName(cid));
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.m_subs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription selectBrokerSubscription(IMgram msg, LBSTrackingInfo visitedBrokerList, FastVector reallocationOptions) {
        GroupSubscriptionClientContext groupcc = this.m_groupcc;
        if (groupcc != null && groupcc.hasRecoveredInDoubtMembers()) {
            return null;
        }
        String lastTest = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            BrokerSubscription bs = null;
            if (this.m_receiverAffinityReduction) {
                if (reallocationOptions == null) {
                    this.updateReceivers(visitedBrokerList);
                }
                if (reallocationOptions == null && (visitedBrokerList == null || visitedBrokerList.getHopCount() == 0)) {
                    bs = this.loadBalanceToConnectedNeighbor(msg);
                }
                if (bs != null) {
                    if (!this.m_circulating) {
                        this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
                    }
                    return bs;
                }
            }
            if (this.DEBUG) {
                lastTest = "Test: local/conn/!fc/!ackpdg";
            }
            if ((bs = this.selectConnected(msg, true, true, null, reallocationOptions, (byte)1, true)) != null) {
                this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
            }
            if (bs == null) {
                long[] visitedBrokers = null;
                if (visitedBrokerList != null) {
                    visitedBrokers = visitedBrokerList.getTransitHistoryArray();
                    if (this.DEBUG) {
                        this.debug("Visited Brokers:" + visitedBrokers);
                    }
                }
                if (this.DEBUG) {
                    lastTest = "Test: all/conn/!fc";
                }
                if ((bs = this.selectConnected(msg, true, false, visitedBrokers, reallocationOptions, (byte)1, false)) != null) {
                    this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
                }
                if (bs == null) {
                    bs = this.selectConnected(msg, true, false, visitedBrokers, reallocationOptions, (byte)2, false);
                    if (bs != null) {
                        this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
                        ++this.m_offloads;
                        ++this.m_offloadsThisInterval;
                    }
                    if (bs == null) {
                        if (!msg.isDiscardable()) {
                            if (this.DEBUG) {
                                lastTest = "Test: disconnected";
                            }
                            bs = this.selectDisconnected(msg, reallocationOptions);
                        }
                        if (bs != null && bs.getClient().getCWADSActiveBroker() == null || reallocationOptions != null) {
                            ++this.m_disconnectedReturns;
                            ++this.m_disconnectedReturnsThisInterval;
                            return null;
                        }
                        if (bs == null) {
                            if (this.DEBUG) {
                                lastTest = "Test: local/conn/fc";
                            }
                            if ((bs = this.selectConnected(msg, false, true, null, reallocationOptions, (byte)0, false)) != null) {
                                this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
                                ++this.m_flowControlled;
                                ++this.m_flowControlledThisInterval;
                            }
                        }
                    }
                }
                if (bs == null && !msg.isDiscardable() && (this.isPurelyDurable() || visitedBrokers == null)) {
                    if (this.DEBUG) {
                        lastTest = "Test: all/conn/fc";
                    }
                    if ((bs = this.selectConnected(msg, false, false, visitedBrokers, reallocationOptions, (byte)0, false)) != null) {
                        this.updateTraceStats(visitedBrokerList, reallocationOptions, bs);
                        ++this.m_flowControlled;
                    }
                }
            }
            if (this.DEBUG) {
                if (bs == null) {
                    this.debug(" selectBrokerSubscription for " + this.m_groupName + " --> return 'null' m_subs.size()=" + this.m_subs.size());
                } else {
                    this.debug(" selectBrokerSubscription for " + this.m_groupName + " --> m_curSub=" + this.m_curSub + " m_curDisDur=" + this.m_curDisDur + " m_subs.size()=" + this.m_subs.size() + " [" + lastTest + "]");
                }
            }
            return bs;
        }
    }

    private void updateTraceStats(LBSTrackingInfo visitedBrokerList, FastVector reallocationOptions, BrokerSubscription bs) {
        if (bs != null && reallocationOptions == null) {
            boolean local = this.isLocal(bs.getClient());
            if (visitedBrokerList == null || visitedBrokerList.getHopCount() == 0) {
                if (local) {
                    ++this.m_affinities;
                    ++this.m_affinitiesThisInterval;
                } else {
                    ++this.m_handoffsSent;
                    ++this.m_handoffsSentThisInterval;
                }
            } else if (visitedBrokerList.getHopCount() == 1 && local) {
                ++this.m_handoffsReceived;
                ++this.m_handoffsReceivedThisInterval;
            }
        }
    }

    private boolean isLocal(IClientContext cc) {
        return this.getIBCC(cc) == null;
    }

    private IClientContext getIBCC(IClientContext cc) {
        IClientContext ibcc = null;
        if (cc.isInterbroker()) {
            ibcc = cc;
        } else if (cc.getCWADSActiveBroker() != null && cc.getCWADSActiveBroker().isInterbroker()) {
            ibcc = cc.getCWADSActiveBroker();
        }
        return ibcc;
    }

    private void updateReceivers(LBSTrackingInfo visitedBrokerList) {
        if (visitedBrokerList == null || visitedBrokerList.getHopCount() == 0) {
            this.m_receiversLastMessageTime.put(this.m_reg.getId(), System.currentTimeMillis());
            this.m_nonReceivers.remove(this.m_reg.getId());
        } else {
            long[] hopids = visitedBrokerList.getTransitHistoryArray();
            if (hopids.length > 0 && hopids[0] != this.m_reg.getId()) {
                this.m_receiversLastMessageTime.put(hopids[0], System.currentTimeMillis());
                this.m_nonReceivers.remove(hopids[0]);
            }
        }
    }

    private BrokerSubscription loadBalanceToConnectedNeighbor(IMgram msg) {
        int subCount = this.m_subs.size();
        if (subCount == 0) {
            return null;
        }
        this.updateCirculatingState();
        if (!this.weightedGiveaway() && !this.m_circulating) {
            return null;
        }
        int start = this.m_curCirculatingSub >= subCount ? 0 : this.m_curCirculatingSub;
        this.m_curCirculatingSub = (start + 1) % subCount;
        while (true) {
            IClientContext ibcc;
            BrokerSubscription bs;
            IClientContext cc;
            if ((cc = (bs = this.m_subs.get(this.m_curCirculatingSub)).getClient()).isStarted() && (ibcc = this.getIBCC(cc)) != null && (this.m_circulating && !this.m_circulatees.contains(ibcc.getId()) || !this.m_circulating && this.m_nonReceivers.contains(ibcc.getId())) && (!bs.hasSelectors() || !bs.getSelectorAtBroker() || msg.getType() == 27 || bs.isMessageForSubscription(msg)) && ibcc.getOutQueue().getOffloadedPubSubQueue().isEmpty() && ibcc.getMinSendPriority(null) <= msg.getPriority() && ibcc.hasRoomForMgram(msg)) {
                if (this.m_circulating) {
                    this.m_circulatees.add(ibcc.getId());
                }
                return bs;
            }
            if (this.m_curCirculatingSub == start) {
                return null;
            }
            this.m_curCirculatingSub = (this.m_curCirculatingSub + 1) % subCount;
        }
    }

    private void updateCirculatingState() {
        long now = System.currentTimeMillis();
        if (this.m_circulating) {
            if (this.m_circulatees.size() >= this.m_nonReceivers.size() + this.m_receiversLastMessageTime.size() - 1 || now > this.m_circulatingStartTime + (long)(Config.GROUP_SUBSCRIPTIONS_CIRCULATION_TIME_LIMIT * 1000)) {
                this.m_circulating = false;
                this.m_circulatingEndTime = now;
            }
        } else if (this.m_circulatingEndTime == 0L) {
            this.m_circulatingEndTime = now;
        } else if (now > this.m_circulatingEndTime + (long)(Config.GROUP_SUBSCRIPTIONS_CIRCULATION_INTERVAL * 1000)) {
            this.m_circulating = true;
            this.m_circulatingStartTime = now;
            this.m_circulatees.clear();
        }
    }

    private boolean weightedGiveaway() {
        long g = this.m_nonReceivers.size();
        if (g == 0L) {
            return false;
        }
        int n = this.m_nonReceivers.size() + this.m_receiversLastMessageTime.size();
        int pick = this.m_random.nextInt(n) + 1;
        return (long)pick <= g;
    }

    public boolean okToSend(LBSTrackingInfo groups) {
        boolean ok = false;
        if (groups != null) {
            return groups.containsTarget(this.m_groupName);
        }
        return ok;
    }

    public boolean alreadyVisited(long ccid, long[] visited) {
        if (visited == null) {
            return false;
        }
        for (int i = 0; i < visited.length; ++i) {
            if (ccid != visited[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberOk(long ccid, FastVector rallocationOptions) {
        if (rallocationOptions == null) {
            return true;
        }
        for (int i = 0; i < rallocationOptions.m_count; ++i) {
            if (ccid != (Long)rallocationOptions.m_data[i]) continue;
            return true;
        }
        return false;
    }

    private BrokerSubscription selectConnected(IMgram msg, boolean checkOkToSend, boolean localOnly, long[] visitedBrokers, FastVector reallocationOptions, byte checkOffloading, boolean checkClientPendingAcksEmpty) {
        StringBuilder visitDebugStr;
        int subCount = this.m_subs.size();
        if (subCount == 0) {
            return null;
        }
        boolean checkVisited = false;
        if (!localOnly && visitedBrokers != null) {
            checkVisited = visitedBrokers.length > 0;
        }
        int start = this.m_curSub >= subCount ? 0 : this.m_curSub;
        this.m_curSub = (start + 1) % subCount;
        BrokerSubscription leastAcksPendingCandidate = null;
        int leastAcksPending = -1;
        int leastAcksPendingCandidatePosition = -1;
        StringBuilder stringBuilder = visitDebugStr = localOnly ? new StringBuilder("selectConnected: Shared Subscriber Selection Audit") : null;
        while (true) {
            IClientContext ibcc;
            BrokerSubscription bs;
            IClientContext cc;
            if (!(!(cc = (bs = this.m_subs.get(this.m_curSub)).getClient()).isStarted() || !this.isMemberOk(cc.getId(), reallocationOptions) || (ibcc = this.getIBCC(cc)) != null && localOnly || reallocationOptions == null && checkVisited && ibcc != null && this.alreadyVisited(ibcc.getId(), visitedBrokers) || bs.hasSelectors() && bs.getSelectorAtBroker() && msg.getType() != 27 && !bs.isMessageForSubscription(msg))) {
                IClientContext sendCc;
                if (!checkOkToSend) {
                    return bs;
                }
                IClientContext iClientContext = sendCc = ibcc != null ? ibcc : cc;
                if (checkOffloading == 1 && sendCc.getOutQueue().getOffloadedPubSubQueue().isEmpty()) {
                    if (sendCc.getMinSendPriority(null) <= msg.getPriority() && sendCc.hasRoomForMgram(msg)) {
                        if (!localOnly || !checkClientPendingAcksEmpty) {
                            return bs;
                        }
                        int acksPending = sendCc.getPendingGuarCount() + sendCc.getPendingQCount();
                        visitDebugStr.append("-").append(this.m_curSub).append("A").append(acksPending);
                        if (acksPending <= 0) {
                            visitDebugStr.append("-").append(this.m_curSub).append("!");
                            if (leastAcksPendingCandidate != null && this.DEBUG) {
                                this.debug(visitDebugStr.toString());
                            }
                            return bs;
                        }
                        if (acksPending > 0) {
                            this.sendBackloggedSessionSkipNotification(cc, bs);
                        }
                        if (leastAcksPendingCandidate == null || acksPending < leastAcksPending) {
                            leastAcksPending = acksPending;
                            leastAcksPendingCandidatePosition = this.m_curSub;
                            leastAcksPendingCandidate = bs;
                        }
                    } else if (localOnly) {
                        visitDebugStr.append("-").append(this.m_curSub).append("F");
                    }
                } else {
                    if (!(checkOffloading != 2 || !sendCc.useFlowToDisk() || sendCc.getOutQueue().getOffloadedPubSubQueue().isEmpty() && sendCc.hasRoomForMgram(msg))) {
                        return bs;
                    }
                    if (this.DEBUG) {
                        this.debug("Skipping flow controlled bs[" + this.m_curSub + "] sendCc.getMinSendPriority()=" + sendCc.getMinSendPriority(null));
                    }
                    this.sendBackloggedSessionSkipNotification(cc, bs);
                }
            }
            if (this.m_curSub == start) {
                if (leastAcksPendingCandidate != null) {
                    this.m_curSub = leastAcksPendingCandidatePosition;
                    visitDebugStr.append("-").append(this.m_curSub).append("!");
                    if (this.DEBUG) {
                        this.debug(visitDebugStr.toString());
                    }
                    return leastAcksPendingCandidate;
                }
                if (visitDebugStr != null && this.DEBUG) {
                    this.debug(visitDebugStr.toString());
                }
                return null;
            }
            this.m_curSub = (this.m_curSub + 1) % subCount;
        }
    }

    private void sendBackloggedSessionSkipNotification(IClientContext clientContext, BrokerSubscription bs) {
        long now = System.currentTimeMillis();
        BrokerSubscription userSubscription = clientContext.getSubscriptions().getUserSubscription();
        if (userSubscription == null) {
            userSubscription = bs;
        }
        Long[] trackRecord = this.m_backloggedSessionSkipTracker.get(userSubscription.getTopic());
        boolean sendNotification = false;
        if (trackRecord == null || trackRecord[1] + this.getBackloggedSessionSkipWarningInterval() <= now) {
            trackRecord = trackRecord == null ? new Long[2] : trackRecord;
            trackRecord[0] = 1L;
            trackRecord[1] = now;
            sendNotification = true;
        } else if (trackRecord[0] < (long)this.getBackloggedSessionSkipWarnBunchLimit() && trackRecord[1] + this.getBackloggedSessionSkipWarningInterval() > now) {
            trackRecord[0] = trackRecord[0] + 1L;
            sendNotification = true;
        }
        if (sendNotification) {
            BrokerManagementNotificationsHelper.sendBackloggedSessionSkipNotification(clientContext, bs);
            this.m_backloggedSessionSkipTracker.put(userSubscription.getTopic(), trackRecord);
        }
        this.cleanOldBackloggedSessionSkipTracks();
    }

    private void cleanOldBackloggedSessionSkipTracks() {
        long now = System.currentTimeMillis();
        Iterator<String> iter = this.m_backloggedSessionSkipTracker.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (this.m_backloggedSessionSkipTracker.get(key)[1] + this.getBackloggedSessionSkipWarningInterval() >= now) continue;
            iter.remove();
        }
    }

    private long getBackloggedSessionSkipWarningInterval() {
        if (s_backloggedSessionSkipWarnInterval != null) {
            return s_backloggedSessionSkipWarnInterval;
        }
        s_backloggedSessionSkipWarnInterval = Config.BACKLOGGED_SESSION_SKIP_WARN_INTERVAL >= 0L ? Long.valueOf(Config.BACKLOGGED_SESSION_SKIP_WARN_INTERVAL) : Long.valueOf(DEFAULT_BACKLOGGED_SESSION_SKIP_WARNING_INTERVAL);
        return s_backloggedSessionSkipWarnInterval;
    }

    private int getBackloggedSessionSkipWarnBunchLimit() {
        if (s_backloggedSessionSkipWarnBunchLimit != null) {
            return s_backloggedSessionSkipWarnBunchLimit;
        }
        s_backloggedSessionSkipWarnBunchLimit = Config.BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT > 0 ? Integer.valueOf(Config.BACKLOGGED_SESSION_SKIP_WARN_BUNCH_LIMIT) : Integer.valueOf(5);
        return s_backloggedSessionSkipWarnBunchLimit;
    }

    private BrokerSubscription selectDisconnected(IMgram msg, FastVector reallocationOptions) {
        int subCount = this.m_subs.size();
        if (subCount == 0) {
            return null;
        }
        int start = this.m_curDisDur >= subCount ? 0 : this.m_curDisDur;
        this.m_curDisDur = (start + 1) % subCount;
        BrokerSubscription bs;
        IClientContext cc;
        while (!(cc = (bs = this.m_subs.get(this.m_curDisDur)).getClient()).isDurable() || cc.isPendingReconnect() || cc.isStarted() && cc.getCWADSActiveBroker() != null || !this.isMemberOk(cc.getId(), reallocationOptions) || bs.hasSelectors() && bs.getSelectorAtBroker() && msg.getType() != 27 && !bs.isMessageForSubscription(msg)) {
            if (this.m_curDisDur == start) {
                return null;
            }
            this.m_curDisDur = (this.m_curDisDur + 1) % subCount;
        }
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPurelyDurable() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            int curcount = this.m_subs.size();
            return curcount == this.m_durableMemberCount;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPersistence(IMgram m) {
        if (this.isEmpty()) {
            return false;
        }
        GroupSubscriptionClientContext groupcc = this.m_groupcc;
        if (groupcc != null && groupcc.hasRecoveredInDoubtMembers()) {
            return true;
        }
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.m_durableMemberCount > 0 || m.isJMSPersistent() && this.m_ftMemberCount > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFTMembers() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            return this.m_ftMemberCount > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDurables() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            return this.m_durableMemberCount > 0;
            {
            }
        }
    }

    private boolean hasSelector() {
        return this.m_hasSelector != null && this.m_hasSelector != false;
    }

    private void verifySelector(BrokerSubscription bs) throws ParseException {
        boolean hasSelector = bs.hasSelector();
        if (bs.getClient().isInterbroker()) {
            return;
        }
        if (this.m_hasSelector == null) {
            this.m_hasSelector = hasSelector ? Boolean.TRUE : Boolean.FALSE;
            this.m_selector = bs.getSelectorString();
        } else if (this.m_hasSelector.booleanValue()) {
            if (!hasSelector) {
                ParseException e = new ParseException("Group " + this.getGroupName() + " is using message selector " + this.m_selector + " new member cannot join group without the same one.");
                throw e;
            }
            if (!this.m_selector.equals(bs.getSelectorString())) {
                ParseException e = new ParseException("Group " + this.getGroupName() + " is using message selector " + this.m_selector + " new member cannot join group with " + bs.getSelectorString());
                throw e;
            }
        } else if (!this.m_hasSelector.booleanValue() && hasSelector) {
            ParseException e = new ParseException("Group " + this.getGroupName() + " is not using  a message selector  new member cannot join group with selector " + bs.getSelectorString());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkGroupInterestInMgram(IMgram m) {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.isEmpty()) {
                return false;
            }
            if (!this.hasSelector()) {
                return true;
            }
            BrokerSubscription selbs = this.getOneSubscription();
            if (selbs == null) {
                return false;
            }
            return !selbs.hasSelectors() || !selbs.getSelectorAtBroker() || m.getType() == 27 || selbs.isMessageForSubscription(m);
            {
            }
        }
    }

    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
    }

    @Override
    public final boolean localEffect() {
        return true;
    }

    @Override
    public boolean isBatchable() {
        if (this.m_batchable == null) {
            this.calculateBatchable();
        }
        return this.m_batchable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateBatchable() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (InterbrokerHook.isSet()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            if (this.m_hasSelector == null || this.hasSelector()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            if (this.m_subs.isEmpty()) {
                this.m_batchable = Boolean.FALSE;
                return;
            }
            for (int i = 0; i < this.m_subs.size(); ++i) {
                if (this.m_subs.get(i).isBatchable()) continue;
                this.m_batchable = Boolean.FALSE;
                return;
            }
            this.m_batchable = Boolean.TRUE;
        }
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDupsOK() {
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            this.m_isDupsOK = null;
        }
    }

    public void setGroupCC(GroupSubscriptionClientContext cc) {
        this.m_groupcc = cc;
    }

    public GroupSubscriptionClientContext getGroupCC() {
        return this.m_groupcc;
    }

    public String getGroupAppid() {
        return "$GROUPSUBSCRIPTION$";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        String objName = ((GroupSubscription)obj).getGroupName();
        if (objName == null && this.m_groupName != null) {
            return false;
        }
        if (this.m_groupName == null && objName != null) {
            return false;
        }
        if (this.m_groupName == null && objName == null) {
            return true;
        }
        return this.m_groupName.equalsIgnoreCase(objName);
    }

    public int hashCode() {
        return Objects.hash(this.m_groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription getOneSubscription(HashSet memberList) {
        BrokerSubscription bs = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            for (BrokerSubscription nbs : this.m_subs) {
                if (memberList.contains(new Long(nbs.getClientId()))) {
                    bs = nbs;
                    break;
                }
                IClientContext cc = nbs.getClient().getCWADSActiveBroker();
                if (cc == null || !cc.isInterbroker() || !memberList.contains(new Long(cc.getId()))) continue;
                bs = nbs;
                break;
            }
        }
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerSubscription getOneSubscription() {
        BrokerSubscription returnedbs = null;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            if (this.m_subs.isEmpty()) {
                return null;
            }
            Iterator<BrokerSubscription> it = this.m_subs.iterator();
            BrokerSubscription neighborbs = null;
            while (it.hasNext()) {
                BrokerSubscription bs = it.next();
                if (bs.getClient().isInterbroker()) {
                    if (neighborbs != null) continue;
                    neighborbs = bs;
                    continue;
                }
                returnedbs = bs;
                break;
            }
            if (returnedbs == null && neighborbs != null) {
                returnedbs = neighborbs;
            }
        }
        return returnedbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BrokerSubscription> appendAllSubscriptions(Collection<BrokerSubscription> c) {
        int size = 0;
        Object object = this.getGroupSubscriptionSyncObj();
        synchronized (object) {
            size = this.m_subs.size();
            if (size > 0) {
                for (BrokerSubscription bs : this.m_subs) {
                    c.add(bs);
                }
            }
        }
        return c;
    }
}

