/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TxnAckPool;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class TxnPrepareEvt
extends LogEvent {
    private int m_tid;
    private String m_userXid;
    private long m_time;
    private TxnAckPool m_txnAckPool;
    private short m_eventType;
    private byte m_persistenceType;
    private long m_requestId;
    private short m_type = (short)84;

    TxnPrepareEvt(int tid, String userXid, long time, TxnAckPool txnAckPool, byte persistenceType, long requestId) {
        this.m_tid = tid;
        this.m_userXid = userXid;
        this.m_time = time;
        this.m_txnAckPool = txnAckPool;
        this.m_persistenceType = persistenceType;
        this.m_requestId = requestId;
    }

    TxnPrepareEvt(short type) {
        this.m_eventType = type;
    }

    int getTid() {
        return this.m_tid;
    }

    String getUserXid() {
        return this.m_userXid;
    }

    long getTime() {
        return this.m_time;
    }

    TxnAckPool getTxnAckPool() {
        return this.m_txnAckPool;
    }

    byte getPersistenceType() {
        return this.m_persistenceType;
    }

    @Override
    public short type() {
        return 84;
    }

    @Override
    protected int memSizeBody() {
        int size = 17 + (this.m_userXid.length() << 1) + 8;
        if (this.m_txnAckPool != null) {
            size = size + 4 + this.m_txnAckPool.getMemorySize();
        }
        return size;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        byte[] utfxid;
        block2: {
            utfxid = null;
            try {
                utfxid = StringUtil.stringToUTF(this.m_userXid);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        int size = 13 + utfxid.length + 8;
        size = this.m_txnAckPool == null ? (size += 4) : (size += this.m_txnAckPool.getSerializedSize());
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        byte[] utfxid = StringUtil.stringToUTF(this.m_userXid);
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeLong(this.m_time, os);
        os.write(utfxid, 0, utfxid.length);
        if (this.m_txnAckPool == null) {
            StreamUtil.writeInt(0, os);
        } else {
            this.m_txnAckPool.writebody(os);
        }
        StreamUtil.writeByte(this.m_persistenceType, os);
        StreamUtil.writeLong(this.m_requestId, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        this.m_time = StreamUtil.readLong(in);
        this.m_userXid = StreamUtil.readUTF(in);
        if (this.m_eventType == 14 || this.m_eventType == 35) {
            this.m_persistenceType = (byte)2;
            return;
        }
        this.m_txnAckPool = new TxnAckPool(this.m_tid);
        this.m_txnAckPool.readBody(in);
        this.m_persistenceType = StreamUtil.readByte(in);
        this.m_requestId = this.m_type == 84 || this.m_type == 96 ? StreamUtil.readLong(in) : 0L;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnPrepare(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + ", requestId " + this.m_requestId + ": prepare";
    }
}

