/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import progress.message.crypto.CryptoError;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;
import progress.message.zclient.IMessageDigest;

public abstract class MessageDigest
implements IMessageDigest,
Cloneable {
    private byte[] buf = new byte[this.getDataLength()];
    private int buf_off = 0;
    private long bitcount = 0L;

    protected MessageDigest() {
    }

    private int getDataLength() {
        return this.data_length();
    }

    public Object clone() {
        MessageDigest clone;
        try {
            clone = (MessageDigest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure("caught: " + e, e);
        }
        if (this.buf != null) {
            clone.buf = (byte[])this.buf.clone();
        }
        clone.buf_off = this.buf_off;
        clone.bitcount = this.bitcount;
        return clone;
    }

    public final long bitcount() {
        return this.bitcount;
    }

    public final byte[] buf() {
        return this.buf;
    }

    public final int buf_off() {
        return this.buf_off;
    }

    public int length() {
        return this.hash_length();
    }

    public abstract int hash_length();

    public abstract int data_length();

    public abstract String name();

    public final void reset() {
        this.bitcount = 0L;
        this.buf_off = 0;
        this.md_reset();
    }

    protected abstract void md_reset();

    protected abstract void md_transform();

    protected abstract void md_update(byte[] var1, int var2, int var3);

    protected abstract void md_digest(byte[] var1, int var2, int var3);

    public final byte[] digest() {
        int hash_length = this.hash_length();
        byte[] r = new byte[hash_length];
        this.md_digest(r, 0, hash_length);
        this.reset();
        return r;
    }

    public final void digest(byte[] input, int offset, int len) {
        this.md_digest(input, offset, len);
        this.reset();
    }

    public final void add(String message, int offset, int length) {
        if (message == null) {
            throw new CryptoError(prAccessor.getString("STR025"));
        }
        this.add(message.getBytes(), offset, length);
    }

    public final void add(String message) {
        if (message == null) {
            throw new CryptoError(prAccessor.getString("STR029"));
        }
        this.add(message, 0, message.length());
    }

    public final void add(byte[] data) {
        this.add(data, 0, data.length);
    }

    public final void add(byte[] data, int offset, int length) {
        if (data == null) {
            throw new CryptoError(prAccessor.getString("STR030"));
        }
        if (length < 0) {
            throw new CryptoError(prAccessor.getString("STR031"));
        }
        if (offset < 0) {
            throw new CryptoError(prAccessor.getString("STR032"));
        }
        if (length + offset > data.length) {
            throw new CryptoError(prAccessor.getString("STR033"));
        }
        if (length == 0) {
            return;
        }
        this.md_update(data, offset, length);
    }

    protected final void java_update(byte[] data, int off, int len) {
        int datalen = this.data_length();
        this.bitcount += (long)len << 3;
        while (len >= datalen - this.buf_off) {
            System.arraycopy(data, off, this.buf, this.buf_off, datalen - this.buf_off);
            this.md_transform();
            len -= datalen - this.buf_off;
            off += datalen - this.buf_off;
            this.buf_off = 0;
        }
        if (len > 0) {
            System.arraycopy(data, off, this.buf, this.buf_off, len);
            this.buf_off += len;
        }
    }

    public static final byte[] hash(String message, MessageDigest md) {
        md.add(message);
        return md.digest();
    }

    public static final byte[] hash(byte[] message, MessageDigest md) {
        md.add(message);
        return md.digest();
    }

    public String toString() {
        return "progress.message.crypto.MessageDigest\nbitcount: " + this.bitcount + "\nbuf: " + Hex.toString(this.buf) + "\nbuf_off: " + this.buf_off + "\n";
    }
}

