/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.Credentials;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENotConnected;
import progress.message.crypto.DES;
import progress.message.crypto.SHA;
import progress.message.gr.ConvertToRouter;
import progress.message.gr.ERouterAuthenticationFailure;
import progress.message.gr.GuarAckExchanger;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RouterConnection;
import progress.message.gr.RouterListener;
import progress.message.gr.RouterManager;
import progress.message.gr.prAccessor;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.security.cert.X509Certificate;
import progress.message.util.DebugState;
import progress.message.util.Hex;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.NegotiatedConnectParms;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SecurityConfig;
import progress.message.zclient.Session;

final class RouterConnect
extends Connection {
    private boolean m_waitingForConvertResponse = false;
    private boolean m_connectionFailed = false;
    private AgentRegistrar m_reg = null;
    private RemoteBroker m_remote = null;
    private RouterManager m_rtmgr = null;
    public static final int CONVERT_TIMEOUT = 60;
    private GuarAckExchanger m_gax = null;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };

    RouterConnect(AgentRegistrar reg, RouterManager routeMgr, RemoteBroker remote, String userid, String password) throws EInvalidApplicationId, EDefaultHandlerNotSet, EInvalidUserId, EGeneralException {
        super(RouterManager.getLocalRouterAppID(), new Credentials(userid, password), new TempMessageHandler());
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("RouterConnect");
        }
        this.m_reg = reg;
        this.m_rtmgr = routeMgr;
        Hashtable properties = new Hashtable();
        Config.getConnectionProperties(properties);
        this.setProperties(properties);
        this.m_remote = remote;
        this.setSocketConnectTimeout(Config.REMOTE_BROKER_CONNECT_TIMEOUT * 1000);
        this.setConnectTimeout(Config.REMOTE_BROKER_CONNECT_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteBroker convert(int timeout) throws ENotConnected, EGeneralException {
        if (this.DEBUG) {
            this.debug("Starting conversion...");
        }
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        RemoteBroker old_remote = this.m_remote;
        String reverseUrl = this.getReverseUrl();
        String ftPeerReverseUrl = this.getFtPeerReverseUrl();
        byte remoteSessionVer = this.getBrokerSessionVer();
        if (this.DEBUG) {
            this.debug(this.m_remote.toString() + " SESSION_VER = " + remoteSessionVer);
        }
        if (this.DEBUG) {
            this.debug("Building BEGIN request - NODE: " + Config.ROUTING_NODE_NAME + ", BROKER:" + Config.BROKER_NAME + ", LURL:" + reverseUrl + ", FTPeerULR: " + ftPeerReverseUrl);
        }
        Label local = new Label();
        local.setRouteLimit(1);
        Message msg = new Message("$SYS.GR.CONVERT");
        msg.write((byte)1);
        String subjectCommonName = null;
        try {
            msg.writeUTF(Config.ROUTING_NODE_NAME);
            msg.writeUTF(Config.BROKER_NAME);
            msg.writeUTF(reverseUrl);
            msg.writeUTF(this.m_remote.getNodeName());
            X509Certificate peerCertificate = this.getSocket().getPeerCertificate();
            if (peerCertificate != null) {
                subjectCommonName = peerCertificate.getSubjectCommonName().replace('.', '$');
            }
            msg.writeUTF(subjectCommonName == null ? "" : subjectCommonName);
            if (remoteSessionVer >= 27) {
                if (ftPeerReverseUrl != null) {
                    msg.writeBoolean(true);
                    msg.writeUTF(ftPeerReverseUrl);
                } else {
                    msg.writeBoolean(false);
                }
            }
        }
        catch (IOException peerCertificate) {
        }
        catch (SecurityException peerCertificate) {
            // empty catch block
        }
        if (this.DEBUG) {
            this.debug("Sending BEGIN request to $SYS.GR.CONVERT");
        }
        msg = this.getDefaultSession().request(new Envelope(msg, local), timeout);
        if (this.DEBUG) {
            this.debug("Received reply from $SYS.GR.CONVERT");
        }
        String remoteBroker = null;
        String remoteUser = null;
        String remoteNode = null;
        String remoteFtPeerUrl = null;
        long token = 0L;
        try {
            boolean failed;
            boolean bl = failed = !msg.readBoolean();
            if (!failed) {
                remoteNode = msg.readUTF();
                remoteBroker = msg.readUTF();
                remoteUser = msg.readUTF();
                token = msg.readLong();
                if (remoteSessionVer >= 27) {
                    if (msg.readBoolean()) {
                        remoteFtPeerUrl = msg.readUTF();
                    }
                    if (this.DEBUG) {
                        this.debug(this.m_remote.toString() + " has FT peer URL " + remoteFtPeerUrl);
                    }
                }
                if (Config.ENABLE_SECURITY) {
                    Object[] params;
                    String errmsg;
                    boolean authenticated = true;
                    if (subjectCommonName == null || !remoteUser.equals(subjectCommonName)) {
                        ProgressPasswordUser user = this.m_reg.getSecurityBean().getUser(remoteUser);
                        if (user == null) {
                            throw RouterConnect.checkRemoteUserAuthenticated(remoteNode, remoteUser);
                        }
                        msg = new Message("$SYS.GR.CONVERT");
                        msg.write((byte)3);
                        msg.writeLong(token);
                        try {
                            byte[] passiveNonce = new byte[16];
                            ProgressSecureRandom.theSecureRandom().nextBytes(passiveNonce);
                            if (this.DEBUG) {
                                this.debug("built passive nonce: " + Hex.toString(passiveNonce));
                            }
                            byte[] pwdKey = new byte[8];
                            System.arraycopy(user.getTestPattern(), 6, pwdKey, 0, 8);
                            byte[] payload = new byte[16];
                            DES des = new DES();
                            des.init(1, pwdKey);
                            des.doFinal(passiveNonce, 0, 16, payload, 0);
                            msg.writeInt(16);
                            if (this.DEBUG) {
                                this.debug("length of the encrypted challenge is " + payload.length);
                            }
                            msg.write(payload);
                            if (this.DEBUG) {
                                this.debug("Sending CHALLENGE request to $SYS.GR.CONVERT");
                            }
                            msg = this.getDefaultSession().request(new Envelope(msg, local), timeout);
                            if (this.DEBUG) {
                                this.debug("Received RESPONSE reply from $SYS.GR.CONVERT");
                            }
                            authenticated = this.verifyResponse(msg, passiveNonce, pwdKey);
                        }
                        catch (SecurityException e) {
                            authenticated = false;
                        }
                    }
                    if (!authenticated) {
                        errmsg = prAccessor.getString("RTAUTH_REMOTE_USER_NOT_AUTHENTICATED");
                        params = new Object[]{remoteUser, remoteNode, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        throw new ERouterAuthenticationFailure(prMessageFormat.format(errmsg, params));
                    }
                    authenticated = this.m_rtmgr.checkNodePermission(remoteUser, this.m_remote.getNodeName());
                    if (!authenticated) {
                        errmsg = prAccessor.getString("RTAUTH_NODE_PERMISSION_LOCAL");
                        params = new Object[]{remoteUser, remoteNode, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        throw new ERouterAuthenticationFailure(prMessageFormat.format(errmsg, params));
                    }
                }
            } else {
                switch (msg.readInt()) {
                    case -6: {
                        String errmsg = prAccessor.getString("RTAUTH_NODE_PERMISSION_REMOTE");
                        Object[] params = new Object[]{this.getEffectiveUid(), Config.ROUTING_NODE_NAME, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
                        throw new ERouterAuthenticationFailure(prMessageFormat.format(errmsg, params));
                    }
                }
                throw new ERouterAuthenticationFailure(prMessageFormat.format(prAccessor.getString("RTAUTH_UNKNOWN"), new Object[]{DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))}));
            }
            String remoteAppId = RouterManager.getRouterAppID(remoteNode, remoteBroker);
            long rcid = AddrUtil.stringToClientId(remoteUser, remoteAppId);
            this.m_rtmgr.addConnectingBroker(rcid);
            this.m_remote = this.m_rtmgr.register(rcid, this.getBrokerURL(), remoteFtPeerUrl, remoteNode, remoteBroker, this.getCredentials().getName(), this.getCredentials().getPassword());
            this.m_remote.setToken(token);
        }
        catch (ERouterAuthenticationFailure e) {
            throw e;
        }
        catch (EGeneralException e) {
            throw e;
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EGeneralException(0, e.toString());
        }
        try {
            this.clientAckExchange(token);
            if (this.DEBUG) {
                this.debug("Client GAX complete");
            }
            try {
                this.convertRemote(token);
            }
            catch (InterruptedException e) {
                this.cleanUp();
                throw new EInterrupted();
            }
            ClientSecurityContext csc = null;
            RouterConnection new_con = null;
            try {
                new_con = new RouterConnection(this.getSocket(), this.m_remote);
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                this.cleanUp();
                if (new_con != null) {
                    new_con.close();
                }
                throw new EGeneralException(0, e.getMessage());
            }
            if (this.DEBUG) {
                this.debug("Created RouterConnection");
            }
            RouterListener listener = (RouterListener)new_con.getAgentListener();
            listener.setClientSessionVer(this.getBrokerSessionVer());
            new_con.setNegotiatedConnectParms(NegotiatedConnectParms.buildNegotiatedConnectParms(this.m_brokerConnectParms));
            new_con.setPartnerProductVersion(this.getPartnerProductVersion());
            listener.setClientMgramVer(this.getClientSender().getMgramVersion());
            new_con.getAgentSender().setClientMgramVersion(this.getClientSender().getMgramVersion());
            RoutingConnectionInfo connectInfo = null;
            connectInfo = old_remote.isRegistered() ? this.m_reg.getRoutingConfig().getRoutingConnection(old_remote.getNodeName()) : old_remote.getConnectInfo();
            if (connectInfo != null) {
                new_con.setIdleTimeout(connectInfo.getTimeout());
            } else {
                new_con.setIdleTimeout(Config.CONNECT_IDLE_TIMEOUT);
            }
            try {
                this.getClientSender().kill(true, this.getChannel(), true, false);
            }
            catch (InterruptedException ie) {
                new_con.close();
                throw new EInterrupted();
            }
            if (this.DEBUG) {
                this.debug("Killed ClientSender");
            }
            csc = (ClientSecurityContext)this.getSecurityContext().clone();
            csc.setUidAppid(remoteUser, RouterManager.getRouterAppID(remoteNode, remoteBroker));
            if (this.DEBUG) {
                this.debug("Setting up CSC for outbound connection with user = " + remoteUser);
            }
            if (Config.ENABLE_SECURITY) {
                csc.setPrincipal(reg.getSecurityBean().getUser(remoteUser));
                if (csc.getPrincipal() == null) {
                    this.m_state = 1;
                    this.cleanUp();
                    new_con.close();
                    throw RouterConnect.checkRemoteUserAuthenticated(remoteNode, remoteUser);
                }
            }
            new_con.connectSuccess(this.getChannel(), csc, csc.getClientId());
            new_con.checkLimits(0, csc.getAppid(), csc);
            new_con.getAgentListener().setCommonSecurityContext(csc);
            if (Config.ENABLE_QOPSECURITY) {
                byte[] sessionKey = csc.getSessionKey();
                if (sessionKey != null) {
                    new_con.getAgentSender().initMessageProtection(sessionKey);
                } else {
                    this.m_state = 1;
                    this.cleanUp();
                    new_con.close();
                    throw new ERouterAuthenticationFailure(prMessageFormat.format(prAccessor.getString("RN_NOT_SECURE"), new Object[]{remoteNode, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))}));
                }
            }
            this.m_state = 1;
            this.cleanUp();
            long id = this.m_remote.getClientID();
            if (this.DEBUG) {
                this.debug("Creating " + new_con.getListener() + " in thread " + Thread.currentThread() + " for " + this.m_remote);
            }
            IClientContext cc = null;
            try {
                reg.connect(id, new_con, false);
            }
            catch (EGeneralException e) {
                RouterConnect.ensureConnectionClosed(reg, id, new_con, cc);
                throw e;
            }
            catch (InterruptedException e) {
                RouterConnect.ensureConnectionClosed(reg, id, new_con, cc);
                throw new EInterrupted();
            }
            reg.postConnect(id, this.getChannel());
            try {
                cc = reg.getClient(id);
                this.m_remote.setClientContext(cc);
                cc.startDelivery(null);
            }
            catch (EClientNotRegistered e) {
                new_con.close();
                throw new ENotConnected();
            }
            this.m_rtmgr.getRouteForwarder().onNewConnection(this.m_remote, false);
            boolean connectFailure = false;
            if (new_con.getListener().startIfNotStartedOrShutdown()) {
                if (this.DEBUG) {
                    this.debug("Started Listener");
                }
                try {
                    if (!new_con.getAgentListener().waitForMainLoop()) {
                        if (this.DEBUG) {
                            this.debug("Failed to reach main loop");
                        }
                        connectFailure = true;
                    }
                }
                catch (InterruptedException e) {
                    if (this.DEBUG) {
                        this.debug("Interrupted to reach main loop");
                    }
                    connectFailure = true;
                }
            } else {
                if (this.DEBUG) {
                    this.debug("Failed to start listener");
                }
                connectFailure = true;
            }
            if (connectFailure) {
                RouterConnect.ensureConnectionClosed(reg, id, new_con, cc);
                throw new ENotConnected();
            }
            if (this.DEBUG) {
                this.debug("Started " + new_con.getListener() + " for " + this.m_remote);
            }
            long lcid = AddrUtil.stringToClientId(this.getEffectiveUid(), RouterManager.getLocalRouterAppID());
            IMgram convertMgram = MgramFactory.getMgramFactory().buildGRConvertMgram(1L, lcid, cc.getChannel(), token);
            cc.sendThrough(convertMgram);
            if (this.DEBUG) {
                this.debug("Sent final GR_CONVERT mgram");
            }
            reg.getGSManager().onNewConnection(this.m_remote, false);
            if (this.DEBUG) {
                this.debug("Connected " + this.m_remote);
            }
        }
        finally {
            this.m_rtmgr.removeConnectingBroker(this.m_remote.getClientID());
        }
        return this.m_remote;
    }

    private static ERouterAuthenticationFailure checkRemoteUserAuthenticated(String remoteNode, String remoteUser) {
        Object[] obj = new Object[]{remoteUser, remoteNode, Config.ROUTING_NODE_NAME, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
        String msgTemplate = remoteUser.equals("AUTHENTICATED") ? prAccessor.getString("RNROUTE_NOT_DEFINED") : prAccessor.getString("LNUSER_NOT_FOUND");
        return new ERouterAuthenticationFailure(prMessageFormat.format(msgTemplate, obj));
    }

    private static final void ensureConnectionClosed(AgentRegistrar reg, long id, AgentConnection new_con, IClientContext ccParam) {
        IClientContext cc = ccParam;
        new_con.close();
        if (cc == null) {
            try {
                cc = reg.getClient(id);
            }
            catch (EClientNotRegistered e) {
                return;
            }
        }
        if (cc.isConnected()) {
            reg.disconnect(id, false, true, new_con);
        }
    }

    public String getReverseUrl() {
        String reverseUrl = null;
        RoutingConnectionInfo routeInfo = this.m_reg.getRoutingConfig().getRoutingConnection(this.m_remote.getNodeName());
        if (routeInfo != null) {
            String acceptorConfigID;
            if (this.DEBUG) {
                this.debug("getReverseUrl: checking RoutingConnectionInfo for: " + routeInfo.toString());
            }
            if ((acceptorConfigID = routeInfo.getRoutingAcceptor()) != null && acceptorConfigID.trim().length() > 0) {
                if (this.DEBUG) {
                    this.debug("getReverseUrl: checking RoutingConnectionInfo for Routing Acceptor property: " + acceptorConfigID);
                }
                Acceptor acceptor = null;
                Enumeration enu = AcceptorHolder.getAcceptorHolder().getAcceptors();
                block0: while (acceptor == null && enu.hasMoreElements()) {
                    Hashtable next = (Hashtable)enu.nextElement();
                    Enumeration acceptors = next.elements();
                    while (acceptors.hasMoreElements()) {
                        String acceptorname;
                        Acceptor nextacceptor = (Acceptor)acceptors.nextElement();
                        if (this.DEBUG) {
                            this.debug("getReverseUrl: checking acceptor " + nextacceptor.getAcceptorName() + " external url = " + nextacceptor.getExternalURL() + " internal url = " + nextacceptor.getURL());
                        }
                        if (!(acceptorname = nextacceptor.getAcceptorName()).equals(acceptorConfigID)) continue;
                        acceptor = nextacceptor;
                        continue block0;
                    }
                }
                if (acceptor != null) {
                    String externalUrl = acceptor.getExternalURL();
                    if (externalUrl != null && externalUrl.trim().length() > 0) {
                        reverseUrl = externalUrl;
                        if (this.DEBUG) {
                            this.debug("getReverseUrl: Using acceptor " + acceptorConfigID + "'s  external URL " + reverseUrl);
                        }
                    } else {
                        String internalUrl = acceptor.getURL();
                        if (internalUrl != null && internalUrl.trim().length() > 0) {
                            reverseUrl = internalUrl;
                            if (this.DEBUG) {
                                this.debug("getReverseUrl: Using acceptor " + acceptorConfigID + "'s  default URL " + reverseUrl);
                            }
                        }
                    }
                }
            }
        }
        if (reverseUrl == null) {
            reverseUrl = AcceptorHolder.getAcceptorHolder().getPrimaryAcceptor().getExternalURL();
            if (this.DEBUG) {
                this.debug("getReverseUrl: primary acceptor external URL " + reverseUrl);
            }
        }
        if (reverseUrl == null) {
            Broker broker = Broker.getBroker();
            reverseUrl = broker.getDefaultRoutingURL();
            if (this.DEBUG) {
                this.debug("getReverseUrl: default routing URL " + reverseUrl);
            }
        }
        if (reverseUrl == null) {
            reverseUrl = AcceptorHolder.getAcceptorHolder().getPrimaryAcceptor().getURL();
            if (this.DEBUG) {
                this.debug("getReverseUrl: primary acceptor URL " + reverseUrl);
            }
        }
        return reverseUrl;
    }

    public String getFtPeerReverseUrl() {
        return ConvertToRouter.getInstance().getFtPeerReverseUrl(this.m_remote.getNodeName());
    }

    private boolean verifyResponse(Message msg, byte[] passiveNonce, byte[] pwdKey) {
        try {
            if (!msg.readBoolean()) {
                return false;
            }
            int len = msg.readInt();
            byte[] cipherText = new byte[len];
            msg.read(cipherText);
            if (this.DEBUG) {
                this.debug("length of the encrypted response is " + len);
            }
            byte[] clearText = new byte[len];
            DES des = new DES();
            des.init(2, pwdKey);
            des.doFinal(cipherText, 0, len, clearText, 0);
            byte[] response = new byte[20];
            System.arraycopy(clearText, 0, response, 0, response.length);
            if (this.DEBUG) {
                this.debug("decrypted SHA hash is \"" + Hex.toString(response) + "\"");
            }
            SHA sha = new SHA();
            sha.add(passiveNonce);
            sha.add(SecurityConfig.KNOWN_SECRET);
            byte[] hash = sha.digest();
            if (this.DEBUG) {
                this.debug("computed SHA hash is \"" + Hex.toString(hash) + "\"");
            }
            return this.arrayCompare(response, 0, hash, 0, hash.length);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean arrayCompare(byte[] a1, int off1, byte[] a2, int off2, int length) {
        try {
            for (int i = 0; i < length; ++i) {
                if (a1[i + off1] == a2[i + off2]) continue;
                if (this.DEBUG) {
                    this.debug("differ on " + i + "th element");
                }
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientAckExchange(long token) throws EGeneralException {
        if (Config.DISABLE_ACKEXCHANGE) {
            if (this.DEBUG) {
                this.debug("AckExchange disabled ");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("in clientAckExchange() for " + this.m_remote);
        }
        String userIdToRemote = this.getEffectiveUid();
        String thisBroker = RouterManager.getLocalRouterAppID();
        long localid = AddrUtil.stringToClientId(userIdToRemote, thisBroker);
        if (this.DEBUG) {
            this.debug("Constructing AckExchanger: this Broker= " + thisBroker);
            this.debug("Constructing AckExchanger: thisB's Usrid= " + userIdToRemote);
            this.debug("Constructing AckExchanger: thisB's remote Clientid= " + localid);
            this.debug("Constructing AckExchanger: RemoteBroker's ClientId= " + this.m_remote.getClientID());
            this.debug("Token " + token);
        }
        GuarAckExchanger gax = null;
        try {
            gax = new GuarAckExchanger(this.getDefaultSession(), localid, this.m_remote.getClientID(), token, true, this.m_remote);
        }
        catch (EGeneralException e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw e;
        }
        RouterConnect e = this;
        synchronized (e) {
            if (!this.m_connectionFailed) {
                this.m_gax = gax;
            }
        }
        if (this.m_gax == null) {
            gax.cleanUp();
            throw new ENotConnected();
        }
        try {
            this.m_gax.doExchange();
        }
        catch (EGeneralException e2) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e2, 2);
            }
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertRemote(long token) throws ENotConnected, InterruptedException {
        IMgram convertMgram = MgramFactory.getMgramFactory().buildGRConvertMgram(0L, -1L, this.getChannel(), token);
        if (this.DEBUG) {
            this.debug("created GR_CONVERT_TYPE mgram, length=" + convertMgram.networkLength());
        }
        RouterConnect routerConnect = this;
        synchronized (routerConnect) {
            if (this.m_connectionFailed) {
                throw new ENotConnected();
            }
            this.m_connectionFailed = false;
            this.m_waitingForConvertResponse = true;
        }
        this.getClientSender().send(convertMgram);
        if (this.DEBUG) {
            this.debug("sent GR_CONVERT_TYPE mgram");
        }
        routerConnect = this;
        synchronized (routerConnect) {
            this.notifyAll();
            if (this.DEBUG) {
                this.debug("Waiting for GR_CONVERT response...");
            }
            while (this.m_waitingForConvertResponse) {
                if (!Thread.interrupted()) {
                    this.wait();
                    continue;
                }
                throw new InterruptedException();
            }
            if (this.m_connectionFailed) {
                if (this.DEBUG) {
                    this.debug("Connection failed while waiting for GR_CONVERT response.");
                }
                throw new ENotConnected();
            }
            if (this.DEBUG) {
                this.debug("Received GR_CONVERT response.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pauseIfMark() {
        RouterConnect routerConnect = this;
        synchronized (routerConnect) {
            if (!this.m_waitingForConvertResponse) {
                return;
            }
            this.m_waitingForConvertResponse = false;
            this.notifyAll();
        }
        Thread.currentThread().stop();
    }

    @Override
    protected synchronized void connDroppedIBHook() {
        this.m_connectionFailed = true;
        this.m_waitingForConvertResponse = false;
        if (this.m_gax != null) {
            this.m_gax.notifyConnDropped();
        }
        this.notifyAll();
    }

    private static class TempMessageHandler
    extends MessageHandler
    implements IMessageHandler {
        TempMessageHandler() {
            super(null);
            this.setName("RouterConnect msg handler");
            try {
                this.replaceHandler(this);
            }
            catch (EGeneralException eGeneralException) {
                // empty catch block
            }
        }

        @Override
        public void handleMessage(Session s, Envelope envelope) {
        }
    }
}

