/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.IErrorHandle;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;

final class ErrorPayload
extends Payload
implements IErrorHandle {
    private static final int ERROR_PAYLOAD_LEN = 8;
    private int m_errCode;
    private int m_errInfo;

    public ErrorPayload(Mgram m) {
        super(m);
    }

    @Override
    void initPayloadFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_errCode = StreamUtil.readInt(is);
        this.m_errInfo = StreamUtil.readInt(is);
    }

    @Override
    byte[] toByteArray() {
        byte[] result = new byte[8];
        ArrayUtil.writeInt(result, 0, this.m_errCode);
        ArrayUtil.writeInt(result, 4, this.m_errInfo);
        return result;
    }

    @Override
    void sync() {
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.m_errCode, os);
        StreamUtil.writeInt(this.m_errInfo, os);
    }

    @Override
    public int length() {
        return 8;
    }

    @Override
    public void setErrInfo(int errInfo) {
        this.m_errInfo = errInfo;
    }

    @Override
    public int getErrInfo() {
        return this.m_errInfo;
    }

    @Override
    public void setErrCode(int errCode) {
        this.m_errCode = errCode;
    }

    @Override
    public int getErrCode() {
        return this.m_errCode;
    }

    @Override
    public IErrorHandle getErrorHandle() {
        return this;
    }
}

