/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import com.sonicsw.security.ssl.SSLUtil;
import java.io.IOException;
import java.net.SocketException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import progress.message.crypto.DESString;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.ISSLServerSocket;
import progress.message.net.ssl.ISSLSocket;
import progress.message.net.ssl.ProgressSslSocket;
import progress.message.net.ssl.ProgressSslSocketFactory;
import progress.message.net.ssl.prAccessor;

final class ProgressSslServerSocket
extends ProgressServerSocket {
    private static final boolean DEBUG = false;
    private Hashtable m_props = null;
    private ISSLServerSocket m_serverSocket = null;
    private static StringEncrypter desDecrypter = new StringEncrypter();

    ProgressSslServerSocket(Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        this.m_props = properties;
        this.createSSLServerSocket(port, backlog, bindAddr);
    }

    @Override
    public ProgressSocket accept() throws IOException {
        try {
            ISSLSocket s = this.m_serverSocket.accept();
            Boolean nodelay = null;
            if (this.m_props != null) {
                nodelay = (Boolean)this.m_props.get("TCP_NODELAY");
            }
            try {
                if (nodelay != null) {
                    s.getImpl().setTcpNoDelay(nodelay);
                } else {
                    s.getImpl().setTcpNoDelay(true);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            return s == null ? null : new ProgressSslSocket(s, this.m_props);
        }
        catch (IOException e) {
            IOException ioe = e instanceof ESocketConfigException ? new ESocketConfigException(prAccessor.getString("STR010") + e.getMessage()) : new IOException(prAccessor.getString("STR010") + e.getMessage());
            ioe.fillInStackTrace();
            throw ioe;
        }
    }

    private void createSSLServerSocket(int port, int backlog, ProgressInetAddress bindAddr) throws IOException {
        String esslPassword;
        ISSLControl control = ProgressSslSocketFactory.getSSLImpl().createSSLServerControl();
        String pwd = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_PASSWORD", null);
        if (pwd == null && (esslPassword = SSLUtil.getProperty(this.m_props, "ESSL_PRIVATE_KEY_PASSWORD", null)) != null) {
            pwd = desDecrypter.decrypt(esslPassword);
        }
        if (!control.configureKeyAndCertificate(SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN", null), SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN_FORM", "LIST"), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY", null), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_FORM", "PKCS8"), pwd)) {
            throw new ESocketConfigException(prAccessor.getString("STR007"));
        }
        String cipherSuites = SSLUtil.getProperty(this.m_props, "SSL_CIPHER_SUITES", null);
        Vector cs = SSLUtil.getCipherSuites(cipherSuites, false);
        if (!control.configureCipherSuites(cs)) {
            throw new ESocketConfigException(prAccessor.getString("STR008") + cipherSuites);
        }
        if (SSLUtil.getProperty(this.m_props, "SSL_CLIENT_AUTHENTICATION", "false").equalsIgnoreCase("true")) {
            String caCertsDir = SSLUtil.getProperty(this.m_props, "SSL_CA_CERTIFICATES_DIR", null);
            try {
                if (caCertsDir != null && !control.configureTrustDecider(caCertsDir, null)) {
                    throw new ESocketConfigException(prAccessor.getString("STR006"));
                }
            }
            catch (Exception ex) {
                throw new ESocketConfigException(ex.getMessage());
            }
        }
        ISSLImpl sslImpl = ProgressSslSocketFactory.getSSLImpl();
        this.m_serverSocket = sslImpl.createSSLServerSocket(bindAddr, port, backlog, control, (Object)this.m_props);
        this.m_impl = this.m_serverSocket.getImpl();
    }

    private static final class StringEncrypter
    extends DESString {
        private static final byte[] s_data = new byte[]{21, 89, -63, 38, 64, -94, -40, 3, 5, 35, 69, 103, -119, -85, -51, -17};

        private StringEncrypter() {
        }

        @Override
        protected byte[] getSalt() {
            return s_data;
        }

        final String decrypt(String encoded_string) throws IOException {
            return this.DESDecrypt(encoded_string);
        }
    }
}

