/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.security.cert.BrokerCertificateStore;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateStoreChangeHandler
implements IAttributeChangeHandler {
    private IComponentContext m_context = null;
    private BrokerCertificateStore m_store = null;
    private CertificateFactory certFactory = null;

    public CertificateStoreChangeHandler(IComponentContext context, BrokerCertificateStore store) {
        this.m_context = context;
        this.m_store = store;
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new MFRuntimeException(ex.getMessage());
        }
    }

    public void itemDeleted() {
        this.m_store.reset();
        this.m_store = null;
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (i = 0; i < newAttributes.length; ++i) {
            try {
                this.newCertificate(newAttributes[i], delta.getNewValue(newAttributes[i]));
                continue;
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            this.deletedCertificate(deletedAttributes[i]);
        }
    }

    private void newCertificate(String key, Object certURL) {
        try {
            X509Certificate cert = (X509Certificate)this.certFactory.generateCertificate(new URL((String)certURL).openConnection().getInputStream());
            this.m_store.addToken(key, cert);
        }
        catch (Exception ex) {
            this.m_context.logMessage("Unable to load certificate from " + certURL + " : " + ex.getMessage(), 2);
            return;
        }
    }

    private void deletedCertificate(String attribute) {
        try {
            this.m_store.deleteToken(attribute);
        }
        catch (Exception ex) {
            this.m_context.logMessage("Unable to remove certificate " + attribute + " from the broker certificate store: " + ex.getMessage(), 2);
            return;
        }
    }
}

