/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.Config;

public class SecurityParametersChangeHandler
implements IAttributeChangeHandler {
    public void itemDeleted() {
        Config.ENABLE_ACL_CHECK_AT_RESTORE = false;
        Config.SET_JMSXUSERID = false;
    }

    public void itemModified(Object newValue) {
        if (newValue instanceof IDeltaAttributeSet) {
            String[] newAttrNames;
            String[] modifiedAttrNames;
            IDeltaAttributeSet das = (IDeltaAttributeSet)newValue;
            String[] deletedAttrNames = das.getDeletedAttributesNames();
            if (deletedAttrNames != null && deletedAttrNames.length > 0) {
                for (int i = 0; i < deletedAttrNames.length; ++i) {
                    if (deletedAttrNames[i] == null) continue;
                    if (deletedAttrNames[i].equalsIgnoreCase("ENABLE_ACL_CHECK_AT_RESTORE")) {
                        Config.ENABLE_ACL_CHECK_AT_RESTORE = false;
                        continue;
                    }
                    if (!deletedAttrNames[i].equalsIgnoreCase("SET_JMSXUSERID")) continue;
                    Config.SET_JMSXUSERID = false;
                }
            }
            if ((modifiedAttrNames = das.getModifiedAttributesNames()) != null && modifiedAttrNames.length > 0) {
                for (int i = 0; i < modifiedAttrNames.length; ++i) {
                    if (modifiedAttrNames[i] == null) continue;
                    if (modifiedAttrNames[i].equalsIgnoreCase("ENABLE_ACL_CHECK_AT_RESTORE")) {
                        try {
                            SecurityParametersChangeHandler.configAclCheckAtRestore(das);
                        }
                        catch (NotModifiedAttException e) {
                            BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
                        }
                        continue;
                    }
                    if (!modifiedAttrNames[i].equalsIgnoreCase("SET_JMSXUSERID")) continue;
                    try {
                        SecurityParametersChangeHandler.configJmsxUserId(das);
                        continue;
                    }
                    catch (NotModifiedAttException e) {
                        BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
                    }
                }
            }
            if ((newAttrNames = das.getNewAttributesNames()) != null && newAttrNames.length > 0) {
                for (int i = 0; i < newAttrNames.length; ++i) {
                    if (newAttrNames[i] == null) continue;
                    if (newAttrNames[i].equalsIgnoreCase("ENABLE_ACL_CHECK_AT_RESTORE")) {
                        try {
                            SecurityParametersChangeHandler.configAclCheckAtRestore(das);
                        }
                        catch (NotModifiedAttException e) {
                            BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
                        }
                        continue;
                    }
                    if (!newAttrNames[i].equalsIgnoreCase("SET_JMSXUSERID")) continue;
                    try {
                        SecurityParametersChangeHandler.configJmsxUserId(das);
                        continue;
                    }
                    catch (NotModifiedAttException e) {
                        BrokerComponent.getComponentContext().logMessage(e.getMessage(), (Throwable)e, 2);
                    }
                }
            }
        }
    }

    private static void configJmsxUserId(IDeltaAttributeSet das) throws NotModifiedAttException {
        Boolean B = (Boolean)das.getNewValue("SET_JMSXUSERID");
        Config.SET_JMSXUSERID = B != null ? B != false && Config.ENABLE_SECURITY : false;
    }

    private static void configAclCheckAtRestore(IDeltaAttributeSet das) throws NotModifiedAttException {
        Boolean B = (Boolean)das.getNewValue("ENABLE_ACL_CHECK_AT_RESTORE");
        Config.ENABLE_ACL_CHECK_AT_RESTORE = B != null ? B : false;
    }
}

