/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.prAccessor;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.util.Hashtable;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.Message;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;

public abstract class HttpBaseHandler
extends DebugObject {
    private static final int MAX_LOCALID = 65535;
    protected static volatile IMessageProtection s_mp = null;
    private static final Object MP_LOCK_OBJ = new Object();
    private static Object s_mutex_appId = new Object();
    private static Object s_mutex_trackingId = new Object();
    private static Object s_mutex_messageId = new Object();
    private static long s_brokerID = -1L;
    private static long s_connectionID = -1L;
    private static long s_lastLocalID = -1L;
    private static long s_appIDCounter = 1L;
    private static long s_tracking = 1L;
    protected HttpConfigInfo m_config = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpBaseHandler(HttpConfigInfo config) {
        super(DebugState.GLOBAL_DEBUG_ON ? "HttpConfigInfo " + config.toString() : null);
        this.m_config = config;
        if (s_lastLocalID == -1L) {
            this.getNewConnectionID();
        }
        if (s_mp == null) {
            Object object = MP_LOCK_OBJ;
            synchronized (object) {
                if (s_mp == null) {
                    try {
                        s_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected long getBrokerID() {
        return s_brokerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextMessageID() {
        Object object = s_mutex_messageId;
        synchronized (object) {
            if (++s_lastLocalID > 65535L) {
                this.getNewConnectionID();
            }
            return s_lastLocalID & 0xFFFFFFFFFFFFFFFFL | (s_connectionID & 0xFFFFFFFFL) << 16;
        }
    }

    protected final void getNewConnectionID() {
        AgentAdminConnection conn = AgentRegistrar.getAgentRegistrar().getAdminConnection();
        String adminPrefix = SessionConfig.getAdminPrefix(conn.getEffectiveUid(), conn.getApplicationId());
        adminPrefix = adminPrefix + ".getConnectionID";
        try {
            Message req = new Message(adminPrefix);
            Envelope envelope = conn.getDefaultSession().requestEnvelope(req);
            Message reply = envelope.getMessage();
            s_brokerID = reply.readLong();
            s_connectionID = reply.readLong();
            s_lastLocalID = 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextTrackingId() {
        Object object = s_mutex_trackingId;
        synchronized (object) {
            return s_tracking++;
        }
    }

    protected static String getAppIdPrefix() {
        return "$http$";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNextAppId() {
        Object object = s_mutex_appId;
        synchronized (object) {
            return HttpBaseHandler.getAppIdPrefix() + String.valueOf(s_appIDCounter++);
        }
    }

    protected void sync(ClientSecurityContext csc, Envelope envelope, IMessageProtection mp) {
        IMgram mgram = envelope.getMgram();
        if (csc.isQopSecurityEnabled()) {
            mgram.setMgramSecure(mp);
            mgram.setSecurityAttribute((byte)0);
        }
        envelope.syncEnvelopeData();
        mgram.sync();
        if (csc.isQopSecurityEnabled()) {
            BrokerSearchResults bsr = new BrokerSearchResults();
            AgentRegistrar.getAgentRegistrar().m_regSub.get(mgram.getSubject(), bsr);
            byte location = 2;
            if (mgram.getSubject().isQueue() || mgram.forRemoteNode(Config.ROUTING_NODE_NAME)) {
                location = 4;
            }
            byte publicAttr = (byte)bsr.m_qop.getProtection();
            try {
                byte privateAttr = SecurityLogic.AttribsFromPublic(location, publicAttr);
                mgram.setSecurityAttribute(privateAttr);
            }
            catch (ESecurityInvalidLogistics e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    public void ack(IMgram mgram) {
        IMgram ack = MgramFactory.getMgramFactory().buildAck(0L, (short)0, 0);
        ack.getBrokerHandle().setAckNoReply(true);
        AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(mgram.getGuarenteedTrackingNum());
        if (tracker != null) {
            tracker.acknowledged(ack, true);
        } else {
            boolean deleted = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().deleteMsg(mgram.getGuarenteedTrackingNum(), mgram.isJMSPersistent());
            if (mgram.isJMSPersistent()) {
                QueueMsgAckedEvt evt = new QueueMsgAckedEvt(mgram.getGuarenteedTrackingNum(), ack, deleted);
                AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
            }
        }
    }

    public void dmq(IMgram m, int dmqReasonCode, String explanationText) throws InterruptedException {
        Hashtable<String, String> errorInfo = null;
        if (explanationText != null) {
            errorInfo = new Hashtable<String, String>();
            errorInfo.put("JMS_SonicMQ_undeliveredExplanationText", explanationText);
        }
        AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, dmqReasonCode, true, errorInfo);
    }

    public void dmqNoException(IMgram m, int dmqReasonCode, String explanationText) {
        try {
            this.dmq(m, dmqReasonCode, explanationText);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getPrBundleMsg(String key) {
        return prAccessor.getString(key);
    }

    public void restore(IMgram m, String dest) {
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        IAgentQueue q = aqp.getAgentQueue(dest);
        if (q == null) {
            return;
        }
        IndexedList<IMgram> l = new IndexedList<IMgram>();
        l.appendNoDup(m.getGuarenteedTrackingNum(), m);
        q.restore(l, true, true);
    }

    public HttpConfigInfo getConfigInfo() {
        return this.m_config;
    }
}

