/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.ConfigurationException;
import com.sonicsw.net.http.HttpConfigInfo;
import com.sonicsw.net.http.HttpConfigManager;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.net.http.HttpRemoteBroker;
import com.sonicsw.net.http.HttpServiceException;
import java.util.Properties;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouterManager;
import progress.message.gr.RoutingTargetFactory;

public abstract class HttpRemoteBrokerFactory
extends RoutingTargetFactory {
    private int m_routeType;
    private String m_protocol = null;
    private HttpConfigManager m_configMgr = null;
    private Object _configsync = new Object();
    private Properties m_properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRemoteBrokerFactory(RouterManager rmg, AgentRegistrar reg, RoutingTargetFactory next, int routeType, String protocol, Properties properties) {
        super(rmg, reg, (Properties)null, next);
        this.m_routeType = routeType;
        this.m_protocol = protocol;
        this.m_properties = properties;
        Object object = this._configsync;
        synchronized (object) {
            if (Config.DS_DEBUG) {
                System.out.println("HttpRemoteBrokerFactory.ctor: m_configMgr = " + this.m_configMgr);
            }
            this.retrieveConfigMgr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRemoteBroker create(RoutingConnectionInfo connectInfo, String pendingQueueName) {
        if (connectInfo.getRouteType() == this.m_routeType) {
            if (this.m_configMgr == null) {
                Object object = this._configsync;
                synchronized (object) {
                    this.retrieveConfigMgr();
                }
            }
            HttpConfigInfo config = this.m_configMgr.getByName(connectInfo.getRoutingNodeName());
            try {
                HttpOutboundHandler handler = this.createHandler(connectInfo, config);
                return new HttpRemoteBroker(this.m_routerManager, connectInfo, pendingQueueName, handler);
            }
            catch (ConfigurationException configurationException) {
            }
            catch (HttpServiceException httpServiceException) {
                // empty catch block
            }
        }
        return null;
    }

    private void retrieveConfigMgr() {
        if (this.m_configMgr == null) {
            this.m_configMgr = new HttpConfigManager(this.m_properties, "OUTBOUND", this.m_protocol);
        }
    }

    public abstract HttpOutboundHandler createHandler(RoutingConnectionInfo var1, HttpConfigInfo var2) throws ConfigurationException, HttpServiceException;

    public HttpConfigManager getConfigManager() {
        return this.m_configMgr;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public int getRouteType() {
        return this.m_routeType;
    }
}

