/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.direct;

import com.sonicsw.net.http.HttpConfigInfo;
import java.util.Hashtable;

public class DirectHttpInConfig
implements Cloneable {
    public String deliveryMode = "NON_PERSISTENT";
    public String destinationQueue = null;
    public String destinationTopic = null;
    public String destinationURL = null;
    public String receiveQueue = null;
    public String receiveURL = null;
    public String replyToQueue = null;
    public String replyToTopic = null;
    public int priority = 0;
    public String type = null;
    public Boolean notifyUndelivered = null;
    public Boolean preserveUndelivered = null;
    public long timeToLive = 0L;
    public String user = null;
    public Boolean oneway = null;
    public int contentReplyTimeout = 0;
    public Hashtable contentMaps = null;
    public boolean basicAuthentication = false;
    public boolean certificateAuthentication = false;
    public boolean userPreconfigured = false;
    public String urlEntryName = null;
    public String soapRoles = null;
    public String wsdlLocation = null;
    public String undeliveredDestinationType = null;
    public String undeliveredDestinationName = null;

    public DirectHttpInConfig(HttpConfigInfo config) {
        this.user = config.getStringElement("User");
        this.deliveryMode = config.getStringElement("DeliveryMode", "NON_PERSISTENT");
        this.destinationQueue = config.getStringElement("DestinationQueue");
        this.destinationTopic = config.getStringElement("DestinationTopic");
        this.destinationURL = config.getStringElement("DestinationURL");
        this.receiveQueue = config.getStringElement("ReceiveQueue");
        this.receiveURL = config.getStringElement("ReceiveURL");
        this.priority = config.getIntElement("Priority", 0);
        this.replyToQueue = config.getStringElement("ReplyToQueue");
        this.replyToTopic = config.getStringElement("ReplyToTopic");
        this.type = config.getStringElement("Type");
        this.timeToLive = config.getLongElement("TimeToLive", 0L);
        this.notifyUndelivered = config.getBooleanElement("NotifyUndelivered");
        this.preserveUndelivered = config.getBooleanElement("PreserveUndelivered");
        String requestMode = config.getStringElement("RequestMode");
        this.basicAuthentication = config.getBooleanElement("HTTP_BASIC", false);
        this.certificateAuthentication = config.getBooleanElement("SSL_CERTIFICATE", false);
        this.userPreconfigured = config.getBooleanElement("CONFIG_USER", true);
        this.urlEntryName = config.getName();
        if (this.isPreserveUndelivered()) {
            this.undeliveredDestinationType = config.getStringElement("UNDELIVERED_DESTINATION_TYPE");
            this.undeliveredDestinationName = config.getStringElement("UNDELIVERED_DESTINATION_NAME");
        }
        if (requestMode != null && requestMode.equalsIgnoreCase("WS")) {
            this.soapRoles = config.getStringElement("SOAP_ROLES");
            this.wsdlLocation = config.getStringElement("WSDL_LOCATION");
            this.contentReplyTimeout = config.getIntElement("ContentReplyTimeout");
            this.oneway = new Boolean(false);
        } else {
            if (requestMode != null && requestMode.equalsIgnoreCase("Receive")) {
                requestMode = "ContentReply";
            }
            this.oneway = requestMode != null && requestMode.equalsIgnoreCase("ContentReply") ? new Boolean(false) : new Boolean(true);
            if (this.isReceive() || this.isURLReceive()) {
                this.contentReplyTimeout = config.getIntElement("ContentReplyTimeout", 3);
                this.contentReplyTimeout = Math.max(this.contentReplyTimeout, 1);
            } else {
                this.contentReplyTimeout = config.getIntElement("ContentReplyTimeout", 60);
                this.contentReplyTimeout = Math.max(this.contentReplyTimeout, 10);
            }
        }
        this.contentMaps = config.getContentMappings();
    }

    public DirectHttpInConfig clone() throws CloneNotSupportedException {
        return (DirectHttpInConfig)super.clone();
    }

    public boolean isOneway() {
        if (this.oneway == null) {
            return true;
        }
        return this.oneway;
    }

    public final boolean isURLReceive() {
        return this.checkIsReceive(this.receiveURL);
    }

    public final boolean isReceive() {
        return this.checkIsReceive(this.receiveQueue);
    }

    private boolean checkIsReceive(String receiveQueue) {
        return !this.isOneway() && receiveQueue != null;
    }

    public Hashtable getContentMappings() {
        return this.contentMaps;
    }

    public DirectHttpInConfig clonedCopy() {
        try {
            return this.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final boolean isPreserveUndelivered() {
        if (this.preserveUndelivered == null) {
            return false;
        }
        return this.preserveUndelivered;
    }
}

