/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.processingresult;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.Signature;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.ws.security.processingresult.EncryptionSignatureResult;
import com.sonicsw.ws.security.processingresult.ValidationStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SignatureResult
extends EncryptionSignatureResult {
    private final X509Certificate m_signingCert;
    private final Vector m_signedElementQnames;
    private URI m_algSignatureURI = null;
    private URI m_algCanonicalizationURI = null;
    private boolean allRequiredPartsSigned = true;

    public SignatureResult(Element elem, X509Certificate certificate, String tokenRefModel, Vector elemQnames, String algSignature, String algCanonicalization) {
        this.m_element = elem;
        this.m_signingCert = certificate;
        this.m_tokenRefModel = tokenRefModel;
        this.m_signedElementQnames = elemQnames;
        try {
            this.m_algSignatureURI = new URI(algSignature);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            this.m_algCanonicalizationURI = new URI(algCanonicalization);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (DebugObjects.getPolicyDebug().getDebug()) {
            StringBuffer sb = new StringBuffer("SignatureInfo.init: sigature alg uri = ");
            sb.append(this.m_algSignatureURI);
            sb.append(", canonical alg uri = ");
            sb.append(this.m_algCanonicalizationURI);
            sb.append(", signed messgar part(s) = ");
            if (this.m_signedElementQnames != null && !this.m_signedElementQnames.isEmpty()) {
                for (int i = 0; i < this.m_signedElementQnames.size(); ++i) {
                    sb.append((QName)this.m_signedElementQnames.get(i));
                }
            }
            DebugObjects.getPolicyDebug().debug(sb.toString());
        }
    }

    public boolean isUTSigned() {
        return this.m_signingCert == null;
    }

    public X509Certificate getCertificate() {
        return this.m_signingCert;
    }

    public Vector getSignedElementQnames() {
        return this.m_signedElementQnames;
    }

    private void setError(String err) {
        if (this.m_status != null) {
            this.m_status.setError(err);
        }
        this.allRequiredPartsSigned = false;
    }

    private void addSignedPart(QName part) {
        if (this.m_status != null) {
            this.m_status.addMessagePart(part);
        }
    }

    public boolean validate(Signature sig, MessageContext mc, ValidationStatus status) {
        this.m_status = status;
        String policyAlg = null;
        URI policyAlgURI = null;
        policyAlg = sig.getAlgCanonicalization();
        if (policyAlg != null) {
            DebugObjects.getPolicyDebug().debug("SignatureResult: Validating canonicalization alg against policy, expected " + policyAlg);
            try {
                policyAlgURI = new URI(policyAlg);
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
                return false;
            }
            if (this.m_algCanonicalizationURI == null || !this.m_algCanonicalizationURI.equals(policyAlgURI)) {
                DebugObjects.getPolicyDebug().debug("SignatureResult: Validation of canonicalization alg failed, found " + this.m_algCanonicalizationURI);
                this.setError("canonicalization algorithm not matched, expected " + policyAlgURI + ", found " + this.m_algCanonicalizationURI);
                return false;
            }
        }
        if ((policyAlg = sig.getAlgSignature()) != null) {
            DebugObjects.getPolicyDebug().debug("SignatureResult: Validating signature alg against policy, expected " + policyAlg);
            try {
                policyAlgURI = new URI(policyAlg);
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
                return false;
            }
            if (this.m_algSignatureURI == null || !this.m_algSignatureURI.equals(policyAlgURI)) {
                DebugObjects.getPolicyDebug().debug("SignatureResult: Validation of signature alg failed, found " + this.m_algSignatureURI);
                this.setError("signature algorithm not matched, expected " + policyAlgURI + ", found " + this.m_algSignatureURI);
                return false;
            }
        }
        if (!this.validateTokenReference(sig, mc)) {
            return false;
        }
        List requiredTokens = sig.getTokenList();
        if (requiredTokens != null && !requiredTokens.isEmpty()) {
            DebugObjects.getPolicyDebug().debug("SignatureResult: Validating cert against policy...");
            SupportingToken sta = (SupportingToken)requiredTokens.get(0);
            if (!sta.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_X509V3)) {
                DebugObjects.getPolicyDebug().debug("SignatureResult: Security token type required for signature not supported, found " + sta.getTokenType());
                return false;
            }
            String requiredIssuer = sta.getTokenIssuer();
            if (requiredIssuer != null) {
                DebugObjects.getPolicyDebug().debug("SignatureResult: Validating cert issuer against by policy, expected " + requiredIssuer);
                X500Principal requiredIssuerX500Principal = new X500Principal(requiredIssuer);
                if (!requiredIssuerX500Principal.equals(this.m_signingCert.getIssuerX500Principal())) {
                    DebugObjects.getPolicyDebug().debug("SignatureResult: Validation of cert issuer failed, found " + this.m_signingCert.getIssuerX500Principal());
                    return false;
                }
            }
            if (sta.getSubjectName() != null) {
                DebugObjects.getPolicyDebug().debug("SignatureResult: Validating the subject name match, match type = " + sta.getSubjectNameMatchType() + ", expected subject = " + sta.getSubjectName());
                if (!WSSPUtils.match(sta.getSubjectNameMatchType(), sta.getSubjectName(), SignatureResult.parseCN(this.m_signingCert.getSubjectDN().getName()))) {
                    DebugObjects.getPolicyDebug().debug("SignatureResult: Validation of subject name failed, found " + SignatureResult.parseCN(this.m_signingCert.getSubjectDN().getName()));
                    return false;
                }
            }
        }
        DebugObjects.getPolicyDebug().debug("SignatureResult: Validating all required message part(s) are signed...");
        QName[] requiredParts = sig.getPartsAsQNames();
        if (requiredParts != null) {
            for (int i = 0; i < requiredParts.length; ++i) {
                QName requiredPart = requiredParts[i];
                DebugObjects.getPolicyDebug().debug("SignatureResult: required message part = " + requiredPart);
                boolean found = false;
                for (int j = 0; j < this.m_signedElementQnames.size(); ++j) {
                    QName signedPart = (QName)this.m_signedElementQnames.get(j);
                    DebugObjects.getPolicyDebug().debug("SignatureResult: signed message part = " + signedPart);
                    found = requiredPart.equals(signedPart);
                    if (!found) continue;
                    this.addSignedPart(requiredPart);
                    break;
                }
                if (!found) {
                    if (sig.isSP2002()) {
                        String err = "required message part not signed: " + requiredPart;
                        this.setError(err);
                        DebugObjects.getPolicyDebug().debug("SignatureResult:" + err);
                        return false;
                    }
                    NodeList nodes = this.m_element.getOwnerDocument().getElementsByTagNameNS(requiredPart.getNamespaceURI(), requiredPart.getLocalPart());
                    if (nodes.getLength() != 0) {
                        String err = "required signed part found in message but not signed: " + requiredPart;
                        this.setError(err);
                        DebugObjects.getPolicyDebug().debug("SignatureResult:" + err);
                        continue;
                    }
                    this.addSignedPart(requiredPart);
                    DebugObjects.getPolicyDebug().debug("SignatureResult: required signed part not found in message: " + requiredPart);
                    continue;
                }
                DebugObjects.getPolicyDebug().debug("SignatureResult: required signed part found: " + requiredPart);
            }
        }
        return this.allRequiredPartsSigned;
    }

    private static String parseCN(String rdn) {
        if (rdn == null) {
            return null;
        }
        StringTokenizer tknizer = new StringTokenizer(rdn, ",", false);
        while (tknizer.hasMoreElements()) {
            String token = (String)tknizer.nextElement();
            if (!(token = token.trim()).startsWith("CN=")) continue;
            return token.substring(3, token.length());
        }
        return null;
    }
}

