/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Authorize;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.Subject;

final class IsOperationAllowed
extends DebugObject
implements IMessageHandler {
    private AgentRegistrar m_reg;

    IsOperationAllowed(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "IsOperationAllowed handler" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        block15: {
            try {
                boolean ret;
                block14: {
                    Message req = env.getMessage();
                    long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
                    ret = true;
                    String op = null;
                    Subject sub = null;
                    try {
                        op = req.readUTF();
                        sub = new Subject(req.readUTF());
                        if (Config.ENABLE_SECURITY) {
                            if (this.DEBUG) {
                                this.debug("Operation: " + op + ", Subject: " + sub);
                            }
                            int operation = 0;
                            if ("PUBLISH".equals(op)) {
                                operation = 1;
                            } else if ("SUBSCRIBE".equals(op)) {
                                operation = 2;
                            } else if ("GUARANTEE".equals(op)) {
                                operation = 4;
                            }
                            ClientSecurityContext csc = this.m_reg.getClientSecurityContext(requestor);
                            ret = Authorize.checkPermission(csc.getPrincipal(), sub, operation);
                        }
                    }
                    catch (Exception e) {
                        if (!this.DEBUG) break block14;
                        this.debug("Exception: " + e);
                    }
                }
                Message rep = new Message();
                rep.writeBoolean(ret);
                if (this.DEBUG) {
                    this.debug("sending reply");
                }
                s.reply(rep, env);
                if (this.DEBUG) {
                    this.debug("done");
                }
            }
            catch (EInvalidAdminAddress e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block15;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

