/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import progress.message.broker.LogStreamFile;
import progress.message.util.EnhancedOutputStream;

public class LogOutputStream
extends EnhancedOutputStream {
    private LogStreamFile m_file;

    public String toString() {
        return "LogOutputStream " + this.m_file;
    }

    LogOutputStream(LogStreamFile file) throws IOException {
        this.m_file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            this.m_file.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            this.m_file.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_file.lazyFlush();
    }

    public void sync() throws IOException {
        this.m_file.sync();
    }

    public long getFilePointer() throws IOException {
        return this.m_file.getFilePointerWrite();
    }

    public void seek(long pos) throws IOException {
        this.m_file.seekWrite(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInt(int i) throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            this.m_file.writeInt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLong(long i) throws IOException {
        LogStreamFile logStreamFile = this.m_file;
        synchronized (logStreamFile) {
            this.m_file.writeLong(i);
        }
    }
}

