/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.MgramSerializer;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;

public class SyncQueueMsgMoveEvt
extends LogEvent {
    private String m_newQueueName;
    private IMgram m_msg;
    private long m_oldTracking;
    private boolean m_isTemp = false;

    SyncQueueMsgMoveEvt(String queue, IMgram msg, long oldTracking, boolean isTempQueue) {
        this.m_newQueueName = queue;
        this.m_msg = msg;
        if (msg != null) {
            this.setReplicateOnly(msg.isNonPersistentReplicated());
        }
        this.m_oldTracking = oldTracking;
        this.m_isTemp = isTempQueue;
    }

    SyncQueueMsgMoveEvt() {
    }

    @Override
    public short type() {
        return 185;
    }

    public String getNewQueueName() {
        return this.m_newQueueName;
    }

    public IMgram getMessage() {
        return this.m_msg;
    }

    public long getOldTracking() {
        return this.m_oldTracking;
    }

    public boolean isNewTempQueue() {
        return this.m_isTemp;
    }

    @Override
    protected void onFlush() {
    }

    @Override
    public int memSizeBody() {
        return 16 + (this.m_newQueueName.length() << 1) + this.m_msg.serializedLength();
    }

    @Override
    public int streamSizeBody() {
        return this.preMgramSize() + this.m_msg.networkLength();
    }

    @Override
    public int serializedSizeBody() {
        return this.preMgramSize() + this.m_msg.serializedLength();
    }

    private int preMgramSize() {
        byte[] utfqname;
        block2: {
            utfqname = null;
            try {
                utfqname = StringUtil.stringToUTF(this.m_newQueueName);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return 9 + utfqname.length;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreMgram(out);
        MgramSerializer.getMgramSerializer().serialize(out, this.m_msg, false);
    }

    private void writePreMgram(OutputStream os) throws IOException {
        byte[] utfqname = StringUtil.stringToUTF(this.m_newQueueName);
        StreamUtil.writeLong(this.m_oldTracking, os);
        os.write(utfqname, 0, utfqname.length);
        StreamUtil.writeBoolean(this.m_isTemp, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreMgram(os);
        MgramSerializer.getMgramSerializer().serialize(os, this.m_msg, tteTTLConvert);
    }

    private void readPreMgram(InputStream in) throws IOException {
        this.m_oldTracking = StreamUtil.readLong(in);
        this.m_newQueueName = StreamUtil.readUTF(in);
        this.m_isTemp = StreamUtil.readBoolean(in);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.readPreMgram(in);
        this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in, tteTTLConvert);
        this.m_msg.getBrokerHandle().setLocalQueueName(this.m_newQueueName);
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EMgramFormatError {
        this.readPreMgram(in);
        this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in);
        this.m_msg.getBrokerHandle().setLocalQueueName(this.m_newQueueName);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncQueueMsgMove(this);
    }

    @Override
    public String toString() {
        long trk = this.m_msg != null ? this.m_msg.getGuarenteedTrackingNum() : -1L;
        return super.toString() + "SyncQueueMsgMoveEvt: newQueueName= " + this.m_newQueueName + " newtrk= " + trk + " oldtrk= " + this.m_oldTracking + " isTemp= " + this.m_isTemp;
    }
}

