/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.Transaction;
import progress.message.util.DebugState;
import progress.message.xa.XidImpl;
import progress.message.zclient.DebugObject;

class XAResourceManager
extends DebugObject {
    private Hashtable m_txnTable = new Hashtable();

    private XAResourceManager() {
        super(DebugState.GLOBAL_DEBUG_ON ? "XARM" : null);
    }

    static XAResourceManager getXAResourceManager() {
        return XAResourceManagerLazyHolder.INSTANCE;
    }

    void addTransaction(Transaction t) {
        if (!t.isXAtransaction()) {
            return;
        }
        Object xid = t.getXid();
        if (xid instanceof XidImpl) {
            this.addTransaction((XidImpl)xid, t.getTid());
        } else if (this.DEBUG) {
            this.debug("addTransaction(t): wrong Xid type: " + xid.getClass().getName());
        }
    }

    private void addTransaction(XidImpl xid, int tid) {
        Vector txns;
        Integer tidObj = new Integer(tid);
        if (this.m_txnTable.containsKey(xid)) {
            txns = (Vector)this.m_txnTable.get(xid);
            if (txns.contains(tidObj)) {
                return;
            }
        } else {
            txns = new Vector();
        }
        txns.addElement(tidObj);
        this.m_txnTable.put(xid, txns);
        if (this.DEBUG) {
            this.printTxnTable("addTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction(Transaction t) {
        if (!t.isXAtransaction()) {
            return;
        }
        Object xid = t.getXid();
        int tid = t.getTid();
        if (xid instanceof XidImpl) {
            Vector v;
            Hashtable hashtable = this.m_txnTable;
            synchronized (hashtable) {
                v = (Vector)this.m_txnTable.get(xid);
            }
            if (v != null) {
                Integer tidObj = new Integer(tid);
                v.removeElement(tidObj);
                if (v.isEmpty()) {
                    Hashtable hashtable2 = this.m_txnTable;
                    synchronized (hashtable2) {
                        this.m_txnTable.remove(xid);
                    }
                }
            }
        } else if (this.DEBUG) {
            this.debug("removeTransaction: wrong xid type: " + xid.getClass().getName());
        }
        if (this.DEBUG) {
            this.printTxnTable("removeTransaction");
        }
    }

    boolean isThereXid(Object xid) {
        return this.m_txnTable.containsKey(xid);
    }

    private void printTxnTable(String methodName) {
        Enumeration xids = this.m_txnTable.keys();
        if (xids == null || !xids.hasMoreElements()) {
            this.debug(methodName + " m_txnTable: null");
        } else {
            while (xids.hasMoreElements()) {
                XidImpl xid = (XidImpl)xids.nextElement();
                this.debug(methodName + " " + xid + ": " + ((Vector)this.m_txnTable.get(xid)).toString());
            }
        }
    }

    private static class XAResourceManagerLazyHolder {
        private static final XAResourceManager INSTANCE = new XAResourceManager();

        private XAResourceManagerLazyHolder() {
        }
    }
}

