/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.ConnectMessage;
import progress.message.broker.mqtt.proto.MqttVersion;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

public class ConnectEncoder
extends DemuxEncoder<ConnectMessage> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ConnectMessage message, IByteBuffer out) {
        ByteBuffer staticHeaderBuff = new ByteBuffer(10);
        ByteBuffer variableHeaderBuff = new ByteBuffer();
        ByteBuffer buff = new ByteBuffer(12);
        try {
            staticHeaderBuff.merge(MqttCodecUtils.encodeString(MqttVersion.MQTT_3_1_1.getName()));
            staticHeaderBuff.writeByte(MqttVersion.MQTT_3_1_1.getLevel());
            int connectionFlags = 0;
            if (message.isCleanSession()) {
                connectionFlags = (byte)(connectionFlags | 2);
            }
            if (message.isWillFlag()) {
                connectionFlags = (byte)(connectionFlags | 4);
            }
            connectionFlags = (byte)(connectionFlags | (message.getWillQos().value() & 3) << 3);
            if (message.isWillRetain()) {
                connectionFlags = (byte)(connectionFlags | 0x20);
            }
            if (message.isPasswordFlag()) {
                connectionFlags = (byte)(connectionFlags | 0x40);
            }
            if (message.isUserFlag()) {
                connectionFlags = (byte)(connectionFlags | 0x80);
            }
            staticHeaderBuff.writeByte(connectionFlags);
            staticHeaderBuff.writeUnsignedShort(message.getKeepAlive());
            if (message.getClientID() != null) {
                variableHeaderBuff.merge(MqttCodecUtils.encodeString(message.getClientID()));
                if (message.isWillFlag()) {
                    variableHeaderBuff.merge(MqttCodecUtils.encodeString(message.getWillTopic().getName()));
                    variableHeaderBuff.writeUnsignedShort(message.getWillMessage().length);
                    variableHeaderBuff.write(message.getWillMessage());
                }
                if (message.isUserFlag() && message.getUsername() != null) {
                    variableHeaderBuff.merge(MqttCodecUtils.encodeString(message.getUsername()));
                    if (message.isPasswordFlag() && message.getPassword() != null) {
                        variableHeaderBuff.merge(MqttCodecUtils.encodeString(message.getPassword()));
                    }
                }
            }
            int staticHeaderSize = staticHeaderBuff.countUnread();
            int variableHeaderSize = variableHeaderBuff.countUnread();
            byte flags = MqttCodecUtils.encodeFlags(message);
            buff.writeByte(0x10 | flags);
            buff.merge(MqttCodecUtils.encodeRemainingLength(staticHeaderSize + variableHeaderSize));
            buff.merge(staticHeaderBuff);
            buff.merge(variableHeaderBuff);
            out.merge(buff);
        }
        finally {
            staticHeaderBuff.clear();
            buff.clear();
            variableHeaderBuff.clear();
        }
    }
}

