/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import progress.message.crypto.DES;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.SHA;

public abstract class DESString {
    protected abstract byte[] getSalt();

    protected final String DESEncrypt(String clear_text_phrase) throws IOException {
        int x;
        int datasize = clear_text_phrase.length();
        int pad = DES.computePad(datasize);
        byte[] input = new byte[datasize + pad];
        System.arraycopy(clear_text_phrase.getBytes(), 0, input, 0, datasize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(datasize);
        byte[] key = new byte[8];
        SHA sha = new SHA();
        System.arraycopy(MessageDigest.hash(this.getSalt(), (MessageDigest)sha), 6, key, 0, 8);
        DES des = new DES();
        des.init(1, key);
        byte[] output = new byte[input.length];
        des.doFinal(input, 0, input.length, output, 0);
        dos.write(output);
        for (x = 0; x < input.length; ++x) {
            input[x] = 0;
        }
        for (x = 0; x < output.length; ++x) {
            output[x] = 0;
        }
        for (x = 0; x < key.length; ++x) {
            key[x] = 0;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    protected final String DESDecrypt(String encoded_phrase) throws IOException {
        byte[] tmp_data = Base64.getDecoder().decode(encoded_phrase);
        ByteArrayInputStream bais = new ByteArrayInputStream(tmp_data);
        DataInputStream dis = new DataInputStream(bais);
        int datasize = dis.readInt();
        if (datasize < 0) {
            throw new IOException("Unable to decrypt data.  Verify that the data is encrypted.");
        }
        int pad = 0;
        int invpad = datasize % 8;
        if (invpad > 0) {
            pad = 8 - invpad;
        }
        byte[] data = new byte[datasize + pad];
        dis.read(data);
        byte[] key = new byte[8];
        SHA sha = new SHA();
        System.arraycopy(MessageDigest.hash(this.getSalt(), (MessageDigest)sha), 6, key, 0, 8);
        DES des = new DES();
        des.init(2, key);
        tmp_data = new byte[data.length];
        des.doFinal(data, 0, data.length, tmp_data, 0);
        sha.add(tmp_data);
        byte[] hash = sha.digest();
        data = new byte[datasize];
        System.arraycopy(tmp_data, 0, data, 0, datasize);
        tmp_data = null;
        return new String(data);
    }
}

