/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db;

import java.util.Enumeration;
import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.db.DBVersionInfo;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.db.prAccessor;
import progress.message.dbsc.ISchemaDef;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public abstract class Db
extends DebugObject {
    private static Vector m_DatabaseList = new Vector();
    private static boolean LOCAL_DEBUG = false;
    private String m_instanceName;
    private boolean m_instanceNameQuoted = false;
    private String m_ident = "broker";
    static int DB_MAX_TABLE_NAME_LENGTH = 30;
    static int DB_MAX_BROKER_NAME_LENGTH = 15;
    boolean DEBUG1 = (this.debugFlags & 0x40) > 0;

    public Db(String brokerInstance) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Db" : null);
        this.m_instanceName = brokerInstance;
        this.m_instanceNameQuoted = this.isInstanceIntl() || this.isInstanceSpecial();
        m_DatabaseList.addElement(this);
    }

    public String rootName(String baseName) {
        return this.retrieveName(baseName);
    }

    protected void checkDBObjNameLength(String objNameSuffix) throws EBrokerNameTooLong {
        if (this.m_instanceName.length() > DB_MAX_BROKER_NAME_LENGTH) {
            throw new EBrokerNameTooLong();
        }
        if (objNameSuffix.length() > DB_MAX_TABLE_NAME_LENGTH - DB_MAX_BROKER_NAME_LENGTH) {
            throw new EAssertFailure("Table name " + objNameSuffix + " is longer than " + (DB_MAX_TABLE_NAME_LENGTH - DB_MAX_BROKER_NAME_LENGTH) + " characters");
        }
    }

    public String table(String baseName) {
        return this.retrieveName(baseName);
    }

    private String retrieveName(String baseName) {
        if (this.m_instanceNameQuoted) {
            String s = "\"" + this.m_instanceName + baseName + "\"";
            return s.toUpperCase();
        }
        return this.m_instanceName + baseName;
    }

    public static int getMaxNameLength() {
        return DB_MAX_TABLE_NAME_LENGTH;
    }

    public String getBrokerName() {
        return this.m_instanceName;
    }

    public abstract void start() throws EDatabaseException, EDatabaseNotExists;

    public abstract void createNewDb() throws EDatabaseException;

    public abstract void close() throws EDatabaseException;

    protected abstract void onShutdown() throws EGeneralException, EDatabaseException;

    protected abstract DBVersionInfo getDBVersionInfo() throws EDatabaseException;

    protected abstract void setDBVersionInfo(DBVersionInfo var1) throws EDatabaseException;

    public void initPingDatabase() throws EDatabaseException {
    }

    public abstract void pingDatabase() throws EDatabaseException;

    public abstract boolean isRemoteDb();

    public void setDBVersion() throws EDatabaseException {
        DBVersionInfo vers = new DBVersionInfo();
        vers.m_major_version_in_database = 14;
        vers.m_minor_version_in_database = 0;
        vers.m_rel_tables_version_in_database = 0;
        vers.m_abs_tables_version_in_database = this.getLatestSupportedDbVersion();
        vers.m_build_number_in_database = 692;
        vers.m_release_name_in_database = SessionConfig.RELEASE_NAME;
        vers.m_version_in_database = null;
        this.setDBVersionInfo(vers);
    }

    public abstract boolean seemsConfigured() throws EDatabaseException;

    public abstract boolean seemsConfiguredDD() throws EDatabaseException;

    public abstract ISchemaDef getSchemaDef();

    public abstract String getDDName();

    public int getLatestSupportedDbVersion() {
        return 702000;
    }

    public boolean isUpgradable(int vers) {
        return SessionConfig.isBrokerDBVersionUpgradable(vers);
    }

    public void checkDBVersion() throws EDatabaseException {
        boolean version_mismatch = true;
        DBVersionInfo vers = this.getDBVersionInfo();
        if (vers.m_abs_tables_version_in_database == this.getLatestSupportedDbVersion()) {
            version_mismatch = false;
        }
        if (version_mismatch) {
            throw new EDatabaseException(prAccessor.getString("STR003") + this.m_ident + prAccessor.getString("STR004") + vers.m_version_in_database + prAccessor.getString("STR005") + SessionConfig.RELEASE_NAME + " (" + prAccessor.getString("BUILD") + 692 + ").");
        }
    }

    public int checkUpgrade() throws EDatabaseException {
        DBVersionInfo vers = this.getDBVersionInfo();
        if (this.DEBUG) {
            this.debug("checkUpgrade version of db tables= " + vers.m_abs_tables_version_in_database + " broker dbversion= " + this.getLatestSupportedDbVersion());
        }
        if (vers.m_abs_tables_version_in_database == this.getLatestSupportedDbVersion()) {
            return vers.m_abs_tables_version_in_database;
        }
        if (this.isUpgradable(vers.m_abs_tables_version_in_database)) {
            return vers.m_abs_tables_version_in_database;
        }
        throw new EDatabaseException(prAccessor.getString("CANT_UPGRADE") + this.m_ident + prAccessor.getString("STR004") + vers.m_version_in_database + prAccessor.getString("STR005") + SessionConfig.RELEASE_NAME + " (" + prAccessor.getString("BUILD") + 692 + ").");
    }

    public static void shutdown() {
        if (LOCAL_DEBUG) {
            Db.class_debug("Database", "Shutting down database...");
        }
        Enumeration databases = m_DatabaseList.elements();
        Db db = null;
        while (databases.hasMoreElements()) {
            db = (Db)databases.nextElement();
            try {
                db.close();
            }
            catch (EGeneralException eGeneralException) {}
        }
        databases = m_DatabaseList.elements();
        db = null;
        while (databases.hasMoreElements()) {
            db = (Db)databases.nextElement();
            try {
                db.onShutdown();
            }
            catch (EGeneralException eGeneralException) {}
        }
    }

    private boolean isInstanceIntl() {
        int i = 0;
        while (i < this.m_instanceName.length()) {
            if (this.m_instanceName.charAt(i++) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private boolean isInstanceSpecial() {
        int i = 0;
        while (i < this.m_instanceName.length()) {
            char ch;
            if (!((ch = this.m_instanceName.charAt(i++)) == '_' ? i == 1 : !Character.isLetterOrDigit(ch))) continue;
            return true;
        }
        return false;
    }

    public static String buildDbVersionString(String releaseNameInDb, int buildNumInDb) {
        return releaseNameInDb + " (" + prAccessor.getString("BUILD") + buildNumInDb + ")";
    }
}

